package org.nuiton.io.rest;
/*
 * #%L
 * Helper Maven Plugin
 * $Id: AbstractRequestFactory.java 867 2012-10-25 06:45:19Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/maven-helper-plugin/tags/maven-helper-plugin-1.6/src/main/java/org/nuiton/io/rest/AbstractRequestFactory.java $
 * %%
 * Copyright (C) 2009 - 2012 Tony Chemit, CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.ArrayUtils;

import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Map;

/**
 * Abstract implementation of {@link RequestFactory}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.5
 * @deprecated since 1.6, see http://nuiton.org/issues/2355, will be removed and not replaced in version 2.0
 */
@Deprecated
public abstract class AbstractRequestFactory implements RequestFactory {

    public static final DateFormat DATE_FORMAT =
            new SimpleDateFormat("yyyy-MM-dd");

    /** registred requests */
    protected final Map<String, RestRequestBuilder> requestBuilders;

    public AbstractRequestFactory() {
        requestBuilders = Maps.newTreeMap();
    }

    /** {@inheritDoc} */
    @Override
    public void addRequestBuilder(RestRequestBuilder builder) {
        String name = builder.getName();
        if (requestBuilders.containsKey(name)) {
            throw new IllegalArgumentException("a request builder with name " +
                                               name + " already exists.");
        }
        requestBuilders.put(name, builder);
    }

    /** {@inheritDoc} */
    @Override
    public RestRequest getRequest(String id, Object... args) {

        RestRequest r;
        RestRequestBuilder builder = getRequestBuilder(id);
        if (builder == null) {

            throw new IllegalArgumentException(
                    "Could not find any request builder for request named '" +
                    id + "'");
        }
        r = builder.create(args);
        if (r == null) {
            throw new IllegalArgumentException(
                    "Could not find any request named '" + id +
                    "' using builder " + builder);
        }
        return r;
    }

    /** {@inheritDoc} */
    @Override
    public RestRequestBuilder getRequestBuilder(String id) {
        RestRequestBuilder builder = requestBuilders.get(id);

        return builder;
    }

    /**
     * Abstract implementation of a {@link RestRequestBuilder}.
     *
     * @author tchemit <chemit@codelutin.com>
     * @since 1.5
     */
    protected static abstract class AbstractRequestBuilder implements RestRequestBuilder {

        private static final long serialVersionUID = 1L;

        /**
         * Name of the request builder.
         *
         * @since 1.5
         */
        protected String name;

        /**
         * Actions of the request (will by default give path of the request).
         *
         * @since 1.5
         */
        protected String[] action;

        /**
         * REST Method to use for this request.
         *
         * @see RestMethod
         * @since 1.5
         */
        protected final RestMethod method;

        public AbstractRequestBuilder(String name,
                                      RestMethod method,
                                      String... action) {
            this.name = name;
            this.action = action;
            this.method = method;
        }

        @Override
        public String getName() {
            return name;
        }

        @Override
        public String[] getParameters(Object... args) {
            // by default, no parameter
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }

        @Override
        public String[] getPath(Object... args) {
            // by default, path is extactly action
            return action;
        }

        @Override
        public Map<String, File> getAttachments(Object... args) {
            // by default, no attachments
            return null;
        }

        @Override
        public Map<String, String> getHeaders(Object... args) {
            // by default no header
            return null;
        }

        @Override
        public RestRequest create(final Object... args) {

            checkRequestArgs(args);

            return new RestRequest() {

                @Override
                public String[] getPath() {
                    return AbstractRequestBuilder.this.getPath(args);
                }

                @Override
                public String[] getParameters() {
                    return AbstractRequestBuilder.this.getParameters(args);
                }

                @Override
                public Map<String, File> getAttachments() {
                    return AbstractRequestBuilder.this.getAttachments(args);
                }

                @Override
                public Map<String, String> getHeaders() {
                    return AbstractRequestBuilder.this.getHeaders(args);
                }

                @Override
                public boolean containsAttachments() {
                    Map<String, File> attachments = getAttachments();
                    return attachments != null && !attachments.isEmpty();
                }

                @Override
                public String toPath(String redmineUrl) {
                    String result = redmineUrl + "/" +
                                    Joiner.on('/').join(getPath());
                    return result;
                }

                @Override
                public RestMethod getMethod() {
                    return method;
                }

            };
        }

        protected void checkRequestArgs(int nbRequires,
                                        String requires,
                                        Object... args) {
            Preconditions.checkState(
                    args.length == nbRequires,
                    nbRequires == 0 ?
                    "The request " + getName() + " requires no arg " +
                    "but had: " + Arrays.toString(args)
                                    :
                    "The request " + getName() + " requires " +
                    nbRequires + " args: " + "(" + requires + "), but had: " +
                    Arrays.toString(args));
        }
    }

}
