/*
 * #%L
 * EUGene :: Maven plugin
 * 
 * $Id: CopyVersionFiles.java 915 2010-06-08 15:48:48Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/eugene/tags/eugene-2.0.2/maven-eugene-plugin/src/main/java/org/nuiton/eugene/plugin/CopyVersionFiles.java $
 * %%
 * Copyright (C) 2006 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.eugene.plugin;

import org.nuiton.plugin.PluginIOContext;
import java.io.File;
import java.util.List;

import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.dom4j.Document;
import org.nuiton.plugin.PluginHelper;

/**
 * Copy a file set to a versionned directory structure.
 * 
 * @author chatellier
 * 
 * @version $Revision: 915 $
 * 
 * Last update : $Date: 2010-06-08 17:48:48 +0200 (mar., 08 juin 2010) $ By : *
 * @goal copyVersionFiles
 * @deprecated since 2.0.2, will not be replaced (ToPIA migration service does not need old mapping files any longer).
 */
@Deprecated
public class CopyVersionFiles extends EugeneAbstractMojo { //implements FileFilter {

    /**
     * Les entrées sorties du plugin.
     *
     * <p/>
     *
     * En entrée on demande des répertoires où chercher les fichiers
     * objectmodel a convertir.
     * <p/>
     * En sortie on demande le répertoire ou generer les classes java.
     * <p/>
     * Par défaut on a les valeurs suivantes :
     * </p>
     * <pre>
     * &lt;copyVersionResources&gt;
     * </p>
     * &lt;input&gt;target/generated-sources/models&lt;/input&gt;
     * </p>
     * &lt;output&gt;target/generated-sources/java&lt;/output&gt;
     * </p>
     * &lt;/copyVersionResources&gt;
     * </pre>
     * </p>
     *
     * Note: si {@link #testPhase} est activée, les valeurs par défaut sont :
     * </p>
     * <pre>
     * &lt;copyVersionResources&gt;
     * </p>
     * &lt;input&gt;target/generated-sources/test-models&lt;/input&gt;
     * </p>
     * &lt;output&gt;target/generated-sources/test-java&lt;/output&gt;
     * </p>
     * &lt;/copyVersionResources&gt;
     * </pre>
     *
     * @parameter
     * @since 1.0.0-rc-8
     */
    protected PluginIOContext copyVersionResources;
    /**
     * Fichiers objectModel a lire pour determiner la version.
     *
     * @parameter expression="${generator.includes}" default-value="*.*model"
     * @since 0.51
     */
    protected String includes;
    /**
     * Le dossier de destination des fichiers copiés.
     *
     * Doit contenir un nom de modele : <tt>%MODELNAME%</tt>
     *
     * @parameter expression="${generator.copyVersionDir}"
     * @since 0.51
     * @required
     */
    protected String copyVersionDir;
    /**
     * Les mappings a sauvegarder
     *
     * @parameter expression="${generator.copyVersionFiles}"
     * @since 0.51
     * @required
     */
    protected String copyVersionFiles;
    /**
     * Version trouvee dans les fichiers objectModel.
     *
     * Type string, parce que elle peut avoir la forme "1.3.2" par exemple
     */
    protected String versionFound;
    /**
     * Nom du model sauvegarde
     */
    protected String modelNameFound;
    /**
     * Dossier incluant le nom de la version
     */
    protected File fVersionDir;

    @Override
    public void doAction() throws Exception {

        getLog().warn("---- Warning -----\n\n" +
                      "This goal is deprecated since version 2.0.2 and will be removed in version 2.1\n\n" +
                      "---- Warning -----");
        
        File srcModelDir = copyVersionResources.getInputs()[0];

        List<File> modelFiles = PluginHelper.getIncludedFiles(
                srcModelDir,
                new String[]{includes},
                null
        );

        if (modelFiles.isEmpty()) {
            getLog().warn("No model file found.");
            return;
        }
        
        //FIXME TC-20090820 this is a bit funny iterate and keep the last
        //FIXME TC-20090820 model values ?
        // should iterate and do the treatment for each model
        for (File modelFile : modelFiles) {
            if (getLog().isDebugEnabled()) {
                getLog().debug("Try to find version on file " + modelFile);
            }
            SAXReader saxR = new SAXReader();
            Document document;
            try {
                document = saxR.read(modelFile);
                Node node;
                node = document.selectSingleNode("/objectModel/@version");
                if (node != null) {
                    versionFound = node.getStringValue();
                }
                node = document.selectSingleNode("/objectModel/@name");
                if (node != null) {
                    modelNameFound = node.getStringValue();
                }
            } catch (DocumentException e) {
                getLog().error("Can't read document", e);
            }
        }
        //TODO-TC20100403 : should use VersionUtil to detects a version ?
        if (versionFound == null ||
            !versionFound.matches("[0-9]+(\\.[0-9]+)*")) {
            versionFound = "0";
            getLog().info(
                    "No version found in model files, setting version to '" +
                    versionFound + "'");
        } else {
            getLog().info("Version '" + versionFound +
                          "' found in model description");
        }

        String destDir = copyVersionDir.replace("%MODELNAME%", modelNameFound)
                         + File.separator + versionFound;
        fVersionDir = new File(destDir);

        if (getLog().isDebugEnabled()) {
            getLog().debug("destination directory : " + fVersionDir);
        }

        boolean exist = false;

        if (!overwrite) {

            if (fVersionDir.exists() && fVersionDir.listFiles().length > 0) {
                getLog().warn(
                        "[COPY] Warning saved files for version '" +
                        versionFound + "' and name '" + modelNameFound +
                        "' already exists");
                getLog().warn(
                        "[COPY] Copy won't be done unless copyOverwrite " +
                        "parameter is set to 'true' or version is updated");

                exist = true;
            }
        }

        if (!exist) {

            // copy back mappings to fVersionDir
            
            if (getLog().isDebugEnabled()) {
                getLog().debug("copy files from  " +
                               copyVersionResources.getOutput());
            }
            PluginHelper.copyFiles(
                    copyVersionResources.getOutput(),
                    fVersionDir,
                    new String[]{copyVersionFiles},
                    null,
                    true
            );
        }
    }

    @Override
    protected PluginIOContext getResources() {
        return copyVersionResources;
    }

    @Override
    protected PluginIOContext initResources() {

        File defaultIn = getFileFromBasedir("target", "generated-sources",
                                            "models");
        File defaultOut = getFileFromBasedir("target", "generated-sources",
                                             "java");

        File defaultTestIn = getFileFromBasedir("target", "generated-sources",
                                                "test-models");
        File defaultTestOut = getFileFromBasedir("target", "generated-sources",
                                                 "test-java");

        copyVersionResources = initResources(
                defaultIn,
                defaultOut,
                defaultTestIn,
                defaultTestOut
        );

        return copyVersionResources;
    }
}
