package org.nuiton.eugene.plugin.writer;

import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.nuiton.eugene.AbstractModelFileWriter;

/**
 * Surcharge de l'implentation abstraite pour avoir le logger de la console maven.
 *
 * @author tchemit
 * @since 2.0.0
 */
public abstract class BaseModelFileWriter extends AbstractModelFileWriter {

    /**
     * Logger
     */
    private Log log;
    public static final String PROP_CLASS_LOADER = "classLoader";

    public void setLog(Log log) {
        this.log = log;
    }

    public Log getLog() {
        if (log == null) {
            log = new SystemStreamLog();
        }

        return log;
    }

    public ClassLoader getClassLoader() {
        return getProperty(PROP_CLASS_LOADER, ClassLoader.class);
    }


}