/* *##% Plugin maven Generator
 * Copyright (C) 2006 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*/
package org.nuiton.eugene.plugin;

import java.io.File;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

/**
 * Converti les fichiers XMI en fichier StateModel
 * 
 * @goal xmi2statemodel
 */
public class Xmi2StateModel extends Xmi2Model {

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        getLog().info("Conversion of XMI files into StateModel");
        super.execute();
    }

    @Override
    protected String getExtension() {
        return "statemodel";
    }

    @Override
    protected String getStyleSheet(File model) {
        //TODO when StateModel will be supported in 2.1, compute the version to resolve the correct stylesheet
        return "xmi1.2ToStateModel.xsl";
    }
}
