package org.nuiton.eugene.test.beangen;
 
 import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang.builder.ToStringBuilder;

public class RelationDTO implements java.io.Serializable {

    public int idCompany;
    public int idDepartement;
    public Date dateDebut;
    public PersonneDTO person;
    protected final PropertyChangeSupport pcs;

    /**
     * Default constructor of RelationDTO.
     */
    public RelationDTO() {
        pcs = new PropertyChangeSupport(this);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(propertyName, listener);
    }

    public int getIdCompany() {
        return idCompany;
    }

    public int getIdDepartement() {
        return idDepartement;
    }

    public Date getDateDebut() {
        return dateDebut;
    }

    public PersonneDTO getPerson() {
        return person;
    }

    public void setIdCompany(int newValue) {
        int oldValue = getIdCompany();
        this.idCompany = newValue;
        firePropertyChange("idCompany", oldValue, newValue);
    }

    public void setIdDepartement(int newValue) {
        int oldValue = getIdDepartement();
        this.idDepartement = newValue;
        firePropertyChange("idDepartement", oldValue, newValue);
    }

    public void setDateDebut(Date newValue) {
        Date oldValue = getDateDebut();
        this.dateDebut = newValue;
        firePropertyChange("dateDebut", oldValue, newValue);
    }

    public void setPerson(PersonneDTO newValue) {
        PersonneDTO oldValue = getPerson();
        this.person = newValue;
        firePropertyChange("person", oldValue, newValue);
    }


    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
         append("idCompany", this.idCompany).
         append("idDepartement", this.idDepartement).
         append("dateDebut", this.dateDebut).
         append("person", this.person).
         toString();
        return result;
    }
 
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
      pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

} //RelationDTO
