/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.plugin.modelextension;

import java.io.File;
import java.io.IOException;
import org.nuiton.eugene.models.object.reader.extension.ModelExtensionFileParser;
import org.nuiton.eugene.models.object.reader.extension.ModelExtensionFileParserCallback;
import org.nuiton.eugene.models.object.reader.extension.ModelExtensionFileParserFactory;
import org.nuiton.eugene.models.stereotype.InvalidStereotypeSyntaxException;
import org.nuiton.eugene.models.tagvalue.InvalidTagValueSyntaxException;
import org.nuiton.eugene.plugin.modelextension.ElementBean;
import org.nuiton.eugene.plugin.modelextension.ModelBean;

public class ModelBeanBuilder
implements ModelExtensionFileParserCallback {
    protected final ModelBean modelBean;
    protected int modelStereotypeHits;
    protected int modelTagValueHits;
    protected int packageStereotypeHits;
    protected int packageTagValueHits;
    protected int classStereotypeHits;
    protected int classTagValueHits;
    protected int classAttributeStereotypeHits;
    protected int classAttributeTagValueHits;
    protected boolean strictLoading;

    public ModelBeanBuilder(boolean strictLoading, String modelName) {
        this.modelBean = new ModelBean(modelName);
    }

    public ModelBean build() {
        return this.modelBean;
    }

    public int getStereotypeHits() {
        return this.modelStereotypeHits + this.packageStereotypeHits + this.classStereotypeHits + this.classAttributeStereotypeHits;
    }

    public int getTagValueHits() {
        return this.modelTagValueHits + this.packageTagValueHits + this.classTagValueHits + this.classAttributeTagValueHits;
    }

    public int getModelStereotypeHits() {
        return this.modelStereotypeHits;
    }

    public int getModelTagValueHits() {
        return this.modelTagValueHits;
    }

    public int getPackageStereotypeHits() {
        return this.packageStereotypeHits;
    }

    public int getPackageTagValueHits() {
        return this.packageTagValueHits;
    }

    public int getClassStereotypeHits() {
        return this.classStereotypeHits;
    }

    public int getClassTagValueHits() {
        return this.classTagValueHits;
    }

    public int getClassAttributeStereotypeHits() {
        return this.classAttributeStereotypeHits;
    }

    public int getClassAttributeTagValueHits() {
        return this.classAttributeTagValueHits;
    }

    public boolean onModelTagValueFound(String tag, String value) {
        this.addTagValue(this.modelBean, tag, value);
        ++this.modelTagValueHits;
        return true;
    }

    public boolean onModelStereotypeFound(String stereotype) {
        this.addStereotype(this.modelBean, stereotype);
        ++this.modelStereotypeHits;
        return true;
    }

    public boolean onPackageTagValueFound(String packageName, String tag, String value) {
        this.addTagValue(this.modelBean.getOrCreatePackage(packageName), tag, value);
        ++this.packageTagValueHits;
        return true;
    }

    public boolean onPackageStereotypeFound(String packageName, String stereotype) {
        this.addStereotype(this.modelBean.getOrCreatePackage(packageName), stereotype);
        ++this.packageStereotypeHits;
        return true;
    }

    public boolean onClassTagValueFound(String className, String tag, String value) {
        this.addTagValue(this.modelBean.getOrCreateClass(className), tag, value);
        ++this.classTagValueHits;
        return true;
    }

    public boolean onClassStereotypeFound(String className, String stereotype) {
        this.addStereotype(this.modelBean.getOrCreateClass(className), stereotype);
        ++this.classStereotypeHits;
        return true;
    }

    public boolean onAttributeTagValueFound(String className, String attributeName, String tag, String value) {
        this.addTagValue(this.modelBean.getOrCreateClassAttribute(className, attributeName), tag, value);
        ++this.classAttributeTagValueHits;
        return true;
    }

    public boolean onAttributeStereotypeFound(String className, String attributeName, String stereotype) {
        this.addStereotype(this.modelBean.getOrCreateClassAttribute(className, attributeName), stereotype);
        ++this.classAttributeStereotypeHits;
        return true;
    }

    public void addFile(File inputFile) throws InvalidTagValueSyntaxException, InvalidStereotypeSyntaxException, IOException {
        ModelExtensionFileParser parser = ModelExtensionFileParserFactory.newParser((boolean)this.strictLoading, (File)inputFile);
        parser.parse(inputFile, (ModelExtensionFileParserCallback)this);
    }

    protected void addTagValue(ElementBean elementBean, String tag, String value) {
        elementBean.getTagValues().put(tag, value);
    }

    protected void addStereotype(ElementBean elementBean, String stereotype) {
        elementBean.getStereotypes().add(stereotype);
    }
}

