/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.plugin.modelextension;

import java.util.Set;
import java.util.TreeSet;
import org.nuiton.eugene.plugin.modelextension.AttributeBean;
import org.nuiton.eugene.plugin.modelextension.ClassBean;
import org.nuiton.eugene.plugin.modelextension.ElementBean;
import org.nuiton.eugene.plugin.modelextension.PackageBean;

public class ModelBean
extends ElementBean {
    protected final Set<PackageBean> packages = new TreeSet<PackageBean>();
    protected final Set<ClassBean> classes = new TreeSet<ClassBean>();

    public ModelBean(String name) {
        super(name);
    }

    public Set<PackageBean> getPackages() {
        return this.packages;
    }

    public Set<ClassBean> getClasses() {
        return this.classes;
    }

    public PackageBean getOrCreatePackage(String packageName) {
        PackageBean result = null;
        for (PackageBean packageBean : this.packages) {
            if (!packageName.equals(packageBean.name)) continue;
            result = packageBean;
            break;
        }
        if (result == null) {
            result = new PackageBean(packageName);
            this.packages.add(result);
        }
        return result;
    }

    public ClassBean getOrCreateClass(String className) {
        ClassBean result = null;
        for (ClassBean packageBean : this.classes) {
            if (!className.equals(packageBean.name)) continue;
            result = packageBean;
            break;
        }
        if (result == null) {
            result = new ClassBean(className);
            this.classes.add(result);
        }
        return result;
    }

    public AttributeBean getOrCreateClassAttribute(String className, String attributeName) {
        ClassBean classBean = this.getOrCreateClass(className);
        return classBean.getOrCreateAttribute(attributeName);
    }

    public boolean withClasses() {
        return !this.classes.isEmpty();
    }

    public boolean withPackages() {
        return !this.packages.isEmpty();
    }
}

