/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.plugin;

import com.google.common.io.Files;
import java.io.File;
import java.io.FilenameFilter;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.SystemUtils;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.nuiton.eugene.plugin.modelextension.ClassBean;
import org.nuiton.eugene.plugin.modelextension.ModelBean;
import org.nuiton.eugene.plugin.modelextension.ModelBeanBuilder;
import org.nuiton.eugene.plugin.modelextension.PackageBean;
import org.nuiton.plugin.AbstractPlugin;

@Mojo(name="transform-flat-properties-to-compact")
public class TransformFlatPropertiesToCompactMojo
extends AbstractPlugin {
    @Parameter(property="eugene.modelName", required=true)
    protected String modelName;
    @Parameter(property="eugene.directory", defaultValue="${project.basedir}/src/main/xmi", required=true)
    protected File directory;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(property="eugene.dryRun")
    protected boolean dryRun;
    @Parameter(property="eugene.verbose", defaultValue="${maven.verbose}")
    protected boolean verbose;
    @Parameter(property="eugene.encoding", defaultValue="${project.build.sourceEncoding}")
    protected String encoding;
    protected File[] inputFiles;
    protected File outputFile;
    protected String eol;

    protected void init() throws Exception {
        this.eol = SystemUtils.LINE_SEPARATOR;
        this.inputFiles = this.directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".properties");
            }
        });
        this.getLog().info((CharSequence)("Found " + this.inputFiles.length + " model extension properties file(s)."));
        this.outputFile = new File(this.directory, this.modelName + ".objectmodel-ext");
    }

    protected void doAction() throws Exception {
        ModelBeanBuilder modelBeanBuilder = new ModelBeanBuilder(false, this.modelName);
        for (File inputFile : this.inputFiles) {
            modelBeanBuilder.addFile(inputFile);
        }
        ModelBean modelBean = modelBeanBuilder.build();
        this.getLog().info((CharSequence)(modelBeanBuilder.getStereotypeHits() + " stereotype(s) detected."));
        this.getLog().info((CharSequence)(modelBeanBuilder.getTagValueHits() + " tag value(s) detected."));
        StringBuilder result = new StringBuilder();
        result.append("[model]").append(this.eol);
        this.appendMap(modelBean.getTagValues(), "", "tagvalues", result);
        this.appendSet(modelBean.getStereotypes(), "", "stereotypes", result);
        result.append(this.eol).append("[package]").append(this.eol);
        if (modelBean.withPackages()) {
            for (PackageBean packageBean : modelBean.getPackages()) {
                result.append(packageBean.getName()).append(this.eol);
                this.appendMap(packageBean.getTagValues(), "  ", "tagvalues", result);
                this.appendSet(packageBean.getStereotypes(), "  ", "stereotypes", result);
            }
        }
        result.append(this.eol).append("[class]").append(this.eol);
        if (modelBean.withClasses()) {
            for (ClassBean classBean : modelBean.getClasses()) {
                result.append(classBean.getName()).append(this.eol);
                this.appendMap(classBean.getTagValues(), "  ", "tagvalues", result);
                this.appendSet(classBean.getStereotypes(), "  ", "stereotypes", result);
                this.appendMap(classBean.getAttributesTagValues(), "  ", "attributes.tagvalues", result);
                this.appendSet(classBean.getAttributesStereotypes(), "  ", "attributes.stereotypes", result);
            }
        }
        if (this.dryRun) {
            this.getLog().info((CharSequence)("\n\nDryRun mode\ncontent:\n\n" + result.toString() + "\n\n"));
        } else {
            this.getLog().info((CharSequence)("Generate to: " + this.outputFile));
            Files.write((CharSequence)result.toString(), (File)this.outputFile, (Charset)Charset.forName(this.encoding));
        }
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    protected void appendMap(Map<String, String> map, String prefix, String name, StringBuilder result) {
        if (!map.isEmpty()) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                result.append(prefix).append(entry.getKey()).append(" ").append(entry.getValue()).append(this.eol);
            }
        }
    }

    protected void appendSet(Set<String> set, String prefix, String name, StringBuilder result) {
        if (!set.isEmpty()) {
            for (String stereotype : set) {
                result.append(prefix).append(stereotype).append(this.eol);
            }
        }
    }
}

