/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.util.Arrays;
import org.neo4j.values.AnyValue;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.storable.IntegralArray;
import org.neo4j.values.storable.NumberValues;
import org.neo4j.values.storable.PrimitiveArrayValues;
import org.neo4j.values.storable.PrimitiveArrayWriting;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;

public abstract class LongArray
extends IntegralArray {
    abstract long[] value();

    @Override
    public int length() {
        return this.value().length;
    }

    @Override
    public long longValue(int index) {
        return this.value()[index];
    }

    @Override
    public int computeHash() {
        return NumberValues.hash(this.value());
    }

    @Override
    public boolean equals(Value other) {
        return other.equals(this.value());
    }

    @Override
    public boolean equals(byte[] x) {
        return PrimitiveArrayValues.equals(x, this.value());
    }

    @Override
    public boolean equals(short[] x) {
        return PrimitiveArrayValues.equals(x, this.value());
    }

    @Override
    public boolean equals(int[] x) {
        return PrimitiveArrayValues.equals(x, this.value());
    }

    @Override
    public boolean equals(long[] x) {
        return Arrays.equals(this.value(), x);
    }

    @Override
    public boolean equals(float[] x) {
        return PrimitiveArrayValues.equals(this.value(), x);
    }

    @Override
    public boolean equals(double[] x) {
        return PrimitiveArrayValues.equals(this.value(), x);
    }

    @Override
    public final boolean eq(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof SequenceValue) {
            return this.equals((SequenceValue)other);
        }
        return other instanceof Value && this.equals((Value)other);
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        PrimitiveArrayWriting.writeTo(writer, this.value());
    }

    @Override
    public Object asObjectCopy() {
        return this.value().clone();
    }

    @Override
    public String prettyPrint() {
        return Arrays.toString(this.value());
    }

    @Override
    @Deprecated
    public Object asObject() {
        return this.value();
    }

    @Override
    public AnyValue value(int offset) {
        return Values.longValue(this.longValue(offset));
    }

    static final class Direct
    extends LongArray {
        final long[] value;

        Direct(long[] value) {
            assert (value != null);
            this.value = value;
        }

        @Override
        long[] value() {
            return this.value;
        }

        public String toString() {
            return String.format("LongArray%s", Arrays.toString(this.value()));
        }
    }
}

