/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.quartz.jobs;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleMessage;
import org.mule.transport.AbstractConnector;
import org.mule.transport.AbstractMessageReceiver;
import org.mule.transport.NullPayload;
import org.mule.transport.quartz.i18n.QuartzMessages;
import org.mule.transport.quartz.jobs.AbstractJob;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class EventGeneratorJob
extends AbstractJob {
    protected transient Log logger = LogFactory.getLog(this.getClass());

    @Override
    protected void doExecute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        JobDataMap map = jobExecutionContext.getJobDetail().getJobDataMap();
        String receiverKey = (String)map.get((Object)"mule.quartz.receiver");
        if (receiverKey == null) {
            throw new JobExecutionException(QuartzMessages.receiverNotInJobDataMap().getMessage());
        }
        String connectorName = (String)map.get((Object)"mule.quartz.connector");
        if (connectorName == null) {
            throw new JobExecutionException(QuartzMessages.connectorNotInJobDataMap().getMessage());
        }
        AbstractConnector connector = (AbstractConnector)this.muleContext.getRegistry().lookupConnector(connectorName);
        if (connector == null) {
            throw new JobExecutionException(QuartzMessages.noConnectorFound(connectorName).getMessage());
        }
        AbstractMessageReceiver receiver = (AbstractMessageReceiver)connector.lookupReceiver(receiverKey);
        if (receiver == null) {
            throw new JobExecutionException(QuartzMessages.noReceiverInConnector(receiverKey, connectorName).getMessage());
        }
        Object payload = jobExecutionContext.getJobDetail().getJobDataMap().get((Object)"payload");
        try {
            String ref;
            if (payload == null && (payload = (ref = jobExecutionContext.getJobDetail().getJobDataMap().getString("payload")) == null ? NullPayload.getInstance() : this.muleContext.getRegistry().lookupObject(ref)) == null) {
                this.logger.warn((Object)"There is no payload attached to this quartz job. Sending Null payload");
                payload = NullPayload.getInstance();
            }
            MuleMessage msg = receiver.createMuleMessage(payload, receiver.getEndpoint().getEncoding());
            msg.setInvocationProperty("jobData", (Object)jobExecutionContext.getJobDetail().getJobDataMap());
            receiver.routeMessage(msg);
        }
        catch (Exception e) {
            this.muleContext.getExceptionListener().handleException(e);
        }
    }
}

