/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.email;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeUtility;
import org.mule.config.i18n.CoreMessages;
import org.mule.util.StringUtils;

public class MailUtils {
    public static String internetAddressesToString(InternetAddress[] addresses) {
        if (addresses == null || addresses.length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer(80);
        for (int i = 0; i < addresses.length; ++i) {
            InternetAddress address = addresses[i];
            buf.append(address.getAddress());
            if (i >= addresses.length - 1) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    public static String internetAddressesToString(InternetAddress address) {
        return MailUtils.internetAddressesToString(new InternetAddress[]{address});
    }

    public static String mailAddressesToString(Address[] addresses) {
        if (addresses == null || addresses.length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer(80);
        for (int i = 0; i < addresses.length; ++i) {
            Address address = addresses[i];
            buf.append(address.toString());
            if (i >= addresses.length - 1) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    public static String mailAddressesToString(Address address) {
        return MailUtils.mailAddressesToString(new Address[]{address});
    }

    public static InternetAddress[] stringToInternetAddresses(String address) throws AddressException {
        if (StringUtils.isNotBlank((String)address)) {
            return InternetAddress.parse((String)address, (boolean)false);
        }
        throw new IllegalArgumentException(CoreMessages.objectIsNull((String)"Email address").toString());
    }

    public static void getAttachments(Multipart content, Map<String, Part> attachments) throws MessagingException, IOException {
        int x = 0;
        for (int i = 0; i < content.getCount(); ++i) {
            String key;
            BodyPart part = content.getBodyPart(i);
            if (part.getContentType().indexOf("multipart/mixed") > -1) {
                Multipart m = (Multipart)part.getContent();
                MailUtils.getAttachments(m, attachments);
                continue;
            }
            if (StringUtils.isNotEmpty((String)part.getDescription())) {
                key = part.getDescription();
            } else if (StringUtils.isNotEmpty((String)part.getFileName())) {
                try {
                    key = MimeUtility.decodeText((String)part.getFileName());
                }
                catch (UnsupportedEncodingException e) {
                    key = part.getFileName();
                }
            } else {
                key = StringUtils.isNotEmpty((String)part.getDisposition()) ? part.getDisposition() : String.valueOf(x++);
            }
            key = MailUtils.getAttachmentName(key, attachments);
            attachments.put(key, (Part)part);
        }
    }

    public static String getAttachmentName(String key, Map<String, Part> attachments) {
        if (attachments.containsKey(key)) {
            int x = 0;
            while (attachments.containsKey(x + "_" + key)) {
                ++x;
            }
            return x + "_" + key;
        }
        return key;
    }

    public static boolean isListHeader(String name) {
        return null != name && name.startsWith("List:");
    }

    public static String toListHeader(String header) {
        if (MailUtils.isListHeader(header)) {
            return header;
        }
        return "List:" + header;
    }
}

