/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.cdr;

import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.milyn.cdr.SmooksResourceConfiguration;

public class ConfigSearch {
    private String configNS;
    private String selector;
    private String selectorNS;
    private String resource;
    private Properties params = new Properties();

    public String getConfigNS() {
        return this.configNS;
    }

    public ConfigSearch configNS(String configNS) {
        this.configNS = configNS;
        return this;
    }

    public String getSelector() {
        return this.selector;
    }

    public ConfigSearch selector(String selector) {
        this.selector = selector;
        return this;
    }

    public String getSelectorNS() {
        return this.selectorNS;
    }

    public ConfigSearch selectorNS(String selectorNS) {
        this.selectorNS = selectorNS;
        return this;
    }

    public String getResource() {
        return this.resource;
    }

    public ConfigSearch resource(String resource) {
        this.resource = resource;
        return this;
    }

    public ConfigSearch param(String name, String value) {
        this.params.setProperty(name, value);
        return this;
    }

    public boolean matches(SmooksResourceConfiguration config) {
        if (!(this.configNS == null || config.getExtendedConfigNS() != null && config.getExtendedConfigNS().startsWith(this.configNS))) {
            return false;
        }
        if (!(this.selector == null || config.getSelector() != null && config.getSelector().equalsIgnoreCase(this.selector))) {
            return false;
        }
        if (!(this.selectorNS == null || config.getSelectorNamespaceURI() != null && config.getSelectorNamespaceURI().equals(this.selectorNS))) {
            return false;
        }
        if (!(this.resource == null || config.getResource() != null && config.getResource().equals(this.resource))) {
            return false;
        }
        if (!this.params.isEmpty()) {
            Set<Map.Entry<Object, Object>> entries = this.params.entrySet();
            for (Map.Entry<Object, Object> entry : entries) {
                String actualValue;
                String expectedValue = (String)entry.getValue();
                if (expectedValue.equals(actualValue = config.getStringParameter((String)entry.getKey()))) continue;
                return false;
            }
        }
        return true;
    }
}

