/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * Copyright 2015-2022 Andres Almiray
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kordamp.ikonli.remixicon;

import org.kordamp.ikonli.Ikon;

/**
 * @author Andres Almiray
 */
public enum RemixiconMZ implements Ikon {
    MACBOOK_FILL("remixmz-macbook-fill", '\ueee7'),
    MACBOOK_LINE("remixmz-macbook-line", '\ueee8'),
    MAC_FILL("remixmz-mac-fill", '\ueee5'),
    MAC_LINE("remixmz-mac-line", '\ueee6'),
    MAGIC_FILL("remixmz-magic-fill", '\ueee9'),
    MAGIC_LINE("remixmz-magic-line", '\ueeea'),
    MAIL_ADD_FILL("remixmz-mail-add-fill", '\ueeeb'),
    MAIL_ADD_LINE("remixmz-mail-add-line", '\ueeec'),
    MAIL_CHECK_FILL("remixmz-mail-check-fill", '\ueeed'),
    MAIL_CHECK_LINE("remixmz-mail-check-line", '\ueeee'),
    MAIL_CLOSE_FILL("remixmz-mail-close-fill", '\ueeef'),
    MAIL_CLOSE_LINE("remixmz-mail-close-line", '\ueef0'),
    MAIL_DOWNLOAD_FILL("remixmz-mail-download-fill", '\ueef1'),
    MAIL_DOWNLOAD_LINE("remixmz-mail-download-line", '\ueef2'),
    MAIL_FILL("remixmz-mail-fill", '\ueef3'),
    MAIL_FORBID_FILL("remixmz-mail-forbid-fill", '\ueef4'),
    MAIL_FORBID_LINE("remixmz-mail-forbid-line", '\ueef5'),
    MAIL_LINE("remixmz-mail-line", '\ueef6'),
    MAIL_LOCK_FILL("remixmz-mail-lock-fill", '\ueef7'),
    MAIL_LOCK_LINE("remixmz-mail-lock-line", '\ueef8'),
    MAIL_OPEN_FILL("remixmz-mail-open-fill", '\ueef9'),
    MAIL_OPEN_LINE("remixmz-mail-open-line", '\ueefa'),
    MAIL_SEND_FILL("remixmz-mail-send-fill", '\ueefb'),
    MAIL_SEND_LINE("remixmz-mail-send-line", '\ueefc'),
    MAIL_SETTINGS_FILL("remixmz-mail-settings-fill", '\ueefd'),
    MAIL_SETTINGS_LINE("remixmz-mail-settings-line", '\ueefe'),
    MAIL_STAR_FILL("remixmz-mail-star-fill", '\ueeff'),
    MAIL_STAR_LINE("remixmz-mail-star-line", '\uef00'),
    MAIL_UNREAD_FILL("remixmz-mail-unread-fill", '\uef01'),
    MAIL_UNREAD_LINE("remixmz-mail-unread-line", '\uef02'),
    MAIL_VOLUME_FILL("remixmz-mail-volume-fill", '\uef03'),
    MAIL_VOLUME_LINE("remixmz-mail-volume-line", '\uef04'),
    MAP_2_FILL("remixmz-map-2-fill", '\uef05'),
    MAP_2_LINE("remixmz-map-2-line", '\uef06'),
    MAP_FILL("remixmz-map-fill", '\uef07'),
    MAP_LINE("remixmz-map-line", '\uef08'),
    MAP_PIN_2_FILL("remixmz-map-pin-2-fill", '\uef09'),
    MAP_PIN_2_LINE("remixmz-map-pin-2-line", '\uef0a'),
    MAP_PIN_3_FILL("remixmz-map-pin-3-fill", '\uef0b'),
    MAP_PIN_3_LINE("remixmz-map-pin-3-line", '\uef0c'),
    MAP_PIN_4_FILL("remixmz-map-pin-4-fill", '\uef0d'),
    MAP_PIN_4_LINE("remixmz-map-pin-4-line", '\uef0e'),
    MAP_PIN_5_FILL("remixmz-map-pin-5-fill", '\uef0f'),
    MAP_PIN_5_LINE("remixmz-map-pin-5-line", '\uef10'),
    MAP_PIN_ADD_FILL("remixmz-map-pin-add-fill", '\uef11'),
    MAP_PIN_ADD_LINE("remixmz-map-pin-add-line", '\uef12'),
    MAP_PIN_FILL("remixmz-map-pin-fill", '\uef13'),
    MAP_PIN_LINE("remixmz-map-pin-line", '\uef14'),
    MAP_PIN_RANGE_FILL("remixmz-map-pin-range-fill", '\uef15'),
    MAP_PIN_RANGE_LINE("remixmz-map-pin-range-line", '\uef16'),
    MAP_PIN_TIME_FILL("remixmz-map-pin-time-fill", '\uef17'),
    MAP_PIN_TIME_LINE("remixmz-map-pin-time-line", '\uef18'),
    MAP_PIN_USER_FILL("remixmz-map-pin-user-fill", '\uef19'),
    MAP_PIN_USER_LINE("remixmz-map-pin-user-line", '\uef1a'),
    MARKDOWN_FILL("remixmz-markdown-fill", '\uef1d'),
    MARKDOWN_LINE("remixmz-markdown-line", '\uef1e'),
    MARKUP_FILL("remixmz-markup-fill", '\uef1f'),
    MARKUP_LINE("remixmz-markup-line", '\uef20'),
    MARK_PEN_FILL("remixmz-mark-pen-fill", '\uef1b'),
    MARK_PEN_LINE("remixmz-mark-pen-line", '\uef1c'),
    MASTERCARD_FILL("remixmz-mastercard-fill", '\uef21'),
    MASTERCARD_LINE("remixmz-mastercard-line", '\uef22'),
    MASTODON_FILL("remixmz-mastodon-fill", '\uef23'),
    MASTODON_LINE("remixmz-mastodon-line", '\uef24'),
    MEDAL_2_FILL("remixmz-medal-2-fill", '\uef25'),
    MEDAL_2_LINE("remixmz-medal-2-line", '\uef26'),
    MEDAL_FILL("remixmz-medal-fill", '\uef27'),
    MEDAL_LINE("remixmz-medal-line", '\uef28'),
    MEDICINE_BOTTLE_FILL("remixmz-medicine-bottle-fill", '\uef29'),
    MEDICINE_BOTTLE_LINE("remixmz-medicine-bottle-line", '\uef2a'),
    MEDIUM_FILL("remixmz-medium-fill", '\uef2b'),
    MEDIUM_LINE("remixmz-medium-line", '\uef2c'),
    MENTAL_HEALTH_FILL("remixmz-mental-health-fill", '\uef2f'),
    MENTAL_HEALTH_LINE("remixmz-mental-health-line", '\uef30'),
    MENU_2_FILL("remixmz-menu-2-fill", '\uef31'),
    MENU_2_LINE("remixmz-menu-2-line", '\uef32'),
    MENU_3_FILL("remixmz-menu-3-fill", '\uef33'),
    MENU_3_LINE("remixmz-menu-3-line", '\uef34'),
    MENU_4_FILL("remixmz-menu-4-fill", '\uef35'),
    MENU_4_LINE("remixmz-menu-4-line", '\uef36'),
    MENU_5_FILL("remixmz-menu-5-fill", '\uef37'),
    MENU_5_LINE("remixmz-menu-5-line", '\uef38'),
    MENU_ADD_FILL("remixmz-menu-add-fill", '\uef39'),
    MENU_ADD_LINE("remixmz-menu-add-line", '\uef3a'),
    MENU_FILL("remixmz-menu-fill", '\uef3b'),
    MENU_FOLD_FILL("remixmz-menu-fold-fill", '\uef3c'),
    MENU_FOLD_LINE("remixmz-menu-fold-line", '\uef3d'),
    MENU_LINE("remixmz-menu-line", '\uef3e'),
    MENU_UNFOLD_FILL("remixmz-menu-unfold-fill", '\uef3f'),
    MENU_UNFOLD_LINE("remixmz-menu-unfold-line", '\uef40'),
    MEN_FILL("remixmz-men-fill", '\uef2d'),
    MEN_LINE("remixmz-men-line", '\uef2e'),
    MERGE_CELLS_HORIZONTAL("remixmz-merge-cells-horizontal", '\uef41'),
    MERGE_CELLS_VERTICAL("remixmz-merge-cells-vertical", '\uef42'),
    MESSAGE_2_FILL("remixmz-message-2-fill", '\uef43'),
    MESSAGE_2_LINE("remixmz-message-2-line", '\uef44'),
    MESSAGE_3_FILL("remixmz-message-3-fill", '\uef45'),
    MESSAGE_3_LINE("remixmz-message-3-line", '\uef46'),
    MESSAGE_FILL("remixmz-message-fill", '\uef47'),
    MESSAGE_LINE("remixmz-message-line", '\uef48'),
    MESSENGER_FILL("remixmz-messenger-fill", '\uef49'),
    MESSENGER_LINE("remixmz-messenger-line", '\uef4a'),
    METEOR_FILL("remixmz-meteor-fill", '\uef4b'),
    METEOR_LINE("remixmz-meteor-line", '\uef4c'),
    MICKEY_FILL("remixmz-mickey-fill", '\uef53'),
    MICKEY_LINE("remixmz-mickey-line", '\uef54'),
    MICROSCOPE_FILL("remixmz-microscope-fill", '\uef55'),
    MICROSCOPE_LINE("remixmz-microscope-line", '\uef56'),
    MICROSOFT_FILL("remixmz-microsoft-fill", '\uef57'),
    MICROSOFT_LINE("remixmz-microsoft-line", '\uef58'),
    MIC_2_FILL("remixmz-mic-2-fill", '\uef4d'),
    MIC_2_LINE("remixmz-mic-2-line", '\uef4e'),
    MIC_FILL("remixmz-mic-fill", '\uef4f'),
    MIC_LINE("remixmz-mic-line", '\uef50'),
    MIC_OFF_FILL("remixmz-mic-off-fill", '\uef51'),
    MIC_OFF_LINE("remixmz-mic-off-line", '\uef52'),
    MIND_MAP("remixmz-mind-map", '\uef59'),
    MINI_PROGRAM_FILL("remixmz-mini-program-fill", '\uef5a'),
    MINI_PROGRAM_LINE("remixmz-mini-program-line", '\uef5b'),
    MIST_FILL("remixmz-mist-fill", '\uef5c'),
    MIST_LINE("remixmz-mist-line", '\uef5d'),
    MONEY_CNY_BOX_FILL("remixmz-money-cny-box-fill", '\uef5e'),
    MONEY_CNY_BOX_LINE("remixmz-money-cny-box-line", '\uef5f'),
    MONEY_CNY_CIRCLE_FILL("remixmz-money-cny-circle-fill", '\uef60'),
    MONEY_CNY_CIRCLE_LINE("remixmz-money-cny-circle-line", '\uef61'),
    MONEY_DOLLAR_BOX_FILL("remixmz-money-dollar-box-fill", '\uef62'),
    MONEY_DOLLAR_BOX_LINE("remixmz-money-dollar-box-line", '\uef63'),
    MONEY_DOLLAR_CIRCLE_FILL("remixmz-money-dollar-circle-fill", '\uef64'),
    MONEY_DOLLAR_CIRCLE_LINE("remixmz-money-dollar-circle-line", '\uef65'),
    MONEY_EURO_BOX_FILL("remixmz-money-euro-box-fill", '\uef66'),
    MONEY_EURO_BOX_LINE("remixmz-money-euro-box-line", '\uef67'),
    MONEY_EURO_CIRCLE_FILL("remixmz-money-euro-circle-fill", '\uef68'),
    MONEY_EURO_CIRCLE_LINE("remixmz-money-euro-circle-line", '\uef69'),
    MONEY_POUND_BOX_FILL("remixmz-money-pound-box-fill", '\uef6a'),
    MONEY_POUND_BOX_LINE("remixmz-money-pound-box-line", '\uef6b'),
    MONEY_POUND_CIRCLE_FILL("remixmz-money-pound-circle-fill", '\uef6c'),
    MONEY_POUND_CIRCLE_LINE("remixmz-money-pound-circle-line", '\uef6d'),
    MOON_CLEAR_FILL("remixmz-moon-clear-fill", '\uef6e'),
    MOON_CLEAR_LINE("remixmz-moon-clear-line", '\uef6f'),
    MOON_CLOUDY_FILL("remixmz-moon-cloudy-fill", '\uef70'),
    MOON_CLOUDY_LINE("remixmz-moon-cloudy-line", '\uef71'),
    MOON_FILL("remixmz-moon-fill", '\uef72'),
    MOON_FOGGY_FILL("remixmz-moon-foggy-fill", '\uef73'),
    MOON_FOGGY_LINE("remixmz-moon-foggy-line", '\uef74'),
    MOON_LINE("remixmz-moon-line", '\uef75'),
    MORE_2_FILL("remixmz-more-2-fill", '\uef76'),
    MORE_2_LINE("remixmz-more-2-line", '\uef77'),
    MORE_FILL("remixmz-more-fill", '\uef78'),
    MORE_LINE("remixmz-more-line", '\uef79'),
    MOTORBIKE_FILL("remixmz-motorbike-fill", '\uef7a'),
    MOTORBIKE_LINE("remixmz-motorbike-line", '\uef7b'),
    MOUSE_FILL("remixmz-mouse-fill", '\uef7c'),
    MOUSE_LINE("remixmz-mouse-line", '\uef7d'),
    MOVIE_2_FILL("remixmz-movie-2-fill", '\uef7e'),
    MOVIE_2_LINE("remixmz-movie-2-line", '\uef7f'),
    MOVIE_FILL("remixmz-movie-fill", '\uef80'),
    MOVIE_LINE("remixmz-movie-line", '\uef81'),
    MUSIC_2_FILL("remixmz-music-2-fill", '\uef82'),
    MUSIC_2_LINE("remixmz-music-2-line", '\uef83'),
    MUSIC_FILL("remixmz-music-fill", '\uef84'),
    MUSIC_LINE("remixmz-music-line", '\uef85'),
    MV_FILL("remixmz-mv-fill", '\uef86'),
    MV_LINE("remixmz-mv-line", '\uef87'),
    NAVIGATION_FILL("remixmz-navigation-fill", '\uef88'),
    NAVIGATION_LINE("remixmz-navigation-line", '\uef89'),
    NETEASE_CLOUD_MUSIC_FILL("remixmz-netease-cloud-music-fill", '\uef8a'),
    NETEASE_CLOUD_MUSIC_LINE("remixmz-netease-cloud-music-line", '\uef8b'),
    NETFLIX_FILL("remixmz-netflix-fill", '\uef8c'),
    NETFLIX_LINE("remixmz-netflix-line", '\uef8d'),
    NEWSPAPER_FILL("remixmz-newspaper-fill", '\uef8e'),
    NEWSPAPER_LINE("remixmz-newspaper-line", '\uef8f'),
    NODE_TREE("remixmz-node-tree", '\uef90'),
    NOTIFICATION_2_FILL("remixmz-notification-2-fill", '\uef91'),
    NOTIFICATION_2_LINE("remixmz-notification-2-line", '\uef92'),
    NOTIFICATION_3_FILL("remixmz-notification-3-fill", '\uef93'),
    NOTIFICATION_3_LINE("remixmz-notification-3-line", '\uef94'),
    NOTIFICATION_4_FILL("remixmz-notification-4-fill", '\uef95'),
    NOTIFICATION_4_LINE("remixmz-notification-4-line", '\uef96'),
    NOTIFICATION_BADGE_FILL("remixmz-notification-badge-fill", '\uef97'),
    NOTIFICATION_BADGE_LINE("remixmz-notification-badge-line", '\uef98'),
    NOTIFICATION_FILL("remixmz-notification-fill", '\uef99'),
    NOTIFICATION_LINE("remixmz-notification-line", '\uef9a'),
    NOTIFICATION_OFF_FILL("remixmz-notification-off-fill", '\uef9b'),
    NOTIFICATION_OFF_LINE("remixmz-notification-off-line", '\uef9c'),
    NPMJS_FILL("remixmz-npmjs-fill", '\uef9d'),
    NPMJS_LINE("remixmz-npmjs-line", '\uef9e'),
    NUMBERS_FILL("remixmz-numbers-fill", '\uefa9'),
    NUMBERS_LINE("remixmz-numbers-line", '\uefaa'),
    NUMBER_0("remixmz-number-0", '\uef9f'),
    NUMBER_1("remixmz-number-1", '\uefa0'),
    NUMBER_2("remixmz-number-2", '\uefa1'),
    NUMBER_3("remixmz-number-3", '\uefa2'),
    NUMBER_4("remixmz-number-4", '\uefa3'),
    NUMBER_5("remixmz-number-5", '\uefa4'),
    NUMBER_6("remixmz-number-6", '\uefa5'),
    NUMBER_7("remixmz-number-7", '\uefa6'),
    NUMBER_8("remixmz-number-8", '\uefa7'),
    NUMBER_9("remixmz-number-9", '\uefa8'),
    NURSE_FILL("remixmz-nurse-fill", '\uefab'),
    NURSE_LINE("remixmz-nurse-line", '\uefac'),
    OIL_FILL("remixmz-oil-fill", '\uefad'),
    OIL_LINE("remixmz-oil-line", '\uefae'),
    OMEGA("remixmz-omega", '\uefaf'),
    OPEN_ARM_FILL("remixmz-open-arm-fill", '\uefb0'),
    OPEN_ARM_LINE("remixmz-open-arm-line", '\uefb1'),
    OPEN_SOURCE_FILL("remixmz-open-source-fill", '\uefb2'),
    OPEN_SOURCE_LINE("remixmz-open-source-line", '\uefb3'),
    OPERA_FILL("remixmz-opera-fill", '\uefb4'),
    OPERA_LINE("remixmz-opera-line", '\uefb5'),
    ORDER_PLAY_FILL("remixmz-order-play-fill", '\uefb6'),
    ORDER_PLAY_LINE("remixmz-order-play-line", '\uefb7'),
    ORGANIZATION_CHART("remixmz-organization-chart", '\uefb8'),
    OUTLET_2_FILL("remixmz-outlet-2-fill", '\uefb9'),
    OUTLET_2_LINE("remixmz-outlet-2-line", '\uefba'),
    OUTLET_FILL("remixmz-outlet-fill", '\uefbb'),
    OUTLET_LINE("remixmz-outlet-line", '\uefbc'),
    PAGES_FILL("remixmz-pages-fill", '\uefbe'),
    PAGES_LINE("remixmz-pages-line", '\uefbf'),
    PAGE_SEPARATOR("remixmz-page-separator", '\uefbd'),
    PAINT_BRUSH_FILL("remixmz-paint-brush-fill", '\uefc0'),
    PAINT_BRUSH_LINE("remixmz-paint-brush-line", '\uefc1'),
    PAINT_FILL("remixmz-paint-fill", '\uefc2'),
    PAINT_LINE("remixmz-paint-line", '\uefc3'),
    PALETTE_FILL("remixmz-palette-fill", '\uefc4'),
    PALETTE_LINE("remixmz-palette-line", '\uefc5'),
    PANTONE_FILL("remixmz-pantone-fill", '\uefc6'),
    PANTONE_LINE("remixmz-pantone-line", '\uefc7'),
    PARAGRAPH("remixmz-paragraph", '\uefc8'),
    PARENTHESES_FILL("remixmz-parentheses-fill", '\uefcb'),
    PARENTHESES_LINE("remixmz-parentheses-line", '\uefcc'),
    PARENT_FILL("remixmz-parent-fill", '\uefc9'),
    PARENT_LINE("remixmz-parent-line", '\uefca'),
    PARKING_BOX_FILL("remixmz-parking-box-fill", '\uefcd'),
    PARKING_BOX_LINE("remixmz-parking-box-line", '\uefce'),
    PARKING_FILL("remixmz-parking-fill", '\uefcf'),
    PARKING_LINE("remixmz-parking-line", '\uefd0'),
    PASSPORT_FILL("remixmz-passport-fill", '\uefd1'),
    PASSPORT_LINE("remixmz-passport-line", '\uefd2'),
    PATREON_FILL("remixmz-patreon-fill", '\uefd3'),
    PATREON_LINE("remixmz-patreon-line", '\uefd4'),
    PAUSE_CIRCLE_FILL("remixmz-pause-circle-fill", '\uefd5'),
    PAUSE_CIRCLE_LINE("remixmz-pause-circle-line", '\uefd6'),
    PAUSE_FILL("remixmz-pause-fill", '\uefd7'),
    PAUSE_LINE("remixmz-pause-line", '\uefd8'),
    PAUSE_MINI_FILL("remixmz-pause-mini-fill", '\uefd9'),
    PAUSE_MINI_LINE("remixmz-pause-mini-line", '\uefda'),
    PAYPAL_FILL("remixmz-paypal-fill", '\uefdb'),
    PAYPAL_LINE("remixmz-paypal-line", '\uefdc'),
    PENCIL_FILL("remixmz-pencil-fill", '\uefdf'),
    PENCIL_LINE("remixmz-pencil-line", '\uefe0'),
    PENCIL_RULER_2_FILL("remixmz-pencil-ruler-2-fill", '\uefe1'),
    PENCIL_RULER_2_LINE("remixmz-pencil-ruler-2-line", '\uefe2'),
    PENCIL_RULER_FILL("remixmz-pencil-ruler-fill", '\uefe3'),
    PENCIL_RULER_LINE("remixmz-pencil-ruler-line", '\uefe4'),
    PEN_NIB_FILL("remixmz-pen-nib-fill", '\uefdd'),
    PEN_NIB_LINE("remixmz-pen-nib-line", '\uefde'),
    PERCENT_FILL("remixmz-percent-fill", '\uefe5'),
    PERCENT_LINE("remixmz-percent-line", '\uefe6'),
    PHONE_CAMERA_FILL("remixmz-phone-camera-fill", '\uefe7'),
    PHONE_CAMERA_LINE("remixmz-phone-camera-line", '\uefe8'),
    PHONE_FILL("remixmz-phone-fill", '\uefe9'),
    PHONE_FIND_FILL("remixmz-phone-find-fill", '\uefea'),
    PHONE_FIND_LINE("remixmz-phone-find-line", '\uefeb'),
    PHONE_LINE("remixmz-phone-line", '\uefec'),
    PHONE_LOCK_FILL("remixmz-phone-lock-fill", '\uefed'),
    PHONE_LOCK_LINE("remixmz-phone-lock-line", '\uefee'),
    PICTURE_IN_PICTURE_2_FILL("remixmz-picture-in-picture-2-fill", '\uefef'),
    PICTURE_IN_PICTURE_2_LINE("remixmz-picture-in-picture-2-line", '\ueff0'),
    PICTURE_IN_PICTURE_EXIT_FILL("remixmz-picture-in-picture-exit-fill", '\ueff1'),
    PICTURE_IN_PICTURE_EXIT_LINE("remixmz-picture-in-picture-exit-line", '\ueff2'),
    PICTURE_IN_PICTURE_FILL("remixmz-picture-in-picture-fill", '\ueff3'),
    PICTURE_IN_PICTURE_LINE("remixmz-picture-in-picture-line", '\ueff4'),
    PIE_CHART_2_FILL("remixmz-pie-chart-2-fill", '\ueff5'),
    PIE_CHART_2_LINE("remixmz-pie-chart-2-line", '\ueff6'),
    PIE_CHART_BOX_FILL("remixmz-pie-chart-box-fill", '\ueff7'),
    PIE_CHART_BOX_LINE("remixmz-pie-chart-box-line", '\ueff8'),
    PIE_CHART_FILL("remixmz-pie-chart-fill", '\ueff9'),
    PIE_CHART_LINE("remixmz-pie-chart-line", '\ueffa'),
    PING_PONG_FILL("remixmz-ping-pong-fill", '\ueffd'),
    PING_PONG_LINE("remixmz-ping-pong-line", '\ueffe'),
    PINTEREST_FILL("remixmz-pinterest-fill", '\uefff'),
    PINTEREST_LINE("remixmz-pinterest-line", '\uf000'),
    PINYIN_INPUT("remixmz-pinyin-input", '\uf001'),
    PIN_DISTANCE_FILL("remixmz-pin-distance-fill", '\ueffb'),
    PIN_DISTANCE_LINE("remixmz-pin-distance-line", '\ueffc'),
    PIXELFED_FILL("remixmz-pixelfed-fill", '\uf002'),
    PIXELFED_LINE("remixmz-pixelfed-line", '\uf003'),
    PLANE_FILL("remixmz-plane-fill", '\uf004'),
    PLANE_LINE("remixmz-plane-line", '\uf005'),
    PLANT_FILL("remixmz-plant-fill", '\uf006'),
    PLANT_LINE("remixmz-plant-line", '\uf007'),
    PLAYSTATION_FILL("remixmz-playstation-fill", '\uf014'),
    PLAYSTATION_LINE("remixmz-playstation-line", '\uf015'),
    PLAY_CIRCLE_FILL("remixmz-play-circle-fill", '\uf008'),
    PLAY_CIRCLE_LINE("remixmz-play-circle-line", '\uf009'),
    PLAY_FILL("remixmz-play-fill", '\uf00a'),
    PLAY_LINE("remixmz-play-line", '\uf00b'),
    PLAY_LIST_2_FILL("remixmz-play-list-2-fill", '\uf00c'),
    PLAY_LIST_2_LINE("remixmz-play-list-2-line", '\uf00d'),
    PLAY_LIST_ADD_FILL("remixmz-play-list-add-fill", '\uf00e'),
    PLAY_LIST_ADD_LINE("remixmz-play-list-add-line", '\uf00f'),
    PLAY_LIST_FILL("remixmz-play-list-fill", '\uf010'),
    PLAY_LIST_LINE("remixmz-play-list-line", '\uf011'),
    PLAY_MINI_FILL("remixmz-play-mini-fill", '\uf012'),
    PLAY_MINI_LINE("remixmz-play-mini-line", '\uf013'),
    PLUG_2_FILL("remixmz-plug-2-fill", '\uf016'),
    PLUG_2_LINE("remixmz-plug-2-line", '\uf017'),
    PLUG_FILL("remixmz-plug-fill", '\uf018'),
    PLUG_LINE("remixmz-plug-line", '\uf019'),
    POLAROID_2_FILL("remixmz-polaroid-2-fill", '\uf01a'),
    POLAROID_2_LINE("remixmz-polaroid-2-line", '\uf01b'),
    POLAROID_FILL("remixmz-polaroid-fill", '\uf01c'),
    POLAROID_LINE("remixmz-polaroid-line", '\uf01d'),
    POLICE_CAR_FILL("remixmz-police-car-fill", '\uf01e'),
    POLICE_CAR_LINE("remixmz-police-car-line", '\uf01f'),
    PRICE_TAG_2_FILL("remixmz-price-tag-2-fill", '\uf020'),
    PRICE_TAG_2_LINE("remixmz-price-tag-2-line", '\uf021'),
    PRICE_TAG_3_FILL("remixmz-price-tag-3-fill", '\uf022'),
    PRICE_TAG_3_LINE("remixmz-price-tag-3-line", '\uf023'),
    PRICE_TAG_FILL("remixmz-price-tag-fill", '\uf024'),
    PRICE_TAG_LINE("remixmz-price-tag-line", '\uf025'),
    PRINTER_CLOUD_FILL("remixmz-printer-cloud-fill", '\uf026'),
    PRINTER_CLOUD_LINE("remixmz-printer-cloud-line", '\uf027'),
    PRINTER_FILL("remixmz-printer-fill", '\uf028'),
    PRINTER_LINE("remixmz-printer-line", '\uf029'),
    PRODUCT_HUNT_FILL("remixmz-product-hunt-fill", '\uf02a'),
    PRODUCT_HUNT_LINE("remixmz-product-hunt-line", '\uf02b'),
    PROFILE_FILL("remixmz-profile-fill", '\uf02c'),
    PROFILE_LINE("remixmz-profile-line", '\uf02d'),
    PROJECTOR_2_FILL("remixmz-projector-2-fill", '\uf02e'),
    PROJECTOR_2_LINE("remixmz-projector-2-line", '\uf02f'),
    PROJECTOR_FILL("remixmz-projector-fill", '\uf030'),
    PROJECTOR_LINE("remixmz-projector-line", '\uf031'),
    PSYCHOTHERAPY_FILL("remixmz-psychotherapy-fill", '\uf032'),
    PSYCHOTHERAPY_LINE("remixmz-psychotherapy-line", '\uf033'),
    PULSE_FILL("remixmz-pulse-fill", '\uf034'),
    PULSE_LINE("remixmz-pulse-line", '\uf035'),
    PUSHPIN_2_FILL("remixmz-pushpin-2-fill", '\uf036'),
    PUSHPIN_2_LINE("remixmz-pushpin-2-line", '\uf037'),
    PUSHPIN_FILL("remixmz-pushpin-fill", '\uf038'),
    PUSHPIN_LINE("remixmz-pushpin-line", '\uf039'),
    QQ_FILL("remixmz-qq-fill", '\uf03a'),
    QQ_LINE("remixmz-qq-line", '\uf03b'),
    QR_CODE_FILL("remixmz-qr-code-fill", '\uf03c'),
    QR_CODE_LINE("remixmz-qr-code-line", '\uf03d'),
    QR_SCAN_2_FILL("remixmz-qr-scan-2-fill", '\uf03e'),
    QR_SCAN_2_LINE("remixmz-qr-scan-2-line", '\uf03f'),
    QR_SCAN_FILL("remixmz-qr-scan-fill", '\uf040'),
    QR_SCAN_LINE("remixmz-qr-scan-line", '\uf041'),
    QUESTIONNAIRE_FILL("remixmz-questionnaire-fill", '\uf047'),
    QUESTIONNAIRE_LINE("remixmz-questionnaire-line", '\uf048'),
    QUESTION_ANSWER_FILL("remixmz-question-answer-fill", '\uf042'),
    QUESTION_ANSWER_LINE("remixmz-question-answer-line", '\uf043'),
    QUESTION_FILL("remixmz-question-fill", '\uf044'),
    QUESTION_LINE("remixmz-question-line", '\uf045'),
    QUESTION_MARK("remixmz-question-mark", '\uf046'),
    QUILL_PEN_FILL("remixmz-quill-pen-fill", '\uf049'),
    QUILL_PEN_LINE("remixmz-quill-pen-line", '\uf04a'),
    RADAR_FILL("remixmz-radar-fill", '\uf04b'),
    RADAR_LINE("remixmz-radar-line", '\uf04c'),
    RADIO_2_FILL("remixmz-radio-2-fill", '\uf04d'),
    RADIO_2_LINE("remixmz-radio-2-line", '\uf04e'),
    RADIO_BUTTON_FILL("remixmz-radio-button-fill", '\uf04f'),
    RADIO_BUTTON_LINE("remixmz-radio-button-line", '\uf050'),
    RADIO_FILL("remixmz-radio-fill", '\uf051'),
    RADIO_LINE("remixmz-radio-line", '\uf052'),
    RAINBOW_FILL("remixmz-rainbow-fill", '\uf053'),
    RAINBOW_LINE("remixmz-rainbow-line", '\uf054'),
    RAINY_FILL("remixmz-rainy-fill", '\uf055'),
    RAINY_LINE("remixmz-rainy-line", '\uf056'),
    REACTJS_FILL("remixmz-reactjs-fill", '\uf057'),
    REACTJS_LINE("remixmz-reactjs-line", '\uf058'),
    RECORD_CIRCLE_FILL("remixmz-record-circle-fill", '\uf059'),
    RECORD_CIRCLE_LINE("remixmz-record-circle-line", '\uf05a'),
    RECORD_MAIL_FILL("remixmz-record-mail-fill", '\uf05b'),
    RECORD_MAIL_LINE("remixmz-record-mail-line", '\uf05c'),
    RECYCLE_FILL("remixmz-recycle-fill", '\uf05d'),
    RECYCLE_LINE("remixmz-recycle-line", '\uf05e'),
    REDDIT_FILL("remixmz-reddit-fill", '\uf061'),
    REDDIT_LINE("remixmz-reddit-line", '\uf062'),
    RED_PACKET_FILL("remixmz-red-packet-fill", '\uf05f'),
    RED_PACKET_LINE("remixmz-red-packet-line", '\uf060'),
    REFRESH_FILL("remixmz-refresh-fill", '\uf063'),
    REFRESH_LINE("remixmz-refresh-line", '\uf064'),
    REFUND_2_FILL("remixmz-refund-2-fill", '\uf065'),
    REFUND_2_LINE("remixmz-refund-2-line", '\uf066'),
    REFUND_FILL("remixmz-refund-fill", '\uf067'),
    REFUND_LINE("remixmz-refund-line", '\uf068'),
    REGISTERED_FILL("remixmz-registered-fill", '\uf069'),
    REGISTERED_LINE("remixmz-registered-line", '\uf06a'),
    REMIX_24_HOURS_FILL("remixmz-24-hours-fill", '\uea01'),
    REMIX_24_HOURS_LINE("remixmz-24-hours-line", '\uea02'),
    REMIX_4K_FILL("remixmz-4k-fill", '\uea03'),
    REMIX_4K_LINE("remixmz-4k-line", '\uea04'),
    REMIXICON_FILL("remixmz-remixicon-fill", '\uf06b'),
    REMIXICON_LINE("remixmz-remixicon-line", '\uf06c'),
    REMOTE_CONTROL_2_FILL("remixmz-remote-control-2-fill", '\uf06d'),
    REMOTE_CONTROL_2_LINE("remixmz-remote-control-2-line", '\uf06e'),
    REMOTE_CONTROL_FILL("remixmz-remote-control-fill", '\uf06f'),
    REMOTE_CONTROL_LINE("remixmz-remote-control-line", '\uf070'),
    REPEAT_2_FILL("remixmz-repeat-2-fill", '\uf071'),
    REPEAT_2_LINE("remixmz-repeat-2-line", '\uf072'),
    REPEAT_FILL("remixmz-repeat-fill", '\uf073'),
    REPEAT_LINE("remixmz-repeat-line", '\uf074'),
    REPEAT_ONE_FILL("remixmz-repeat-one-fill", '\uf075'),
    REPEAT_ONE_LINE("remixmz-repeat-one-line", '\uf076'),
    REPLY_ALL_FILL("remixmz-reply-all-fill", '\uf077'),
    REPLY_ALL_LINE("remixmz-reply-all-line", '\uf078'),
    REPLY_FILL("remixmz-reply-fill", '\uf079'),
    REPLY_LINE("remixmz-reply-line", '\uf07a'),
    RESERVED_FILL("remixmz-reserved-fill", '\uf07b'),
    RESERVED_LINE("remixmz-reserved-line", '\uf07c'),
    RESTART_FILL("remixmz-restart-fill", '\uf07f'),
    RESTART_LINE("remixmz-restart-line", '\uf080'),
    RESTAURANT_2_FILL("remixmz-restaurant-2-fill", '\uf081'),
    RESTAURANT_2_LINE("remixmz-restaurant-2-line", '\uf082'),
    RESTAURANT_FILL("remixmz-restaurant-fill", '\uf083'),
    RESTAURANT_LINE("remixmz-restaurant-line", '\uf084'),
    REST_TIME_FILL("remixmz-rest-time-fill", '\uf07d'),
    REST_TIME_LINE("remixmz-rest-time-line", '\uf07e'),
    REWIND_FILL("remixmz-rewind-fill", '\uf085'),
    REWIND_LINE("remixmz-rewind-line", '\uf086'),
    REWIND_MINI_FILL("remixmz-rewind-mini-fill", '\uf087'),
    REWIND_MINI_LINE("remixmz-rewind-mini-line", '\uf088'),
    RHYTHM_FILL("remixmz-rhythm-fill", '\uf089'),
    RHYTHM_LINE("remixmz-rhythm-line", '\uf08a'),
    RIDING_FILL("remixmz-riding-fill", '\uf08b'),
    RIDING_LINE("remixmz-riding-line", '\uf08c'),
    ROADSTER_FILL("remixmz-roadster-fill", '\uf08f'),
    ROADSTER_LINE("remixmz-roadster-line", '\uf090'),
    ROAD_MAP_FILL("remixmz-road-map-fill", '\uf08d'),
    ROAD_MAP_LINE("remixmz-road-map-line", '\uf08e'),
    ROBOT_FILL("remixmz-robot-fill", '\uf091'),
    ROBOT_LINE("remixmz-robot-line", '\uf092'),
    ROCKET_2_FILL("remixmz-rocket-2-fill", '\uf093'),
    ROCKET_2_LINE("remixmz-rocket-2-line", '\uf094'),
    ROCKET_FILL("remixmz-rocket-fill", '\uf095'),
    ROCKET_LINE("remixmz-rocket-line", '\uf096'),
    ROTATE_LOCK_FILL("remixmz-rotate-lock-fill", '\uf097'),
    ROTATE_LOCK_LINE("remixmz-rotate-lock-line", '\uf098'),
    ROUNDED_CORNER("remixmz-rounded-corner", '\uf099'),
    ROUTER_FILL("remixmz-router-fill", '\uf09c'),
    ROUTER_LINE("remixmz-router-line", '\uf09d'),
    ROUTE_FILL("remixmz-route-fill", '\uf09a'),
    ROUTE_LINE("remixmz-route-line", '\uf09b'),
    RSS_FILL("remixmz-rss-fill", '\uf09e'),
    RSS_LINE("remixmz-rss-line", '\uf09f'),
    RULER_2_FILL("remixmz-ruler-2-fill", '\uf0a0'),
    RULER_2_LINE("remixmz-ruler-2-line", '\uf0a1'),
    RULER_FILL("remixmz-ruler-fill", '\uf0a2'),
    RULER_LINE("remixmz-ruler-line", '\uf0a3'),
    RUN_FILL("remixmz-run-fill", '\uf0a4'),
    RUN_LINE("remixmz-run-line", '\uf0a5'),
    SAFARI_FILL("remixmz-safari-fill", '\uf0a6'),
    SAFARI_LINE("remixmz-safari-line", '\uf0a7'),
    SAFE_2_FILL("remixmz-safe-2-fill", '\uf0a8'),
    SAFE_2_LINE("remixmz-safe-2-line", '\uf0a9'),
    SAFE_FILL("remixmz-safe-fill", '\uf0aa'),
    SAFE_LINE("remixmz-safe-line", '\uf0ab'),
    SAILBOAT_FILL("remixmz-sailboat-fill", '\uf0ac'),
    SAILBOAT_LINE("remixmz-sailboat-line", '\uf0ad'),
    SAVE_2_FILL("remixmz-save-2-fill", '\uf0ae'),
    SAVE_2_LINE("remixmz-save-2-line", '\uf0af'),
    SAVE_3_FILL("remixmz-save-3-fill", '\uf0b0'),
    SAVE_3_LINE("remixmz-save-3-line", '\uf0b1'),
    SAVE_FILL("remixmz-save-fill", '\uf0b2'),
    SAVE_LINE("remixmz-save-line", '\uf0b3'),
    SCALES_2_FILL("remixmz-scales-2-fill", '\uf0b4'),
    SCALES_2_LINE("remixmz-scales-2-line", '\uf0b5'),
    SCALES_3_FILL("remixmz-scales-3-fill", '\uf0b6'),
    SCALES_3_LINE("remixmz-scales-3-line", '\uf0b7'),
    SCALES_FILL("remixmz-scales-fill", '\uf0b8'),
    SCALES_LINE("remixmz-scales-line", '\uf0b9'),
    SCAN_2_FILL("remixmz-scan-2-fill", '\uf0ba'),
    SCAN_2_LINE("remixmz-scan-2-line", '\uf0bb'),
    SCAN_FILL("remixmz-scan-fill", '\uf0bc'),
    SCAN_LINE("remixmz-scan-line", '\uf0bd'),
    SCISSORS_2_FILL("remixmz-scissors-2-fill", '\uf0be'),
    SCISSORS_2_LINE("remixmz-scissors-2-line", '\uf0bf'),
    SCISSORS_CUT_FILL("remixmz-scissors-cut-fill", '\uf0c0'),
    SCISSORS_CUT_LINE("remixmz-scissors-cut-line", '\uf0c1'),
    SCISSORS_FILL("remixmz-scissors-fill", '\uf0c2'),
    SCISSORS_LINE("remixmz-scissors-line", '\uf0c3'),
    SCREENSHOT_2_FILL("remixmz-screenshot-2-fill", '\uf0c4'),
    SCREENSHOT_2_LINE("remixmz-screenshot-2-line", '\uf0c5'),
    SCREENSHOT_FILL("remixmz-screenshot-fill", '\uf0c6'),
    SCREENSHOT_LINE("remixmz-screenshot-line", '\uf0c7'),
    SD_CARD_FILL("remixmz-sd-card-fill", '\uf0c8'),
    SD_CARD_LINE("remixmz-sd-card-line", '\uf0c9'),
    SD_CARD_MINI_FILL("remixmz-sd-card-mini-fill", '\uf0ca'),
    SD_CARD_MINI_LINE("remixmz-sd-card-mini-line", '\uf0cb'),
    SEARCH_2_FILL("remixmz-search-2-fill", '\uf0cc'),
    SEARCH_2_LINE("remixmz-search-2-line", '\uf0cd'),
    SEARCH_EYE_FILL("remixmz-search-eye-fill", '\uf0ce'),
    SEARCH_EYE_LINE("remixmz-search-eye-line", '\uf0cf'),
    SEARCH_FILL("remixmz-search-fill", '\uf0d0'),
    SEARCH_LINE("remixmz-search-line", '\uf0d1'),
    SECURE_PAYMENT_FILL("remixmz-secure-payment-fill", '\uf0d2'),
    SECURE_PAYMENT_LINE("remixmz-secure-payment-line", '\uf0d3'),
    SEEDLING_FILL("remixmz-seedling-fill", '\uf0d4'),
    SEEDLING_LINE("remixmz-seedling-line", '\uf0d5'),
    SEND_BACKWARD("remixmz-send-backward", '\uf0d6'),
    SEND_PLANE_2_FILL("remixmz-send-plane-2-fill", '\uf0d7'),
    SEND_PLANE_2_LINE("remixmz-send-plane-2-line", '\uf0d8'),
    SEND_PLANE_FILL("remixmz-send-plane-fill", '\uf0d9'),
    SEND_PLANE_LINE("remixmz-send-plane-line", '\uf0da'),
    SEND_TO_BACK("remixmz-send-to-back", '\uf0db'),
    SENSOR_FILL("remixmz-sensor-fill", '\uf0dc'),
    SENSOR_LINE("remixmz-sensor-line", '\uf0dd'),
    SEPARATOR("remixmz-separator", '\uf0de'),
    SERVER_FILL("remixmz-server-fill", '\uf0df'),
    SERVER_LINE("remixmz-server-line", '\uf0e0'),
    SERVICE_FILL("remixmz-service-fill", '\uf0e1'),
    SERVICE_LINE("remixmz-service-line", '\uf0e2'),
    SETTINGS_2_FILL("remixmz-settings-2-fill", '\uf0e3'),
    SETTINGS_2_LINE("remixmz-settings-2-line", '\uf0e4'),
    SETTINGS_3_FILL("remixmz-settings-3-fill", '\uf0e5'),
    SETTINGS_3_LINE("remixmz-settings-3-line", '\uf0e6'),
    SETTINGS_4_FILL("remixmz-settings-4-fill", '\uf0e7'),
    SETTINGS_4_LINE("remixmz-settings-4-line", '\uf0e8'),
    SETTINGS_5_FILL("remixmz-settings-5-fill", '\uf0e9'),
    SETTINGS_5_LINE("remixmz-settings-5-line", '\uf0ea'),
    SETTINGS_6_FILL("remixmz-settings-6-fill", '\uf0eb'),
    SETTINGS_6_LINE("remixmz-settings-6-line", '\uf0ec'),
    SETTINGS_FILL("remixmz-settings-fill", '\uf0ed'),
    SETTINGS_LINE("remixmz-settings-line", '\uf0ee'),
    SHAPE_2_FILL("remixmz-shape-2-fill", '\uf0ef'),
    SHAPE_2_LINE("remixmz-shape-2-line", '\uf0f0'),
    SHAPE_FILL("remixmz-shape-fill", '\uf0f1'),
    SHAPE_LINE("remixmz-shape-line", '\uf0f2'),
    SHARE_BOX_FILL("remixmz-share-box-fill", '\uf0f3'),
    SHARE_BOX_LINE("remixmz-share-box-line", '\uf0f4'),
    SHARE_CIRCLE_FILL("remixmz-share-circle-fill", '\uf0f5'),
    SHARE_CIRCLE_LINE("remixmz-share-circle-line", '\uf0f6'),
    SHARE_FILL("remixmz-share-fill", '\uf0f7'),
    SHARE_FORWARD_2_FILL("remixmz-share-forward-2-fill", '\uf0f8'),
    SHARE_FORWARD_2_LINE("remixmz-share-forward-2-line", '\uf0f9'),
    SHARE_FORWARD_BOX_FILL("remixmz-share-forward-box-fill", '\uf0fa'),
    SHARE_FORWARD_BOX_LINE("remixmz-share-forward-box-line", '\uf0fb'),
    SHARE_FORWARD_FILL("remixmz-share-forward-fill", '\uf0fc'),
    SHARE_FORWARD_LINE("remixmz-share-forward-line", '\uf0fd'),
    SHARE_LINE("remixmz-share-line", '\uf0fe'),
    SHIELD_CHECK_FILL("remixmz-shield-check-fill", '\uf0ff'),
    SHIELD_CHECK_LINE("remixmz-shield-check-line", '\uf100'),
    SHIELD_CROSS_FILL("remixmz-shield-cross-fill", '\uf101'),
    SHIELD_CROSS_LINE("remixmz-shield-cross-line", '\uf102'),
    SHIELD_FILL("remixmz-shield-fill", '\uf103'),
    SHIELD_FLASH_FILL("remixmz-shield-flash-fill", '\uf104'),
    SHIELD_FLASH_LINE("remixmz-shield-flash-line", '\uf105'),
    SHIELD_KEYHOLE_FILL("remixmz-shield-keyhole-fill", '\uf106'),
    SHIELD_KEYHOLE_LINE("remixmz-shield-keyhole-line", '\uf107'),
    SHIELD_LINE("remixmz-shield-line", '\uf108'),
    SHIELD_STAR_FILL("remixmz-shield-star-fill", '\uf109'),
    SHIELD_STAR_LINE("remixmz-shield-star-line", '\uf10a'),
    SHIELD_USER_FILL("remixmz-shield-user-fill", '\uf10b'),
    SHIELD_USER_LINE("remixmz-shield-user-line", '\uf10c'),
    SHIP_2_FILL("remixmz-ship-2-fill", '\uf10d'),
    SHIP_2_LINE("remixmz-ship-2-line", '\uf10e'),
    SHIP_FILL("remixmz-ship-fill", '\uf10f'),
    SHIP_LINE("remixmz-ship-line", '\uf110'),
    SHIRT_FILL("remixmz-shirt-fill", '\uf111'),
    SHIRT_LINE("remixmz-shirt-line", '\uf112'),
    SHOPPING_BAG_2_FILL("remixmz-shopping-bag-2-fill", '\uf113'),
    SHOPPING_BAG_2_LINE("remixmz-shopping-bag-2-line", '\uf114'),
    SHOPPING_BAG_3_FILL("remixmz-shopping-bag-3-fill", '\uf115'),
    SHOPPING_BAG_3_LINE("remixmz-shopping-bag-3-line", '\uf116'),
    SHOPPING_BAG_FILL("remixmz-shopping-bag-fill", '\uf117'),
    SHOPPING_BAG_LINE("remixmz-shopping-bag-line", '\uf118'),
    SHOPPING_BASKET_2_FILL("remixmz-shopping-basket-2-fill", '\uf119'),
    SHOPPING_BASKET_2_LINE("remixmz-shopping-basket-2-line", '\uf11a'),
    SHOPPING_BASKET_FILL("remixmz-shopping-basket-fill", '\uf11b'),
    SHOPPING_BASKET_LINE("remixmz-shopping-basket-line", '\uf11c'),
    SHOPPING_CART_2_FILL("remixmz-shopping-cart-2-fill", '\uf11d'),
    SHOPPING_CART_2_LINE("remixmz-shopping-cart-2-line", '\uf11e'),
    SHOPPING_CART_FILL("remixmz-shopping-cart-fill", '\uf11f'),
    SHOPPING_CART_LINE("remixmz-shopping-cart-line", '\uf120'),
    SHOWERS_FILL("remixmz-showers-fill", '\uf121'),
    SHOWERS_LINE("remixmz-showers-line", '\uf122'),
    SHUFFLE_FILL("remixmz-shuffle-fill", '\uf123'),
    SHUFFLE_LINE("remixmz-shuffle-line", '\uf124'),
    SHUT_DOWN_FILL("remixmz-shut-down-fill", '\uf125'),
    SHUT_DOWN_LINE("remixmz-shut-down-line", '\uf126'),
    SIDE_BAR_FILL("remixmz-side-bar-fill", '\uf127'),
    SIDE_BAR_LINE("remixmz-side-bar-line", '\uf128'),
    SIGNAL_TOWER_FILL("remixmz-signal-tower-fill", '\uf129'),
    SIGNAL_TOWER_LINE("remixmz-signal-tower-line", '\uf12a'),
    SIGNAL_WIFI_1_FILL("remixmz-signal-wifi-1-fill", '\uf12b'),
    SIGNAL_WIFI_1_LINE("remixmz-signal-wifi-1-line", '\uf12c'),
    SIGNAL_WIFI_2_FILL("remixmz-signal-wifi-2-fill", '\uf12d'),
    SIGNAL_WIFI_2_LINE("remixmz-signal-wifi-2-line", '\uf12e'),
    SIGNAL_WIFI_3_FILL("remixmz-signal-wifi-3-fill", '\uf12f'),
    SIGNAL_WIFI_3_LINE("remixmz-signal-wifi-3-line", '\uf130'),
    SIGNAL_WIFI_ERROR_FILL("remixmz-signal-wifi-error-fill", '\uf131'),
    SIGNAL_WIFI_ERROR_LINE("remixmz-signal-wifi-error-line", '\uf132'),
    SIGNAL_WIFI_FILL("remixmz-signal-wifi-fill", '\uf133'),
    SIGNAL_WIFI_LINE("remixmz-signal-wifi-line", '\uf134'),
    SIGNAL_WIFI_OFF_FILL("remixmz-signal-wifi-off-fill", '\uf135'),
    SIGNAL_WIFI_OFF_LINE("remixmz-signal-wifi-off-line", '\uf136'),
    SIM_CARD_2_FILL("remixmz-sim-card-2-fill", '\uf137'),
    SIM_CARD_2_LINE("remixmz-sim-card-2-line", '\uf138'),
    SIM_CARD_FILL("remixmz-sim-card-fill", '\uf139'),
    SIM_CARD_LINE("remixmz-sim-card-line", '\uf13a'),
    SINGLE_QUOTES_L("remixmz-single-quotes-l", '\uf13b'),
    SINGLE_QUOTES_R("remixmz-single-quotes-r", '\uf13c'),
    SIP_FILL("remixmz-sip-fill", '\uf13d'),
    SIP_LINE("remixmz-sip-line", '\uf13e'),
    SKIP_BACK_FILL("remixmz-skip-back-fill", '\uf13f'),
    SKIP_BACK_LINE("remixmz-skip-back-line", '\uf140'),
    SKIP_BACK_MINI_FILL("remixmz-skip-back-mini-fill", '\uf141'),
    SKIP_BACK_MINI_LINE("remixmz-skip-back-mini-line", '\uf142'),
    SKIP_FORWARD_FILL("remixmz-skip-forward-fill", '\uf143'),
    SKIP_FORWARD_LINE("remixmz-skip-forward-line", '\uf144'),
    SKIP_FORWARD_MINI_FILL("remixmz-skip-forward-mini-fill", '\uf145'),
    SKIP_FORWARD_MINI_LINE("remixmz-skip-forward-mini-line", '\uf146'),
    SKULL_2_FILL("remixmz-skull-2-fill", '\uf147'),
    SKULL_2_LINE("remixmz-skull-2-line", '\uf148'),
    SKULL_FILL("remixmz-skull-fill", '\uf149'),
    SKULL_LINE("remixmz-skull-line", '\uf14a'),
    SKYPE_FILL("remixmz-skype-fill", '\uf14b'),
    SKYPE_LINE("remixmz-skype-line", '\uf14c'),
    SLACK_FILL("remixmz-slack-fill", '\uf14d'),
    SLACK_LINE("remixmz-slack-line", '\uf14e'),
    SLICE_FILL("remixmz-slice-fill", '\uf14f'),
    SLICE_LINE("remixmz-slice-line", '\uf150'),
    SLIDESHOW_2_FILL("remixmz-slideshow-2-fill", '\uf151'),
    SLIDESHOW_2_LINE("remixmz-slideshow-2-line", '\uf152'),
    SLIDESHOW_3_FILL("remixmz-slideshow-3-fill", '\uf153'),
    SLIDESHOW_3_LINE("remixmz-slideshow-3-line", '\uf154'),
    SLIDESHOW_4_FILL("remixmz-slideshow-4-fill", '\uf155'),
    SLIDESHOW_4_LINE("remixmz-slideshow-4-line", '\uf156'),
    SLIDESHOW_FILL("remixmz-slideshow-fill", '\uf157'),
    SLIDESHOW_LINE("remixmz-slideshow-line", '\uf158'),
    SMARTPHONE_FILL("remixmz-smartphone-fill", '\uf159'),
    SMARTPHONE_LINE("remixmz-smartphone-line", '\uf15a'),
    SNAPCHAT_FILL("remixmz-snapchat-fill", '\uf15b'),
    SNAPCHAT_LINE("remixmz-snapchat-line", '\uf15c'),
    SNOWY_FILL("remixmz-snowy-fill", '\uf15d'),
    SNOWY_LINE("remixmz-snowy-line", '\uf15e'),
    SORT_ASC("remixmz-sort-asc", '\uf15f'),
    SORT_DESC("remixmz-sort-desc", '\uf160'),
    SOUNDCLOUD_FILL("remixmz-soundcloud-fill", '\uf163'),
    SOUNDCLOUD_LINE("remixmz-soundcloud-line", '\uf164'),
    SOUND_MODULE_FILL("remixmz-sound-module-fill", '\uf161'),
    SOUND_MODULE_LINE("remixmz-sound-module-line", '\uf162'),
    SPACE("remixmz-space", '\uf167'),
    SPACE_SHIP_FILL("remixmz-space-ship-fill", '\uf165'),
    SPACE_SHIP_LINE("remixmz-space-ship-line", '\uf166'),
    SPAM_2_FILL("remixmz-spam-2-fill", '\uf168'),
    SPAM_2_LINE("remixmz-spam-2-line", '\uf169'),
    SPAM_3_FILL("remixmz-spam-3-fill", '\uf16a'),
    SPAM_3_LINE("remixmz-spam-3-line", '\uf16b'),
    SPAM_FILL("remixmz-spam-fill", '\uf16c'),
    SPAM_LINE("remixmz-spam-line", '\uf16d'),
    SPEAKER_2_FILL("remixmz-speaker-2-fill", '\uf16e'),
    SPEAKER_2_LINE("remixmz-speaker-2-line", '\uf16f'),
    SPEAKER_3_FILL("remixmz-speaker-3-fill", '\uf170'),
    SPEAKER_3_LINE("remixmz-speaker-3-line", '\uf171'),
    SPEAKER_FILL("remixmz-speaker-fill", '\uf172'),
    SPEAKER_LINE("remixmz-speaker-line", '\uf173'),
    SPECTRUM_FILL("remixmz-spectrum-fill", '\uf174'),
    SPECTRUM_LINE("remixmz-spectrum-line", '\uf175'),
    SPEED_FILL("remixmz-speed-fill", '\uf176'),
    SPEED_LINE("remixmz-speed-line", '\uf177'),
    SPEED_MINI_FILL("remixmz-speed-mini-fill", '\uf178'),
    SPEED_MINI_LINE("remixmz-speed-mini-line", '\uf179'),
    SPLIT_CELLS_HORIZONTAL("remixmz-split-cells-horizontal", '\uf17a'),
    SPLIT_CELLS_VERTICAL("remixmz-split-cells-vertical", '\uf17b'),
    SPOTIFY_FILL("remixmz-spotify-fill", '\uf17c'),
    SPOTIFY_LINE("remixmz-spotify-line", '\uf17d'),
    SPY_FILL("remixmz-spy-fill", '\uf17e'),
    SPY_LINE("remixmz-spy-line", '\uf17f'),
    STACKSHARE_FILL("remixmz-stackshare-fill", '\uf184'),
    STACKSHARE_LINE("remixmz-stackshare-line", '\uf185'),
    STACK_FILL("remixmz-stack-fill", '\uf180'),
    STACK_LINE("remixmz-stack-line", '\uf181'),
    STACK_OVERFLOW_FILL("remixmz-stack-overflow-fill", '\uf182'),
    STACK_OVERFLOW_LINE("remixmz-stack-overflow-line", '\uf183'),
    STAR_FILL("remixmz-star-fill", '\uf186'),
    STAR_HALF_FILL("remixmz-star-half-fill", '\uf187'),
    STAR_HALF_LINE("remixmz-star-half-line", '\uf188'),
    STAR_HALF_S_FILL("remixmz-star-half-s-fill", '\uf189'),
    STAR_HALF_S_LINE("remixmz-star-half-s-line", '\uf18a'),
    STAR_LINE("remixmz-star-line", '\uf18b'),
    STAR_SMILE_FILL("remixmz-star-smile-fill", '\uf18e'),
    STAR_SMILE_LINE("remixmz-star-smile-line", '\uf18f'),
    STAR_S_FILL("remixmz-star-s-fill", '\uf18c'),
    STAR_S_LINE("remixmz-star-s-line", '\uf18d'),
    STEAM_FILL("remixmz-steam-fill", '\uf190'),
    STEAM_LINE("remixmz-steam-line", '\uf191'),
    STEERING_2_FILL("remixmz-steering-2-fill", '\uf192'),
    STEERING_2_LINE("remixmz-steering-2-line", '\uf193'),
    STEERING_FILL("remixmz-steering-fill", '\uf194'),
    STEERING_LINE("remixmz-steering-line", '\uf195'),
    STETHOSCOPE_FILL("remixmz-stethoscope-fill", '\uf196'),
    STETHOSCOPE_LINE("remixmz-stethoscope-line", '\uf197'),
    STICKY_NOTE_2_FILL("remixmz-sticky-note-2-fill", '\uf198'),
    STICKY_NOTE_2_LINE("remixmz-sticky-note-2-line", '\uf199'),
    STICKY_NOTE_FILL("remixmz-sticky-note-fill", '\uf19a'),
    STICKY_NOTE_LINE("remixmz-sticky-note-line", '\uf19b'),
    STOCK_FILL("remixmz-stock-fill", '\uf19c'),
    STOCK_LINE("remixmz-stock-line", '\uf19d'),
    STOP_CIRCLE_FILL("remixmz-stop-circle-fill", '\uf19e'),
    STOP_CIRCLE_LINE("remixmz-stop-circle-line", '\uf19f'),
    STOP_FILL("remixmz-stop-fill", '\uf1a0'),
    STOP_LINE("remixmz-stop-line", '\uf1a1'),
    STOP_MINI_FILL("remixmz-stop-mini-fill", '\uf1a2'),
    STOP_MINI_LINE("remixmz-stop-mini-line", '\uf1a3'),
    STORE_2_FILL("remixmz-store-2-fill", '\uf1a4'),
    STORE_2_LINE("remixmz-store-2-line", '\uf1a5'),
    STORE_3_FILL("remixmz-store-3-fill", '\uf1a6'),
    STORE_3_LINE("remixmz-store-3-line", '\uf1a7'),
    STORE_FILL("remixmz-store-fill", '\uf1a8'),
    STORE_LINE("remixmz-store-line", '\uf1a9'),
    STRIKETHROUGH("remixmz-strikethrough", '\uf1ab'),
    STRIKETHROUGH_2("remixmz-strikethrough-2", '\uf1aa'),
    SUBSCRIPT("remixmz-subscript", '\uf1ad'),
    SUBSCRIPT_2("remixmz-subscript-2", '\uf1ac'),
    SUBTRACT_FILL("remixmz-subtract-fill", '\uf1ae'),
    SUBTRACT_LINE("remixmz-subtract-line", '\uf1af'),
    SUBWAY_FILL("remixmz-subway-fill", '\uf1b0'),
    SUBWAY_LINE("remixmz-subway-line", '\uf1b1'),
    SUBWAY_WIFI_FILL("remixmz-subway-wifi-fill", '\uf1b2'),
    SUBWAY_WIFI_LINE("remixmz-subway-wifi-line", '\uf1b3'),
    SUITCASE_2_FILL("remixmz-suitcase-2-fill", '\uf1b4'),
    SUITCASE_2_LINE("remixmz-suitcase-2-line", '\uf1b5'),
    SUITCASE_3_FILL("remixmz-suitcase-3-fill", '\uf1b6'),
    SUITCASE_3_LINE("remixmz-suitcase-3-line", '\uf1b7'),
    SUITCASE_FILL("remixmz-suitcase-fill", '\uf1b8'),
    SUITCASE_LINE("remixmz-suitcase-line", '\uf1b9'),
    SUN_CLOUDY_FILL("remixmz-sun-cloudy-fill", '\uf1ba'),
    SUN_CLOUDY_LINE("remixmz-sun-cloudy-line", '\uf1bb'),
    SUN_FILL("remixmz-sun-fill", '\uf1bc'),
    SUN_FOGGY_FILL("remixmz-sun-foggy-fill", '\uf1bd'),
    SUN_FOGGY_LINE("remixmz-sun-foggy-line", '\uf1be'),
    SUN_LINE("remixmz-sun-line", '\uf1bf'),
    SUPERSCRIPT("remixmz-superscript", '\uf1c1'),
    SUPERSCRIPT_2("remixmz-superscript-2", '\uf1c0'),
    SURGICAL_MASK_FILL("remixmz-surgical-mask-fill", '\uf1c2'),
    SURGICAL_MASK_LINE("remixmz-surgical-mask-line", '\uf1c3'),
    SURROUND_SOUND_FILL("remixmz-surround-sound-fill", '\uf1c4'),
    SURROUND_SOUND_LINE("remixmz-surround-sound-line", '\uf1c5'),
    SURVEY_FILL("remixmz-survey-fill", '\uf1c6'),
    SURVEY_LINE("remixmz-survey-line", '\uf1c7'),
    SWAP_BOX_FILL("remixmz-swap-box-fill", '\uf1c8'),
    SWAP_BOX_LINE("remixmz-swap-box-line", '\uf1c9'),
    SWAP_FILL("remixmz-swap-fill", '\uf1ca'),
    SWAP_LINE("remixmz-swap-line", '\uf1cb'),
    SWITCH_FILL("remixmz-switch-fill", '\uf1cc'),
    SWITCH_LINE("remixmz-switch-line", '\uf1cd'),
    SWORD_FILL("remixmz-sword-fill", '\uf1ce'),
    SWORD_LINE("remixmz-sword-line", '\uf1cf'),
    SYRINGE_FILL("remixmz-syringe-fill", '\uf1d0'),
    SYRINGE_LINE("remixmz-syringe-line", '\uf1d1'),
    TABLET_FILL("remixmz-tablet-fill", '\uf1df'),
    TABLET_LINE("remixmz-tablet-line", '\uf1e0'),
    TABLE_2("remixmz-table-2", '\uf1da'),
    TABLE_ALT_FILL("remixmz-table-alt-fill", '\uf1db'),
    TABLE_ALT_LINE("remixmz-table-alt-line", '\uf1dc'),
    TABLE_FILL("remixmz-table-fill", '\uf1dd'),
    TABLE_LINE("remixmz-table-line", '\uf1de'),
    TAKEAWAY_FILL("remixmz-takeaway-fill", '\uf1e1'),
    TAKEAWAY_LINE("remixmz-takeaway-line", '\uf1e2'),
    TAOBAO_FILL("remixmz-taobao-fill", '\uf1e3'),
    TAOBAO_LINE("remixmz-taobao-line", '\uf1e4'),
    TAPE_FILL("remixmz-tape-fill", '\uf1e5'),
    TAPE_LINE("remixmz-tape-line", '\uf1e6'),
    TASK_FILL("remixmz-task-fill", '\uf1e7'),
    TASK_LINE("remixmz-task-line", '\uf1e8'),
    TAXI_FILL("remixmz-taxi-fill", '\uf1e9'),
    TAXI_LINE("remixmz-taxi-line", '\uf1ea'),
    TAXI_WIFI_FILL("remixmz-taxi-wifi-fill", '\uf1eb'),
    TAXI_WIFI_LINE("remixmz-taxi-wifi-line", '\uf1ec'),
    TEAM_FILL("remixmz-team-fill", '\uf1ed'),
    TEAM_LINE("remixmz-team-line", '\uf1ee'),
    TELEGRAM_FILL("remixmz-telegram-fill", '\uf1ef'),
    TELEGRAM_LINE("remixmz-telegram-line", '\uf1f0'),
    TEMP_COLD_FILL("remixmz-temp-cold-fill", '\uf1f1'),
    TEMP_COLD_LINE("remixmz-temp-cold-line", '\uf1f2'),
    TEMP_HOT_FILL("remixmz-temp-hot-fill", '\uf1f3'),
    TEMP_HOT_LINE("remixmz-temp-hot-line", '\uf1f4'),
    TERMINAL_BOX_FILL("remixmz-terminal-box-fill", '\uf1f5'),
    TERMINAL_BOX_LINE("remixmz-terminal-box-line", '\uf1f6'),
    TERMINAL_FILL("remixmz-terminal-fill", '\uf1f7'),
    TERMINAL_LINE("remixmz-terminal-line", '\uf1f8'),
    TERMINAL_WINDOW_FILL("remixmz-terminal-window-fill", '\uf1f9'),
    TERMINAL_WINDOW_LINE("remixmz-terminal-window-line", '\uf1fa'),
    TEST_TUBE_FILL("remixmz-test-tube-fill", '\uf1fb'),
    TEST_TUBE_LINE("remixmz-test-tube-line", '\uf1fc'),
    TEXT("remixmz-text", '\uf201'),
    TEXT_DIRECTION_L("remixmz-text-direction-l", '\uf1fd'),
    TEXT_DIRECTION_R("remixmz-text-direction-r", '\uf1fe'),
    TEXT_SPACING("remixmz-text-spacing", '\uf1ff'),
    TEXT_WRAP("remixmz-text-wrap", '\uf200'),
    THERMOMETER_FILL("remixmz-thermometer-fill", '\uf202'),
    THERMOMETER_LINE("remixmz-thermometer-line", '\uf203'),
    THUMB_DOWN_FILL("remixmz-thumb-down-fill", '\uf204'),
    THUMB_DOWN_LINE("remixmz-thumb-down-line", '\uf205'),
    THUMB_UP_FILL("remixmz-thumb-up-fill", '\uf206'),
    THUMB_UP_LINE("remixmz-thumb-up-line", '\uf207'),
    THUNDERSTORMS_FILL("remixmz-thunderstorms-fill", '\uf208'),
    THUNDERSTORMS_LINE("remixmz-thunderstorms-line", '\uf209'),
    TICKET_2_FILL("remixmz-ticket-2-fill", '\uf20a'),
    TICKET_2_LINE("remixmz-ticket-2-line", '\uf20b'),
    TICKET_FILL("remixmz-ticket-fill", '\uf20c'),
    TICKET_LINE("remixmz-ticket-line", '\uf20d'),
    TIMER_2_FILL("remixmz-timer-2-fill", '\uf210'),
    TIMER_2_LINE("remixmz-timer-2-line", '\uf211'),
    TIMER_FILL("remixmz-timer-fill", '\uf212'),
    TIMER_FLASH_FILL("remixmz-timer-flash-fill", '\uf213'),
    TIMER_FLASH_LINE("remixmz-timer-flash-line", '\uf214'),
    TIMER_LINE("remixmz-timer-line", '\uf215'),
    TIME_FILL("remixmz-time-fill", '\uf20e'),
    TIME_LINE("remixmz-time-line", '\uf20f'),
    TODO_FILL("remixmz-todo-fill", '\uf216'),
    TODO_LINE("remixmz-todo-line", '\uf217'),
    TOGGLE_FILL("remixmz-toggle-fill", '\uf218'),
    TOGGLE_LINE("remixmz-toggle-line", '\uf219'),
    TOOLS_FILL("remixmz-tools-fill", '\uf21a'),
    TOOLS_LINE("remixmz-tools-line", '\uf21b'),
    TORNADO_FILL("remixmz-tornado-fill", '\uf21c'),
    TORNADO_LINE("remixmz-tornado-line", '\uf21d'),
    TRADEMARK_FILL("remixmz-trademark-fill", '\uf21e'),
    TRADEMARK_LINE("remixmz-trademark-line", '\uf21f'),
    TRAFFIC_LIGHT_FILL("remixmz-traffic-light-fill", '\uf220'),
    TRAFFIC_LIGHT_LINE("remixmz-traffic-light-line", '\uf221'),
    TRAIN_FILL("remixmz-train-fill", '\uf222'),
    TRAIN_LINE("remixmz-train-line", '\uf223'),
    TRAIN_WIFI_FILL("remixmz-train-wifi-fill", '\uf224'),
    TRAIN_WIFI_LINE("remixmz-train-wifi-line", '\uf225'),
    TRANSLATE("remixmz-translate", '\uf227'),
    TRANSLATE_2("remixmz-translate-2", '\uf226'),
    TRAVESTI_FILL("remixmz-travesti-fill", '\uf228'),
    TRAVESTI_LINE("remixmz-travesti-line", '\uf229'),
    TREASURE_MAP_FILL("remixmz-treasure-map-fill", '\uf22a'),
    TREASURE_MAP_LINE("remixmz-treasure-map-line", '\uf22b'),
    TRELLO_FILL("remixmz-trello-fill", '\uf22c'),
    TRELLO_LINE("remixmz-trello-line", '\uf22d'),
    TROPHY_FILL("remixmz-trophy-fill", '\uf22e'),
    TROPHY_LINE("remixmz-trophy-line", '\uf22f'),
    TRUCK_FILL("remixmz-truck-fill", '\uf230'),
    TRUCK_LINE("remixmz-truck-line", '\uf231'),
    TUMBLR_FILL("remixmz-tumblr-fill", '\uf232'),
    TUMBLR_LINE("remixmz-tumblr-line", '\uf233'),
    TV_2_FILL("remixmz-tv-2-fill", '\uf234'),
    TV_2_LINE("remixmz-tv-2-line", '\uf235'),
    TV_FILL("remixmz-tv-fill", '\uf236'),
    TV_LINE("remixmz-tv-line", '\uf237'),
    TWITCH_FILL("remixmz-twitch-fill", '\uf238'),
    TWITCH_LINE("remixmz-twitch-line", '\uf239'),
    TWITTER_FILL("remixmz-twitter-fill", '\uf23a'),
    TWITTER_LINE("remixmz-twitter-line", '\uf23b'),
    TYPHOON_FILL("remixmz-typhoon-fill", '\uf23c'),
    TYPHOON_LINE("remixmz-typhoon-line", '\uf23d'),
    T_BOX_FILL("remixmz-t-box-fill", '\uf1d2'),
    T_BOX_LINE("remixmz-t-box-line", '\uf1d3'),
    T_SHIRT_2_FILL("remixmz-t-shirt-2-fill", '\uf1d4'),
    T_SHIRT_2_LINE("remixmz-t-shirt-2-line", '\uf1d5'),
    T_SHIRT_AIR_FILL("remixmz-t-shirt-air-fill", '\uf1d6'),
    T_SHIRT_AIR_LINE("remixmz-t-shirt-air-line", '\uf1d7'),
    T_SHIRT_FILL("remixmz-t-shirt-fill", '\uf1d8'),
    T_SHIRT_LINE("remixmz-t-shirt-line", '\uf1d9'),
    UBUNTU_FILL("remixmz-ubuntu-fill", '\uf240'),
    UBUNTU_LINE("remixmz-ubuntu-line", '\uf241'),
    UMBRELLA_FILL("remixmz-umbrella-fill", '\uf242'),
    UMBRELLA_LINE("remixmz-umbrella-line", '\uf243'),
    UNDERLINE("remixmz-underline", '\uf244'),
    UNINSTALL_FILL("remixmz-uninstall-fill", '\uf245'),
    UNINSTALL_LINE("remixmz-uninstall-line", '\uf246'),
    UNSPLASH_FILL("remixmz-unsplash-fill", '\uf247'),
    UNSPLASH_LINE("remixmz-unsplash-line", '\uf248'),
    UPLOAD_2_FILL("remixmz-upload-2-fill", '\uf249'),
    UPLOAD_2_LINE("remixmz-upload-2-line", '\uf24a'),
    UPLOAD_CLOUD_2_FILL("remixmz-upload-cloud-2-fill", '\uf24b'),
    UPLOAD_CLOUD_2_LINE("remixmz-upload-cloud-2-line", '\uf24c'),
    UPLOAD_CLOUD_FILL("remixmz-upload-cloud-fill", '\uf24d'),
    UPLOAD_CLOUD_LINE("remixmz-upload-cloud-line", '\uf24e'),
    UPLOAD_FILL("remixmz-upload-fill", '\uf24f'),
    UPLOAD_LINE("remixmz-upload-line", '\uf250'),
    USB_FILL("remixmz-usb-fill", '\uf251'),
    USB_LINE("remixmz-usb-line", '\uf252'),
    USER_2_FILL("remixmz-user-2-fill", '\uf253'),
    USER_2_LINE("remixmz-user-2-line", '\uf254'),
    USER_3_FILL("remixmz-user-3-fill", '\uf255'),
    USER_3_LINE("remixmz-user-3-line", '\uf256'),
    USER_4_FILL("remixmz-user-4-fill", '\uf257'),
    USER_4_LINE("remixmz-user-4-line", '\uf258'),
    USER_5_FILL("remixmz-user-5-fill", '\uf259'),
    USER_5_LINE("remixmz-user-5-line", '\uf25a'),
    USER_6_FILL("remixmz-user-6-fill", '\uf25b'),
    USER_6_LINE("remixmz-user-6-line", '\uf25c'),
    USER_ADD_FILL("remixmz-user-add-fill", '\uf25d'),
    USER_ADD_LINE("remixmz-user-add-line", '\uf25e'),
    USER_FILL("remixmz-user-fill", '\uf25f'),
    USER_FOLLOW_FILL("remixmz-user-follow-fill", '\uf260'),
    USER_FOLLOW_LINE("remixmz-user-follow-line", '\uf261'),
    USER_HEART_FILL("remixmz-user-heart-fill", '\uf262'),
    USER_HEART_LINE("remixmz-user-heart-line", '\uf263'),
    USER_LINE("remixmz-user-line", '\uf264'),
    USER_LOCATION_FILL("remixmz-user-location-fill", '\uf265'),
    USER_LOCATION_LINE("remixmz-user-location-line", '\uf266'),
    USER_RECEIVED_2_FILL("remixmz-user-received-2-fill", '\uf267'),
    USER_RECEIVED_2_LINE("remixmz-user-received-2-line", '\uf268'),
    USER_RECEIVED_FILL("remixmz-user-received-fill", '\uf269'),
    USER_RECEIVED_LINE("remixmz-user-received-line", '\uf26a'),
    USER_SEARCH_FILL("remixmz-user-search-fill", '\uf26b'),
    USER_SEARCH_LINE("remixmz-user-search-line", '\uf26c'),
    USER_SETTINGS_FILL("remixmz-user-settings-fill", '\uf26d'),
    USER_SETTINGS_LINE("remixmz-user-settings-line", '\uf26e'),
    USER_SHARED_2_FILL("remixmz-user-shared-2-fill", '\uf26f'),
    USER_SHARED_2_LINE("remixmz-user-shared-2-line", '\uf270'),
    USER_SHARED_FILL("remixmz-user-shared-fill", '\uf271'),
    USER_SHARED_LINE("remixmz-user-shared-line", '\uf272'),
    USER_SMILE_FILL("remixmz-user-smile-fill", '\uf273'),
    USER_SMILE_LINE("remixmz-user-smile-line", '\uf274'),
    USER_STAR_FILL("remixmz-user-star-fill", '\uf275'),
    USER_STAR_LINE("remixmz-user-star-line", '\uf276'),
    USER_UNFOLLOW_FILL("remixmz-user-unfollow-fill", '\uf277'),
    USER_UNFOLLOW_LINE("remixmz-user-unfollow-line", '\uf278'),
    USER_VOICE_FILL("remixmz-user-voice-fill", '\uf279'),
    USER_VOICE_LINE("remixmz-user-voice-line", '\uf27a'),
    U_DISK_FILL("remixmz-u-disk-fill", '\uf23e'),
    U_DISK_LINE("remixmz-u-disk-line", '\uf23f'),
    VIDEO_ADD_FILL("remixmz-video-add-fill", '\uf27b'),
    VIDEO_ADD_LINE("remixmz-video-add-line", '\uf27c'),
    VIDEO_CHAT_FILL("remixmz-video-chat-fill", '\uf27d'),
    VIDEO_CHAT_LINE("remixmz-video-chat-line", '\uf27e'),
    VIDEO_DOWNLOAD_FILL("remixmz-video-download-fill", '\uf27f'),
    VIDEO_DOWNLOAD_LINE("remixmz-video-download-line", '\uf280'),
    VIDEO_FILL("remixmz-video-fill", '\uf281'),
    VIDEO_LINE("remixmz-video-line", '\uf282'),
    VIDEO_UPLOAD_FILL("remixmz-video-upload-fill", '\uf283'),
    VIDEO_UPLOAD_LINE("remixmz-video-upload-line", '\uf284'),
    VIDICON_2_FILL("remixmz-vidicon-2-fill", '\uf285'),
    VIDICON_2_LINE("remixmz-vidicon-2-line", '\uf286'),
    VIDICON_FILL("remixmz-vidicon-fill", '\uf287'),
    VIDICON_LINE("remixmz-vidicon-line", '\uf288'),
    VIMEO_FILL("remixmz-vimeo-fill", '\uf289'),
    VIMEO_LINE("remixmz-vimeo-line", '\uf28a'),
    VIP_CROWN_2_FILL("remixmz-vip-crown-2-fill", '\uf28b'),
    VIP_CROWN_2_LINE("remixmz-vip-crown-2-line", '\uf28c'),
    VIP_CROWN_FILL("remixmz-vip-crown-fill", '\uf28d'),
    VIP_CROWN_LINE("remixmz-vip-crown-line", '\uf28e'),
    VIP_DIAMOND_FILL("remixmz-vip-diamond-fill", '\uf28f'),
    VIP_DIAMOND_LINE("remixmz-vip-diamond-line", '\uf290'),
    VIP_FILL("remixmz-vip-fill", '\uf291'),
    VIP_LINE("remixmz-vip-line", '\uf292'),
    VIRUS_FILL("remixmz-virus-fill", '\uf293'),
    VIRUS_LINE("remixmz-virus-line", '\uf294'),
    VISA_FILL("remixmz-visa-fill", '\uf295'),
    VISA_LINE("remixmz-visa-line", '\uf296'),
    VOICEPRINT_FILL("remixmz-voiceprint-fill", '\uf299'),
    VOICEPRINT_LINE("remixmz-voiceprint-line", '\uf29a'),
    VOICE_RECOGNITION_FILL("remixmz-voice-recognition-fill", '\uf297'),
    VOICE_RECOGNITION_LINE("remixmz-voice-recognition-line", '\uf298'),
    VOLUME_DOWN_FILL("remixmz-volume-down-fill", '\uf29b'),
    VOLUME_DOWN_LINE("remixmz-volume-down-line", '\uf29c'),
    VOLUME_MUTE_FILL("remixmz-volume-mute-fill", '\uf29d'),
    VOLUME_MUTE_LINE("remixmz-volume-mute-line", '\uf29e'),
    VOLUME_OFF_VIBRATE_FILL("remixmz-volume-off-vibrate-fill", '\uf29f'),
    VOLUME_OFF_VIBRATE_LINE("remixmz-volume-off-vibrate-line", '\uf2a0'),
    VOLUME_UP_FILL("remixmz-volume-up-fill", '\uf2a1'),
    VOLUME_UP_LINE("remixmz-volume-up-line", '\uf2a2'),
    VOLUME_VIBRATE_FILL("remixmz-volume-vibrate-fill", '\uf2a3'),
    VOLUME_VIBRATE_LINE("remixmz-volume-vibrate-line", '\uf2a4'),
    VUEJS_FILL("remixmz-vuejs-fill", '\uf2a5'),
    VUEJS_LINE("remixmz-vuejs-line", '\uf2a6'),
    WALK_FILL("remixmz-walk-fill", '\uf2a7'),
    WALK_LINE("remixmz-walk-line", '\uf2a8'),
    WALLET_2_FILL("remixmz-wallet-2-fill", '\uf2a9'),
    WALLET_2_LINE("remixmz-wallet-2-line", '\uf2aa'),
    WALLET_3_FILL("remixmz-wallet-3-fill", '\uf2ab'),
    WALLET_3_LINE("remixmz-wallet-3-line", '\uf2ac'),
    WALLET_FILL("remixmz-wallet-fill", '\uf2ad'),
    WALLET_LINE("remixmz-wallet-line", '\uf2ae'),
    WATER_FLASH_FILL("remixmz-water-flash-fill", '\uf2af'),
    WATER_FLASH_LINE("remixmz-water-flash-line", '\uf2b0'),
    WEBCAM_FILL("remixmz-webcam-fill", '\uf2b1'),
    WEBCAM_LINE("remixmz-webcam-line", '\uf2b2'),
    WECHAT_2_FILL("remixmz-wechat-2-fill", '\uf2b3'),
    WECHAT_2_LINE("remixmz-wechat-2-line", '\uf2b4'),
    WECHAT_FILL("remixmz-wechat-fill", '\uf2b5'),
    WECHAT_LINE("remixmz-wechat-line", '\uf2b6'),
    WECHAT_PAY_FILL("remixmz-wechat-pay-fill", '\uf2b7'),
    WECHAT_PAY_LINE("remixmz-wechat-pay-line", '\uf2b8'),
    WEIBO_FILL("remixmz-weibo-fill", '\uf2b9'),
    WEIBO_LINE("remixmz-weibo-line", '\uf2ba'),
    WHATSAPP_FILL("remixmz-whatsapp-fill", '\uf2bb'),
    WHATSAPP_LINE("remixmz-whatsapp-line", '\uf2bc'),
    WHEELCHAIR_FILL("remixmz-wheelchair-fill", '\uf2bd'),
    WHEELCHAIR_LINE("remixmz-wheelchair-line", '\uf2be'),
    WIFI_FILL("remixmz-wifi-fill", '\uf2bf'),
    WIFI_LINE("remixmz-wifi-line", '\uf2c0'),
    WIFI_OFF_FILL("remixmz-wifi-off-fill", '\uf2c1'),
    WIFI_OFF_LINE("remixmz-wifi-off-line", '\uf2c2'),
    WINDOWS_FILL("remixmz-windows-fill", '\uf2c7'),
    WINDOWS_LINE("remixmz-windows-line", '\uf2c8'),
    WINDOW_2_FILL("remixmz-window-2-fill", '\uf2c3'),
    WINDOW_2_LINE("remixmz-window-2-line", '\uf2c4'),
    WINDOW_FILL("remixmz-window-fill", '\uf2c5'),
    WINDOW_LINE("remixmz-window-line", '\uf2c6'),
    WINDY_FILL("remixmz-windy-fill", '\uf2c9'),
    WINDY_LINE("remixmz-windy-line", '\uf2ca'),
    WIRELESS_CHARGING_FILL("remixmz-wireless-charging-fill", '\uf2cb'),
    WIRELESS_CHARGING_LINE("remixmz-wireless-charging-line", '\uf2cc'),
    WOMEN_FILL("remixmz-women-fill", '\uf2cd'),
    WOMEN_LINE("remixmz-women-line", '\uf2ce'),
    WUBI_INPUT("remixmz-wubi-input", '\uf2cf'),
    XBOX_FILL("remixmz-xbox-fill", '\uf2d0'),
    XBOX_LINE("remixmz-xbox-line", '\uf2d1'),
    XING_FILL("remixmz-xing-fill", '\uf2d2'),
    XING_LINE("remixmz-xing-line", '\uf2d3'),
    YOUTUBE_FILL("remixmz-youtube-fill", '\uf2d4'),
    YOUTUBE_LINE("remixmz-youtube-line", '\uf2d5'),
    ZCOOL_FILL("remixmz-zcool-fill", '\uf2d6'),
    ZCOOL_LINE("remixmz-zcool-line", '\uf2d7'),
    ZHIHU_FILL("remixmz-zhihu-fill", '\uf2d8'),
    ZHIHU_LINE("remixmz-zhihu-line", '\uf2d9'),
    ZOOM_IN_FILL("remixmz-zoom-in-fill", '\uf2da'),
    ZOOM_IN_LINE("remixmz-zoom-in-line", '\uf2db'),
    ZOOM_OUT_FILL("remixmz-zoom-out-fill", '\uf2dc'),
    ZOOM_OUT_LINE("remixmz-zoom-out-line", '\uf2dd'),
    ZZZ_FILL("remixmz-zzz-fill", '\uf2de'),
    ZZZ_LINE("remixmz-zzz-line", '\uf2df');

    public static RemixiconMZ findByDescription(String description) {
        for (RemixiconMZ font : values()) {
            if (font.getDescription().equals(description)) {
                return font;
            }
        }
        throw new IllegalArgumentException("Icon description '" + description + "' is invalid!");
    }

    private String description;
    private int code;

    RemixiconMZ(String description, int code) {
        this.description = description;
        this.code = code;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public int getCode() {
        return code;
    }
}