/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.actiontoken;

import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import org.keycloak.TokenVerifier;
import org.keycloak.authentication.actiontoken.ExplainedTokenVerificationException;
import org.keycloak.representations.JsonWebToken;

public class TokenUtils {
    public static TokenVerifier.Predicate<JsonWebToken> checkThat(BooleanSupplier function, String errorEvent, String errorMessage) {
        return t -> {
            if (!function.getAsBoolean()) {
                throw new ExplainedTokenVerificationException(t, errorEvent, errorMessage);
            }
            return true;
        };
    }

    public static <T extends JsonWebToken> TokenVerifier.Predicate<T> checkThat(Predicate<T> function, String errorEvent, String errorMessage) {
        return t -> {
            if (!function.test(t)) {
                throw new ExplainedTokenVerificationException(t, errorEvent, errorMessage);
            }
            return true;
        };
    }

    public static <T extends JsonWebToken> TokenVerifier.Predicate<T> onlyIf(Predicate<T> condition, TokenVerifier.Predicate<T> predicate) {
        return t -> !condition.test(t) || predicate.test(t);
    }

    public static <T extends JsonWebToken> TokenVerifier.Predicate<? super T>[] predicates(TokenVerifier.Predicate<? super T> ... predicate) {
        return predicate;
    }
}

