/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.test.broker.saml;

import java.io.InputStream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.broker.saml.SAMLDataMarshaller;
import org.keycloak.dom.saml.v2.assertion.AssertionType;
import org.keycloak.dom.saml.v2.assertion.AuthnStatementType;
import org.keycloak.dom.saml.v2.assertion.NameIDType;
import org.keycloak.dom.saml.v2.protocol.ResponseType;
import org.keycloak.saml.processing.core.parsers.saml.SAMLParser;

public class SAMLDataMarshallerTest {
    private static final String TEST_RESPONSE = "<samlp:Response xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\" xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\" ID=\"ID_4804cf50-cd96-4b92-823e-89adaa0c78ba\" Version=\"2.0\" IssueInstant=\"2015-11-06T11:00:33.920Z\" Destination=\"http://localhost:8081/auth/realms/realm-with-broker/broker/kc-saml-idp-basic/endpoint\" InResponseTo=\"ID_c6b90123-f0bb-4c5c-bf9d-388d5bbe467a\"><saml:Issuer>http://localhost:8082/auth/realms/realm-with-saml-idp-basic</saml:Issuer><samlp:Status><samlp:StatusCode Value=\"urn:oasis:names:tc:SAML:2.0:status:Success\"/></samlp:Status><saml:Assertion xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\" xmlns=\"urn:oasis:names:tc:SAML:2.0:assertion\" ID=\"ID_29b196c2-d641-45c8-a423-8ed8e54d4cf9\" Version=\"2.0\" IssueInstant=\"2015-11-06T11:00:33.911Z\"><saml:Issuer>http://localhost:8082/auth/realms/realm-with-saml-idp-basic</saml:Issuer><saml:Subject><saml:NameID Format=\"urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified\">test-user</saml:NameID><saml:SubjectConfirmation Method=\"urn:oasis:names:tc:SAML:2.0:cm:bearer\"><saml:SubjectConfirmationData InResponseTo=\"ID_c6b90123-f0bb-4c5c-bf9d-388d5bbe467a\" NotOnOrAfter=\"2015-11-06T11:05:31.911Z\" Recipient=\"http://localhost:8081/auth/realms/realm-with-broker/broker/kc-saml-idp-basic/endpoint\"/></saml:SubjectConfirmation></saml:Subject><saml:Conditions NotBefore=\"2015-11-06T11:00:31.911Z\" NotOnOrAfter=\"2015-11-06T11:01:31.911Z\"><saml:AudienceRestriction><saml:Audience>http://localhost:8081/auth/realms/realm-with-broker</saml:Audience></saml:AudienceRestriction></saml:Conditions><saml:AuthnStatement AuthnInstant=\"2015-11-06T11:00:33.923Z\" SessionIndex=\"fa0f4fd3-8a11-44f4-9acb-ee30c5bb8fe5\"><saml:AuthnContext><saml:AuthnContextClassRef>urn:oasis:names:tc:SAML:2.0:ac:classes:unspecified</saml:AuthnContextClassRef></saml:AuthnContext></saml:AuthnStatement><saml:AttributeStatement><saml:Attribute Name=\"mobile\" NameFormat=\"urn:oasis:names:tc:SAML:2.0:attrname-format:basic\"><saml:AttributeValue xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xsi:type=\"xs:string\">617-666-7777</saml:AttributeValue></saml:Attribute><saml:Attribute Name=\"urn:oid:1.2.840.113549.1.9.1\" FriendlyName=\"email\" NameFormat=\"urn:oasis:names:tc:SAML:2.0:attrname-format:basic\"><saml:AttributeValue xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xsi:type=\"xs:string\">test-user@localhost</saml:AttributeValue></saml:Attribute></saml:AttributeStatement><saml:AttributeStatement><saml:Attribute Name=\"Role\" NameFormat=\"urn:oasis:names:tc:SAML:2.0:attrname-format:basic\"><saml:AttributeValue xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xsi:type=\"xs:string\">manager</saml:AttributeValue></saml:Attribute></saml:AttributeStatement></saml:Assertion></samlp:Response>";
    private static final String TEST_ASSERTION = "<saml:Assertion xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\" xmlns=\"urn:oasis:names:tc:SAML:2.0:assertion\" ID=\"ID_29b196c2-d641-45c8-a423-8ed8e54d4cf9\" Version=\"2.0\" IssueInstant=\"2015-11-06T11:00:33.911Z\"><saml:Issuer>http://localhost:8082/auth/realms/realm-with-saml-idp-basic</saml:Issuer><saml:Subject><saml:NameID Format=\"urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified\">test-user</saml:NameID><saml:SubjectConfirmation Method=\"urn:oasis:names:tc:SAML:2.0:cm:bearer\"><saml:SubjectConfirmationData InResponseTo=\"ID_c6b90123-f0bb-4c5c-bf9d-388d5bbe467a\" NotOnOrAfter=\"2015-11-06T11:05:31.911Z\" Recipient=\"http://localhost:8081/auth/realms/realm-with-broker/broker/kc-saml-idp-basic/endpoint\"/></saml:SubjectConfirmation></saml:Subject><saml:Conditions NotBefore=\"2015-11-06T11:00:31.911Z\" NotOnOrAfter=\"2015-11-06T11:01:31.911Z\"><saml:AudienceRestriction><saml:Audience>http://localhost:8081/auth/realms/realm-with-broker</saml:Audience></saml:AudienceRestriction></saml:Conditions><saml:AuthnStatement AuthnInstant=\"2015-11-06T11:00:33.923Z\" SessionIndex=\"fa0f4fd3-8a11-44f4-9acb-ee30c5bb8fe5\"><saml:AuthnContext><saml:AuthnContextClassRef>urn:oasis:names:tc:SAML:2.0:ac:classes:unspecified</saml:AuthnContextClassRef></saml:AuthnContext></saml:AuthnStatement><saml:AttributeStatement><saml:Attribute Name=\"mobile\" NameFormat=\"urn:oasis:names:tc:SAML:2.0:attrname-format:basic\"><saml:AttributeValue xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xsi:type=\"xs:string\">617-666-7777</saml:AttributeValue></saml:Attribute><saml:Attribute Name=\"urn:oid:1.2.840.113549.1.9.1\" FriendlyName=\"email\" NameFormat=\"urn:oasis:names:tc:SAML:2.0:attrname-format:basic\"><saml:AttributeValue xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xsi:type=\"xs:string\">test-user@localhost</saml:AttributeValue></saml:Attribute></saml:AttributeStatement><saml:AttributeStatement><saml:Attribute Name=\"Role\" NameFormat=\"urn:oasis:names:tc:SAML:2.0:attrname-format:basic\"><saml:AttributeValue xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xsi:type=\"xs:string\">manager</saml:AttributeValue></saml:Attribute></saml:AttributeStatement></saml:Assertion>";
    private static final String TEST_ASSERTION_WITH_NAME_ID = "<saml:Assertion xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\" xmlns=\"urn:oasis:names:tc:SAML:2.0:assertion\" ID=\"ID_29b196c2-d641-45c8-a423-8ed8e54d4cf9\" Version=\"2.0\" IssueInstant=\"2015-11-06T11:00:33.911Z\"><saml:Issuer>http://localhost:8082/auth/realms/realm-with-saml-idp-basic</saml:Issuer><saml:Subject><saml:NameID Format=\"urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified\">test-user</saml:NameID><saml:SubjectConfirmation Method=\"urn:oasis:names:tc:SAML:2.0:cm:bearer\"><saml:SubjectConfirmationData InResponseTo=\"ID_c6b90123-f0bb-4c5c-bf9d-388d5bbe467a\" NotOnOrAfter=\"2015-11-06T11:05:31.911Z\" Recipient=\"http://localhost:8081/auth/realms/realm-with-broker/broker/kc-saml-idp-basic/endpoint\"/></saml:SubjectConfirmation></saml:Subject><saml:Conditions NotBefore=\"2015-11-06T11:00:31.911Z\" NotOnOrAfter=\"2015-11-06T11:01:31.911Z\"><saml:AudienceRestriction><saml:Audience>http://localhost:8081/auth/realms/realm-with-broker</saml:Audience></saml:AudienceRestriction></saml:Conditions><saml:AuthnStatement AuthnInstant=\"2015-11-06T11:00:33.923Z\" SessionIndex=\"fa0f4fd3-8a11-44f4-9acb-ee30c5bb8fe5\"><saml:AuthnContext><saml:AuthnContextClassRef>urn:oasis:names:tc:SAML:2.0:ac:classes:unspecified</saml:AuthnContextClassRef></saml:AuthnContext></saml:AuthnStatement><saml:AttributeStatement><saml:Attribute Name=\"mobile\" NameFormat=\"urn:oasis:names:tc:SAML:2.0:attrname-format:basic\"><saml:AttributeValue xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xsi:type=\"xs:string\">617-666-7777</saml:AttributeValue></saml:Attribute><saml:Attribute Name=\"urn:oid:1.2.840.113549.1.9.1\" FriendlyName=\"email\" NameFormat=\"urn:oasis:names:tc:SAML:2.0:attrname-format:basic\"><saml:AttributeValue xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xsi:type=\"xs:string\">test-user@localhost</saml:AttributeValue></saml:Attribute></saml:AttributeStatement><saml:AttributeStatement><saml:Attribute Name=\"Role\" NameFormat=\"urn:oasis:names:tc:SAML:2.0:attrname-format:basic\"><saml:AttributeValue><saml:NameID Format=\"urn:oasis:names:tc:SAML:2.0:nameid-format:persistent\">b2c6275838784dba219c92f53ea5493c8ef4da09</saml:NameID></saml:AttributeValue></saml:Attribute></saml:AttributeStatement></saml:Assertion>";
    private static final String TEST_AUTHN_TYPE = "<saml:AuthnStatement xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\" xmlns=\"urn:oasis:names:tc:SAML:2.0:assertion\" AuthnInstant=\"2015-11-06T11:00:33.923Z\" SessionIndex=\"fa0f4fd3-8a11-44f4-9acb-ee30c5bb8fe5\"><saml:AuthnContext><saml:AuthnContextClassRef>urn:oasis:names:tc:SAML:2.0:ac:classes:unspecified</saml:AuthnContextClassRef></saml:AuthnContext></saml:AuthnStatement>";

    @Test
    public void testParseResponse() {
        SAMLDataMarshaller serializer = new SAMLDataMarshaller();
        ResponseType responseType = (ResponseType)serializer.deserialize(TEST_RESPONSE, ResponseType.class);
        Assert.assertEquals((Object)"ID_4804cf50-cd96-4b92-823e-89adaa0c78ba", (Object)responseType.getID());
        Assert.assertEquals((Object)"http://localhost:8081/auth/realms/realm-with-broker/broker/kc-saml-idp-basic/endpoint", (Object)responseType.getDestination());
        Assert.assertEquals((Object)"http://localhost:8082/auth/realms/realm-with-saml-idp-basic", (Object)responseType.getIssuer().getValue());
        Assert.assertEquals((Object)"ID_29b196c2-d641-45c8-a423-8ed8e54d4cf9", (Object)((ResponseType.RTChoiceType)responseType.getAssertions().get(0)).getID());
        String serialized = serializer.serialize((Object)responseType);
        Assert.assertEquals((Object)TEST_RESPONSE, (Object)serialized);
    }

    @Test
    public void testParseAssertion() {
        SAMLDataMarshaller serializer = new SAMLDataMarshaller();
        AssertionType assertion = (AssertionType)serializer.deserialize(TEST_ASSERTION, AssertionType.class);
        Assert.assertEquals((Object)"ID_29b196c2-d641-45c8-a423-8ed8e54d4cf9", (Object)assertion.getID());
        Assert.assertEquals((Object)"test-user", (Object)((NameIDType)assertion.getSubject().getSubType().getBaseID()).getValue());
        String serialized = serializer.serialize((Object)assertion);
        Assert.assertEquals((Object)TEST_ASSERTION, (Object)serialized);
    }

    @Test
    public void testParseAssertionWitNameId() {
        SAMLDataMarshaller serializer = new SAMLDataMarshaller();
        AssertionType assertion = (AssertionType)serializer.deserialize(TEST_ASSERTION_WITH_NAME_ID, AssertionType.class);
        Assert.assertEquals((Object)"ID_29b196c2-d641-45c8-a423-8ed8e54d4cf9", (Object)assertion.getID());
        Assert.assertEquals((Object)"test-user", (Object)((NameIDType)assertion.getSubject().getSubType().getBaseID()).getValue());
        String serialized = serializer.serialize((Object)assertion);
        Assert.assertEquals((Object)TEST_ASSERTION_WITH_NAME_ID, (Object)serialized);
    }

    @Test
    public void testParseAuthnType() {
        SAMLDataMarshaller serializer = new SAMLDataMarshaller();
        AuthnStatementType authnStatement = (AuthnStatementType)serializer.deserialize(TEST_AUTHN_TYPE, AuthnStatementType.class);
        Assert.assertEquals((Object)"fa0f4fd3-8a11-44f4-9acb-ee30c5bb8fe5", (Object)authnStatement.getSessionIndex());
        String serialized = serializer.serialize((Object)authnStatement);
        Assert.assertEquals((Object)TEST_AUTHN_TYPE, (Object)serialized);
    }

    @Test
    public void testSerializeWithNamespaceInSignatureElement() throws Exception {
        SAMLParser parser = SAMLParser.getInstance();
        try (InputStream st = SAMLDataMarshallerTest.class.getResourceAsStream("saml-response-ds-ns-in-signature.xml");){
            Object parsedObject = parser.parse(st);
            MatcherAssert.assertThat((Object)parsedObject, (Matcher)CoreMatchers.instanceOf(ResponseType.class));
            ResponseType response = (ResponseType)parsedObject;
            SAMLDataMarshaller serializer = new SAMLDataMarshaller();
            String serialized = serializer.serialize((Object)((ResponseType.RTChoiceType)response.getAssertions().get(0)).getAssertion());
            AssertionType deserialized = (AssertionType)serializer.deserialize(serialized, AssertionType.class);
            MatcherAssert.assertThat((Object)deserialized, (Matcher)CoreMatchers.notNullValue());
            MatcherAssert.assertThat((Object)deserialized.getID(), (Matcher)CoreMatchers.is((Object)"id-4r-Xj702KQsM0gJyu3Fqpuwfe-LvDrEcQZpxKrhC"));
        }
    }

    @Test
    public void testSerializeWithNamespaceNotInSignatureElement() throws Exception {
        SAMLParser parser = SAMLParser.getInstance();
        try (InputStream st = SAMLDataMarshallerTest.class.getResourceAsStream("saml-response-ds-ns-above-signature.xml");){
            Object parsedObject = parser.parse(st);
            MatcherAssert.assertThat((Object)parsedObject, (Matcher)CoreMatchers.instanceOf(ResponseType.class));
            ResponseType response = (ResponseType)parsedObject;
            SAMLDataMarshaller serializer = new SAMLDataMarshaller();
            String serializedResponse = serializer.serialize((Object)response);
            String serializedAssertion = serializer.serialize((Object)((ResponseType.RTChoiceType)response.getAssertions().get(0)).getAssertion());
            ResponseType deserializedResponse = (ResponseType)serializer.deserialize(serializedResponse, ResponseType.class);
            MatcherAssert.assertThat((Object)deserializedResponse, (Matcher)CoreMatchers.notNullValue());
            MatcherAssert.assertThat((Object)deserializedResponse.getID(), (Matcher)CoreMatchers.is((Object)"id-EYgqtumZ-P-Ph7t37f-brUKMwB5MKix0sNjr-0YV"));
            AssertionType deserializedAssertion = (AssertionType)serializer.deserialize(serializedAssertion, AssertionType.class);
            MatcherAssert.assertThat((Object)deserializedAssertion, (Matcher)CoreMatchers.notNullValue());
            MatcherAssert.assertThat((Object)deserializedAssertion.getID(), (Matcher)CoreMatchers.is((Object)"id-4r-Xj702KQsM0gJyu3Fqpuwfe-LvDrEcQZpxKrhC"));
        }
    }
}

