/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.sdjwt;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.keycloak.common.VerificationException;
import org.keycloak.crypto.SignatureSignerContext;
import org.keycloak.crypto.SignatureVerifierContext;
import org.keycloak.rule.CryptoInitRule;
import org.keycloak.sdjwt.DisclosureSpec;
import org.keycloak.sdjwt.IssuerSignedJwtVerificationOpts;
import org.keycloak.sdjwt.SdJwt;
import org.keycloak.sdjwt.SdJwtFacade;
import org.keycloak.sdjwt.TestSettings;
import org.keycloak.sdjwt.TestUtils;

public abstract class SdJwtFacadeTest {
    @ClassRule
    public static CryptoInitRule cryptoInitRule = new CryptoInitRule();
    private static final String HASH_ALGORITHM = "sha-256";
    private static final String JWS_TYPE = "JWS_TYPE";
    private SdJwtFacade sdJwtFacade;
    private JsonNode claimSet;
    private DisclosureSpec disclosureSpec;

    @Before
    public void setUp() {
        SignatureSignerContext signer = TestSettings.getInstance().getIssuerSignerContext();
        this.sdJwtFacade = new SdJwtFacade(signer, HASH_ALGORITHM, JWS_TYPE);
        this.claimSet = TestUtils.readClaimSet(this.getClass(), "sdjwt/a1.example2-holder-claims.json");
        this.disclosureSpec = DisclosureSpec.builder().withUndisclosedClaim("sub", "2GLC42sKQveCfGfryNRN9w").withUndisclosedClaim("given_name", "eluV5Og3gSNII8EYnsxA_A").withUndisclosedClaim("family_name", "6Ij7tM-a5iVPGboS5tmvVA").build();
    }

    @Test
    public void shouldCreateSdJwtSuccessfully() {
        SdJwt createdSdJwt = this.sdJwtFacade.createSdJwt(this.claimSet, this.disclosureSpec);
        Assert.assertNotNull((Object)createdSdJwt);
    }

    @Test
    public void shouldVerifySdJwtSuccessfullyWithValidKeys() {
        this.claimSet = TestUtils.readClaimSet(this.getClass(), "sdjwt/a1.example2-issuer-claims.json");
        SdJwt sdJwt = this.sdJwtFacade.createSdJwt(this.claimSet, this.disclosureSpec);
        List<SignatureVerifierContext> verifyingKeys = Collections.singletonList(this.createSignatureVerifierContext("doc-signer-05-25-2022", "ES256", true));
        IssuerSignedJwtVerificationOpts verificationOpts = this.createVerificationOptions();
        try {
            this.sdJwtFacade.verifySdJwt(sdJwt, verifyingKeys, verificationOpts);
        }
        catch (VerificationException e) {
            Assert.fail((String)("Verification failed: " + e.getMessage()));
        }
    }

    @Test
    public void shouldReturnSdJwtString() {
        SdJwt sdJwt = this.sdJwtFacade.createSdJwt(this.claimSet, this.disclosureSpec);
        String sdJwtString = this.sdJwtFacade.getSdJwtString(sdJwt);
        Assert.assertNotNull((Object)sdJwtString);
        Assert.assertEquals((Object)sdJwt.toString(), (Object)sdJwtString);
    }

    @Test
    public void shouldFailVerificationWithInvalidKeys() {
        this.claimSet = TestUtils.readClaimSet(this.getClass(), "sdjwt/a1.example2-issuer-claims.json");
        SdJwt sdJwt = this.sdJwtFacade.createSdJwt(this.claimSet, this.disclosureSpec);
        List<SignatureVerifierContext> invalidKeys = Collections.singletonList(this.createSignatureVerifierContext("invalid-key-id", "invalid-algorithm", false));
        IssuerSignedJwtVerificationOpts verificationOpts = this.createVerificationOptions();
        VerificationException exception = (VerificationException)Assert.assertThrows(VerificationException.class, () -> this.sdJwtFacade.verifySdJwt(sdJwt, invalidKeys, verificationOpts));
        Assert.assertTrue((boolean)exception.getMessage().contains("Signature could not be verified"));
    }

    private SignatureVerifierContext createSignatureVerifierContext(final String kid, final String algorithm, final boolean verificationResult) {
        return new SignatureVerifierContext(){

            public String getKid() {
                return kid;
            }

            public String getAlgorithm() {
                return algorithm;
            }

            public boolean verify(byte[] data, byte[] signature) {
                return verificationResult;
            }
        };
    }

    private IssuerSignedJwtVerificationOpts createVerificationOptions() {
        return new IssuerSignedJwtVerificationOpts(true, true, false);
    }
}

