/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine;

import java.util.Optional;
import java.util.function.Supplier;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.platform.commons.util.ToStringBuilder;

@API(status=API.Status.STABLE, since="1.0")
public class FilterResult {
    private final boolean included;
    private final Optional<String> reason;

    public static FilterResult included(@Nullable String reason) {
        return new FilterResult(true, reason);
    }

    public static FilterResult excluded(@Nullable String reason) {
        return new FilterResult(false, reason);
    }

    public static FilterResult includedIf(boolean included) {
        return FilterResult.includedIf(included, () -> null, () -> null);
    }

    public static FilterResult includedIf(boolean included, Supplier<@Nullable String> inclusionReasonSupplier, Supplier<@Nullable String> exclusionReasonSupplier) {
        return included ? FilterResult.included(inclusionReasonSupplier.get()) : FilterResult.excluded(exclusionReasonSupplier.get());
    }

    private FilterResult(boolean included, @Nullable String reason) {
        this.included = included;
        this.reason = Optional.ofNullable(reason);
    }

    public boolean included() {
        return this.included;
    }

    public boolean excluded() {
        return !this.included();
    }

    public Optional<String> getReason() {
        return this.reason;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("included", (Object)this.included).append("reason", (Object)this.reason.orElse("<unknown>")).toString();
    }
}

