/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.pngj.chunks;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.CRC32;
import jogamp.opengl.util.pngj.PngHelper;
import jogamp.opengl.util.pngj.PngjBadCrcException;
import jogamp.opengl.util.pngj.PngjOutputException;
import jogamp.opengl.util.pngj.chunks.ChunkHelper;

public class ChunkRaw {
    public final int len;
    public final byte[] idbytes = new byte[4];
    public byte[] data = null;
    private int crcval = 0;

    public ChunkRaw(int n, byte[] byArray, boolean bl) {
        this.len = n;
        System.arraycopy(byArray, 0, this.idbytes, 0, 4);
        if (bl) {
            this.allocData();
        }
    }

    public void writeChunk(OutputStream outputStream) {
        if (this.idbytes.length != 4) {
            throw new PngjOutputException("bad chunkid [" + ChunkHelper.toString(this.idbytes) + "]");
        }
        this.computeCrc();
        PngHelper.writeInt4(outputStream, this.len);
        PngHelper.writeBytes(outputStream, this.idbytes);
        if (this.len > 0) {
            PngHelper.writeBytes(outputStream, this.data, 0, this.len);
        }
        PngHelper.writeInt4(outputStream, this.crcval);
    }

    private void computeCrc() {
        CRC32 cRC32 = PngHelper.getCRC();
        cRC32.reset();
        cRC32.update(this.idbytes, 0, 4);
        if (this.len > 0) {
            cRC32.update(this.data, 0, this.len);
        }
        this.crcval = (int)cRC32.getValue();
    }

    public String toString() {
        return "chunkid=" + ChunkHelper.toString(this.idbytes) + " len=" + this.len;
    }

    public int readChunkData(InputStream inputStream) {
        PngHelper.readBytes(inputStream, this.data, 0, this.len);
        int n = PngHelper.readInt4(inputStream);
        this.computeCrc();
        if (n != this.crcval) {
            throw new PngjBadCrcException("crc invalid for chunk " + this.toString() + " calc=" + this.crcval + " read=" + n);
        }
        return this.len + 4;
    }

    public ByteArrayInputStream getAsByteStream() {
        return new ByteArrayInputStream(this.data);
    }

    private void allocData() {
        if (this.data == null || this.data.length < this.len) {
            this.data = new byte[this.len];
        }
    }
}

