/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.statement;

import java.sql.SQLException;
import java.time.Duration;
import org.jdbi.v3.core.statement.ParsedSql;
import org.jdbi.v3.core.statement.SqlLogger;
import org.jdbi.v3.core.statement.StatementContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class Slf4JSqlLogger
implements SqlLogger {
    private final Logger log;
    private final Level level;

    public Slf4JSqlLogger() {
        this(LoggerFactory.getLogger((String)"org.jdbi.sql"), Level.DEBUG);
    }

    public Slf4JSqlLogger(Logger log) {
        this(log, Level.DEBUG);
    }

    public Slf4JSqlLogger(Level level) {
        this(LoggerFactory.getLogger((String)"org.jdbi.sql"), level);
    }

    public Slf4JSqlLogger(Logger log, Level level) {
        this.log = log;
        this.level = level;
    }

    @Override
    public void logAfterExecution(StatementContext context) {
        if (this.log.isEnabledForLevel(this.level)) {
            this.log.atLevel(this.level).log("Executed in {} '{}' with parameters '{}'", new Object[]{Slf4JSqlLogger.format(Duration.between(context.getExecutionMoment(), context.getCompletionMoment())), Slf4JSqlLogger.getSql(context), context.getBinding()});
        }
    }

    @Override
    public void logException(StatementContext context, SQLException ex) {
        if (this.log.isErrorEnabled()) {
            this.log.error("Exception while executing '{}' with parameters '{}'", new Object[]{Slf4JSqlLogger.getSql(context), context.getBinding(), ex});
        }
    }

    private static String getSql(StatementContext context) {
        ParsedSql parsedSql = context.getParsedSql();
        if (parsedSql != null) {
            return parsedSql.getSql();
        }
        return "<not available>";
    }

    private static String format(Duration duration) {
        long totalSeconds = duration.toSeconds();
        long h = totalSeconds / 3600L;
        long m = totalSeconds % 3600L / 60L;
        long s = totalSeconds % 60L;
        long ms = duration.toMillis() % 1000L;
        return String.format("%d:%02d:%02d.%03d", h, m, s, ms);
    }
}

