/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.mapper.reflect;

import jakarta.annotation.Nullable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

abstract class InstanceFactory<T> {
    private final Executable executable;

    protected InstanceFactory(Executable executable) {
        this.executable = Objects.requireNonNull(executable, "executable is null");
    }

    Class<?> getDeclaringClass() {
        return this.executable.getDeclaringClass();
    }

    int getParameterCount() {
        return this.executable.getParameterCount();
    }

    Parameter[] getParameters() {
        return this.executable.getParameters();
    }

    List<Type> getTypes() {
        return Arrays.stream(this.getParameters()).map(Parameter::getParameterizedType).collect(Collectors.toUnmodifiableList());
    }

    @Nullable
    <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        return this.executable.getAnnotation(annotationClass);
    }

    @Nullable
    <A extends Annotation> A getAnnotationIncludingType(Class<A> annotationClass) {
        return (A)((Annotation)Stream.of(this.getAnnotation(annotationClass), this.executable.getDeclaringClass().getAnnotation(annotationClass)).filter(Objects::nonNull).findFirst().orElse(null));
    }

    abstract T newInstance(Object ... var1);

    public abstract String toString();
}

