/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet;

import javassist.util.proxy.ProxyFactory;
import javax.el.ELContextListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.jsp.JspApplicationContext;
import javax.servlet.jsp.JspFactory;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.api.Environments;
import org.jboss.weld.context.api.helpers.ConcurrentHashMapBeanStore;
import org.jboss.weld.environment.servlet.deployment.ServletDeployment;
import org.jboss.weld.environment.servlet.services.ServletResourceInjectionServices;
import org.jboss.weld.environment.servlet.services.ServletServicesImpl;
import org.jboss.weld.environment.servlet.util.Reflections;
import org.jboss.weld.environment.tomcat.WeldAnnotationProcessor;
import org.jboss.weld.injection.spi.ResourceInjectionServices;
import org.jboss.weld.manager.api.WeldManager;
import org.jboss.weld.servlet.api.ServletListener;
import org.jboss.weld.servlet.api.ServletServices;
import org.jboss.weld.servlet.api.helpers.ForwardingServletListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Listener
extends ForwardingServletListener {
    private static final Logger log = LoggerFactory.getLogger(Listener.class);
    private static final String BOOTSTRAP_IMPL_CLASS_NAME = "org.jboss.weld.bootstrap.WeldBootstrap";
    private static final String WELD_LISTENER_CLASS_NAME = "org.jboss.weld.servlet.WeldListener";
    private static final String APPLICATION_BEAN_STORE_ATTRIBUTE_NAME = Listener.class.getName() + ".applicationBeanStore";
    private static final String EXPRESSION_FACTORY_NAME = "org.jboss.weld.el.ExpressionFactory";
    private final transient Bootstrap bootstrap;
    private final transient ServletListener weldListener;
    private WeldManager manager;

    public Listener() {
        try {
            this.bootstrap = (Bootstrap)Reflections.newInstance(BOOTSTRAP_IMPL_CLASS_NAME);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Error loading Weld bootstrap, check that Weld is on the classpath", e);
        }
        try {
            this.weldListener = (ServletListener)Reflections.newInstance(WELD_LISTENER_CLASS_NAME);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Error loading Weld listener, check that Weld is on the classpath", e);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        this.bootstrap.shutdown();
        try {
            Reflections.classForName("org.apache.AnnotationProcessor");
            sce.getServletContext().removeAttribute(WeldAnnotationProcessor.class.getName());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        super.contextDestroyed(sce);
    }

    public void contextInitialized(ServletContextEvent sce) {
        ProxyFactory.classLoaderProvider = new ProxyFactory.ClassLoaderProvider(){

            public ClassLoader get(ProxyFactory pf) {
                return Thread.currentThread().getContextClassLoader();
            }
        };
        ConcurrentHashMapBeanStore applicationBeanStore = new ConcurrentHashMapBeanStore();
        sce.getServletContext().setAttribute(APPLICATION_BEAN_STORE_ATTRIBUTE_NAME, (Object)applicationBeanStore);
        ServletDeployment deployment = new ServletDeployment(sce.getServletContext());
        try {
            deployment.getWebAppBeanDeploymentArchive().getServices().add(ResourceInjectionServices.class, new ServletResourceInjectionServices(){});
        }
        catch (NoClassDefFoundError e) {
            log.warn("@Resource injection not available in simple beans");
        }
        deployment.getServices().add(ServletServices.class, new ServletServicesImpl(deployment.getWebAppBeanDeploymentArchive()));
        this.bootstrap.startContainer(Environments.SERVLET, deployment, applicationBeanStore).startInitialization();
        this.manager = this.bootstrap.getManager(deployment.getWebAppBeanDeploymentArchive());
        boolean tomcat = true;
        try {
            Reflections.classForName("org.apache.AnnotationProcessor");
        }
        catch (IllegalArgumentException e) {
            log.info("JSR-299 injection will not be available in Servlets, Filters etc. This facility is only available in Tomcat");
            tomcat = false;
        }
        if (tomcat) {
            try {
                Class clazz = Reflections.classForName(WeldAnnotationProcessor.class.getName());
                Object annotationProcessor = clazz.getConstructor(WeldManager.class).newInstance(this.manager);
                sce.getServletContext().setAttribute(WeldAnnotationProcessor.class.getName(), annotationProcessor);
            }
            catch (Exception e) {
                log.error("Unable to create Tomcat AnnotationProcessor. JSR-299 injection will not be available in Servlets, Filters etc.", e);
            }
        }
        if (JspFactory.getDefaultFactory() != null) {
            JspApplicationContext jspApplicationContext = JspFactory.getDefaultFactory().getJspApplicationContext(sce.getServletContext());
            jspApplicationContext.addELResolver(this.manager.getELResolver());
            jspApplicationContext.addELContextListener((ELContextListener)Reflections.newInstance("org.jboss.weld.el.WeldELContextListener"));
            sce.getServletContext().setAttribute(EXPRESSION_FACTORY_NAME, (Object)this.manager.wrapExpressionFactory(jspApplicationContext.getExpressionFactory()));
        }
        this.bootstrap.deployBeans().validateBeans().endInitialization();
        super.contextInitialized(sce);
    }

    protected ServletListener delegate() {
        return this.weldListener;
    }
}

