/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.manager;

import java.util.Map;
import org.jboss.weld.bootstrap.BeanDeployment;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.CDI11Deployment;
import org.jboss.weld.manager.BeanManagerImpl;

public class BeanManagerLookupService
implements Service {
    private final CDI11Deployment deployment;
    private final Map<BeanDeploymentArchive, BeanDeployment> deployments;

    public BeanManagerLookupService(CDI11Deployment deployment, Map<BeanDeploymentArchive, BeanDeployment> deployments) {
        this.deployment = deployment;
        this.deployments = deployments;
    }

    private BeanManagerImpl lookupBeanManager(Class<?> javaClass) {
        if (this.deployment == null) {
            return null;
        }
        BeanDeploymentArchive archive = this.deployment.getBeanDeploymentArchive(javaClass);
        if (archive == null) {
            return null;
        }
        return this.deployments.get(archive).getBeanManager();
    }

    public static BeanManagerImpl lookupBeanManager(Class<?> javaClass, BeanManagerImpl fallback) {
        BeanManagerLookupService lookup = fallback.getServices().get(BeanManagerLookupService.class);
        if (lookup == null) {
            return fallback;
        }
        BeanManagerImpl result = lookup.lookupBeanManager(javaClass);
        if (result == null) {
            return fallback;
        }
        return result;
    }

    @Override
    public void cleanup() {
    }
}

