/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import java.lang.reflect.Method;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanAttributes;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMethod;
import org.jboss.weld.annotated.slim.AnnotatedTypeIdentifier;
import org.jboss.weld.bean.AbstractBean;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.AbstractProducerBean;
import org.jboss.weld.bean.DisposalMethod;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.injection.producer.ProducerMethodProducer;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.AnnotatedTypes;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.Proxies;
import org.jboss.weld.util.reflection.Formats;

public class ProducerMethod<X, T>
extends AbstractProducerBean<X, T, Method> {
    private final boolean proxiable;
    private final AnnotatedMethod<? super X> annotatedMethod;
    private volatile EnhancedAnnotatedMethod<T, ? super X> enhancedAnnotatedMethod;

    public static <X, T> ProducerMethod<X, T> of(BeanAttributes<T> attributes, EnhancedAnnotatedMethod<T, ? super X> method, AbstractClassBean<X> declaringBean, DisposalMethod<X, ?> disposalMethod, BeanManagerImpl beanManager, ServiceRegistry services) {
        return new ProducerMethod<X, T>(attributes, method, declaringBean, disposalMethod, beanManager, services);
    }

    protected ProducerMethod(BeanAttributes<T> attributes, EnhancedAnnotatedMethod<T, ? super X> method, AbstractClassBean<X> declaringBean, DisposalMethod<X, ?> disposalMethod, BeanManagerImpl beanManager, ServiceRegistry services) {
        super(attributes, ProducerMethod.createId(method, declaringBean), declaringBean, beanManager, services);
        this.enhancedAnnotatedMethod = method;
        this.annotatedMethod = method.slim();
        this.initType();
        this.proxiable = Proxies.isTypesProxyable(method.getTypeClosure());
        this.setProducer(new ProducerMethodProducer<X, T>(method, disposalMethod){

            @Override
            public BeanManagerImpl getBeanManager() {
                return ProducerMethod.this.beanManager;
            }

            @Override
            public Bean<X> getDeclaringBean() {
                return ProducerMethod.this.getDeclaringBean();
            }

            @Override
            public Bean<T> getBean() {
                return ProducerMethod.this;
            }
        });
    }

    protected static <T, X> String createId(EnhancedAnnotatedMethod<T, ? super X> method, AbstractClassBean<X> declaringBean) {
        StringBuilder sb = new StringBuilder();
        sb.append(ProducerMethod.class.getSimpleName());
        sb.append("-");
        sb.append(((AnnotatedTypeIdentifier)declaringBean.getAnnotated().getIdentifier()).asString());
        if (declaringBean.getEnhancedAnnotated().isDiscovered()) {
            sb.append(method.getSignature().toString());
        } else {
            sb.append(AnnotatedTypes.createCallableId(method));
        }
        return sb.toString();
    }

    @Override
    public AnnotatedMethod<? super X> getAnnotated() {
        return this.annotatedMethod;
    }

    @Override
    public EnhancedAnnotatedMethod<T, ? super X> getEnhancedAnnotated() {
        return Beans.checkEnhancedAnnotatedAvailable(this.enhancedAnnotatedMethod);
    }

    @Override
    public void cleanupAfterBoot() {
        this.enhancedAnnotatedMethod = null;
    }

    @Override
    protected void specialize() {
        Set<AbstractBean<?, ?>> specializedBeans = this.getSpecializedBeans();
        if (specializedBeans.isEmpty()) {
            throw new DefinitionException(BeanMessage.PRODUCER_METHOD_NOT_SPECIALIZING, this);
        }
    }

    @Override
    public String toString() {
        return "Producer Method [" + Formats.formatType(this.getAnnotated().getBaseType()) + "] with qualifiers [" + Formats.formatAnnotations(this.getQualifiers()) + "] declared as [" + this.getAnnotated() + "]";
    }

    @Override
    public boolean isProxyable() {
        return this.proxiable;
    }
}

