/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.license;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.License;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;

public class DownloadLicensesMojo
extends AbstractMojo {
    public static final int CONNECTION_TIMEOUT = 5000;
    protected MavenProject project;
    protected MavenProjectBuilder projectBuilder;
    protected ArtifactRepository localRepository;
    protected List remoteRepositories;
    private File outputDirectory;
    private File licenseSummaryFile;
    private boolean quiet;

    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)"Downloading licenses");
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        if (!this.licenseSummaryFile.getParentFile().exists()) {
            this.licenseSummaryFile.getParentFile().mkdirs();
        }
        PrintWriter licensesFileWriter = null;
        try {
            licensesFileWriter = new PrintWriter(this.licenseSummaryFile);
            licensesFileWriter.println("<!-- This file contains license information for the dependencies of " + this.project.getArtifact().getDependencyConflictId() + " -->");
            licensesFileWriter.println("<dependencies>");
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to open licenseInfo file ", (Exception)e);
        }
        Set depArtifacts = this.project.getDependencyArtifacts();
        for (Artifact depArt : depArtifacts) {
            MavenProject depProject = null;
            try {
                depProject = this.projectBuilder.buildFromRepository(depArt, this.remoteRepositories, this.localRepository);
            }
            catch (ProjectBuildingException e) {
                throw new MojoExecutionException("Unable to build project: " + depArt.getDependencyConflictId(), (Exception)((Object)e));
            }
            licensesFileWriter.println("  <dependency>");
            licensesFileWriter.println("    <groupId>" + depProject.getGroupId() + "</groupId>");
            licensesFileWriter.println("    <artifactId>" + depProject.getArtifactId() + "</artifactId>");
            licensesFileWriter.println("    <version>" + depProject.getVersion() + "</version>");
            List licenses = depProject.getLicenses();
            if (licenses.isEmpty()) {
                licensesFileWriter.println("    <!-- No license information found -->");
                licensesFileWriter.println("  </dependency>");
                if (this.quiet) continue;
                this.getLog().warn((CharSequence)("POM for dependency " + depProject.getId() + " does not contain license information."));
                continue;
            }
            licensesFileWriter.println("    <licenses>");
            for (License license : licenses) {
                licensesFileWriter.println("      <license>");
                licensesFileWriter.println("        <name>" + license.getName() + "</name>");
                licensesFileWriter.println("        <url>" + license.getUrl() + "</url>");
                licensesFileWriter.println("      </license>");
                URL licenseUrl = null;
                try {
                    String licenseFileName = this.getLicenseFileName(license);
                    File licenseOutputFile = new File(this.outputDirectory, licenseFileName);
                    if (licenseOutputFile.exists()) continue;
                    licenseUrl = new URL(license.getUrl());
                    URLConnection connection = licenseUrl.openConnection();
                    connection.setConnectTimeout(5000);
                    connection.setReadTimeout(5000);
                    InputStream licenseInputStream = connection.getInputStream();
                    FileOutputStream fileOut = new FileOutputStream(licenseOutputFile);
                    DownloadLicensesMojo.copyStream(licenseInputStream, fileOut);
                    licenseInputStream.close();
                    fileOut.close();
                }
                catch (MalformedURLException e) {
                    if (this.quiet) continue;
                    this.getLog().warn((CharSequence)("POM for dependency " + depProject.getId() + " has an invalid license URL: " + license.getUrl()));
                }
                catch (FileNotFoundException e) {
                    if (this.quiet) continue;
                    this.getLog().warn((CharSequence)("POM for dependency " + depProject.getId() + " has a license URL that returns file not found: " + license.getUrl()));
                }
                catch (IOException e) {
                    this.getLog().warn((CharSequence)("Unable to retrieve license for dependency: " + depProject.getId()));
                    this.getLog().warn((CharSequence)license.getUrl());
                    this.getLog().warn((CharSequence)e.getMessage());
                }
            }
            licensesFileWriter.println("    </licenses>");
            licensesFileWriter.println("  </dependency>");
        }
        licensesFileWriter.println("</dependencies>");
        licensesFileWriter.close();
    }

    private static void copyStream(InputStream inStream, OutputStream outStream) throws IOException {
        int len;
        byte[] buf = new byte[1024];
        while ((len = inStream.read(buf)) > 0) {
            outStream.write(buf, 0, len);
        }
    }

    private String getLicenseFileName(License license) throws MalformedURLException {
        URL licenseUrl = new URL(license.getUrl());
        File licenseUrlFile = new File(licenseUrl.getPath());
        String licenseFileName = licenseUrlFile.getName();
        if (license.getName() != null) {
            licenseFileName = license.getName() + " - " + licenseUrlFile.getName();
        }
        String DEFAULT_EXTENSION = ".txt";
        int extensionIndex = licenseFileName.lastIndexOf(".");
        if (extensionIndex == -1 || extensionIndex > licenseFileName.length() - 3) {
            licenseFileName = licenseFileName + ".txt";
        }
        return licenseFileName;
    }
}

