/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository.clustered;

import java.net.URI;
import java.net.URISyntaxException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.deployers.vfs.spi.structure.modified.StructureModificationChecker;
import org.jboss.profileservice.spi.DeploymentRepository;
import org.jboss.profileservice.spi.DeploymentRepositoryFactory;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.metadata.ProfileSourceMetaData;
import org.jboss.system.server.profileservice.repository.clustered.ClusteredDeploymentRepository;
import org.jboss.system.server.profileservice.repository.clustered.ImmutableClusteredDeploymentRepository;
import org.jboss.system.server.profileservice.repository.clustered.RepositoryClusteringHandler;
import org.jboss.system.server.profileservice.repository.clustered.local.LocalContentManagerFactory;
import org.jboss.system.server.profileservice.repository.clustered.metadata.ClusteredProfileSourceMetaData;
import org.jboss.system.server.profileservice.repository.clustered.metadata.HotDeploymentClusteredProfileSourceMetaData;
import org.jboss.system.server.profileservice.repository.clustered.metadata.ImmutableClusteredProfileSourceMetaData;
import org.jboss.virtual.VirtualFileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusteredDeploymentRepositoryFactory
implements DeploymentRepositoryFactory {
    public static final String MUTABLE_TYPE = HotDeploymentClusteredProfileSourceMetaData.class.getName();
    public static final String IMMUTABLE_TYPE = ImmutableClusteredProfileSourceMetaData.class.getName();
    private static final List<String> types = Arrays.asList(MUTABLE_TYPE, IMMUTABLE_TYPE);
    private String defaultPartitionName;
    private VirtualFileFilter deploymentFilter;
    private StructureModificationChecker checker;
    private final Set<LocalContentManagerFactory<?>> localContentManagerFactories = new HashSet();
    private final Map<ProfileKey, RepositoryClusteringHandler> clusteringHandlers = new HashMap<ProfileKey, RepositoryClusteringHandler>();

    public String getDefaultPartitionName() {
        if (this.defaultPartitionName == null) {
            this.defaultPartitionName = new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("jboss.partition.name", "DefaultPartition");
                }
            }.run();
        }
        return this.defaultPartitionName;
    }

    public void setDefaultPartitionName(String defaultPartitionName) {
        this.defaultPartitionName = defaultPartitionName;
    }

    public VirtualFileFilter getDeploymentFilter() {
        return this.deploymentFilter;
    }

    public void setDeploymentFilter(VirtualFileFilter deploymentFilter) {
        this.deploymentFilter = deploymentFilter;
    }

    public StructureModificationChecker getChecker() {
        return this.checker;
    }

    public void setChecker(StructureModificationChecker checker) {
        this.checker = checker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRepositoryClusteringHandler(RepositoryClusteringHandler handler) {
        if (handler != null) {
            ProfileKey key = handler.getProfileKey();
            Map<ProfileKey, RepositoryClusteringHandler> map = this.clusteringHandlers;
            synchronized (map) {
                this.clusteringHandlers.put(key, handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRepositoryClusteringHandler(RepositoryClusteringHandler handler) {
        if (handler != null) {
            ProfileKey key = handler.getProfileKey();
            Map<ProfileKey, RepositoryClusteringHandler> map = this.clusteringHandlers;
            synchronized (map) {
                this.clusteringHandlers.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLocalContentManagerFactory(LocalContentManagerFactory<?> factory) {
        Set<LocalContentManagerFactory<?>> set = this.localContentManagerFactories;
        synchronized (set) {
            this.localContentManagerFactories.add(factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocalContentManagerFactory(LocalContentManagerFactory<?> factory) {
        Set<LocalContentManagerFactory<?>> set = this.localContentManagerFactories;
        synchronized (set) {
            this.localContentManagerFactories.remove(factory);
        }
    }

    public DeploymentRepository createDeploymentRepository(ProfileKey key, ProfileSourceMetaData metaData) throws Exception {
        if (key == null) {
            throw new IllegalArgumentException("Null profile key.");
        }
        if (metaData == null) {
            throw new IllegalArgumentException("Null metaData");
        }
        if (!(metaData instanceof ClusteredProfileSourceMetaData)) {
            throw new IllegalArgumentException("Incompatible metadata type " + metaData.getClass().getName() + " -- a " + ClusteredProfileSourceMetaData.class.getSimpleName() + " is required");
        }
        String repositoryType = metaData.getType();
        if (repositoryType == null) {
            throw new IllegalArgumentException("Null repository type.");
        }
        if (!types.contains(repositoryType)) {
            throw new IllegalArgumentException("Cannot handle type: " + repositoryType);
        }
        ClusteredProfileSourceMetaData clusteredMD = (ClusteredProfileSourceMetaData)metaData;
        if (clusteredMD.getPartitionName() == null) {
            clusteredMD.setPartitionName(this.getDefaultPartitionName());
        }
        URI[] uris = ClusteredDeploymentRepositoryFactory.createUris(metaData);
        Map<ProfileKey, RepositoryClusteringHandler> handlers = Collections.unmodifiableMap(this.clusteringHandlers);
        Set<LocalContentManagerFactory<?>> persisters = Collections.unmodifiableSet(this.localContentManagerFactories);
        boolean immutable = clusteredMD instanceof ImmutableClusteredProfileSourceMetaData;
        if (immutable) {
            ImmutableClusteredDeploymentRepository repository = new ImmutableClusteredDeploymentRepository(key, uris, handlers, persisters);
            repository.setDeploymentFilter(this.deploymentFilter);
            repository.setChecker(this.checker);
            return repository;
        }
        ClusteredDeploymentRepository repository = new ClusteredDeploymentRepository(key, uris, handlers, persisters);
        repository.setDeploymentFilter(this.deploymentFilter);
        repository.setChecker(this.checker);
        return repository;
    }

    public String[] getTypes() {
        return types.toArray(new String[types.size()]);
    }

    private static URI[] createUris(ProfileSourceMetaData metaData) throws URISyntaxException {
        ArrayList<URI> uris = new ArrayList<URI>();
        for (String source : metaData.getSources()) {
            URI uri = new URI(source);
            uris.add(uri);
        }
        return uris.toArray(new URI[uris.size()]);
    }
}

