/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.management.upload;

import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import org.jboss.logging.Logger;
import org.jboss.profileservice.spi.ModificationInfo;
import org.jboss.profileservice.spi.MutableProfile;
import org.jboss.profileservice.spi.Profile;
import org.jboss.profileservice.spi.ProfileDeployment;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.ProfileService;
import org.jboss.system.server.profile.repository.AbstractImmutableProfile;

public class AbstractTransientProfileManager {
    public static final String TRANSIENT_PROFILE_NAME = "transient-deployment-profile";
    public static final ProfileKey TRANSIENT_PROFILE_KEY = new ProfileKey("transient-deployment-profile");
    protected ProfileService ps;
    private static final Logger log = Logger.getLogger(AbstractTransientProfileManager.class);

    public ProfileService getProfileService() {
        return this.ps;
    }

    public void setProfileService(ProfileService ps) {
        this.ps = ps;
    }

    public void start() throws Exception {
        if (this.ps == null) {
            throw new IllegalStateException("Null profile service.");
        }
        Profile profile = this.createTransientProfile();
        this.ps.registerProfile(profile);
        log.debug((Object)"activating transient profile transient-deployment-profile");
        this.ps.activateProfile(TRANSIENT_PROFILE_KEY);
        this.ps.validateProfile(TRANSIENT_PROFILE_KEY);
    }

    public void stop() {
        try {
            log.debug((Object)"deactivating transient profile: transient-deployment-profile");
            this.ps.deactivateProfile(TRANSIENT_PROFILE_KEY);
        }
        catch (Exception e) {
            log.debug((Object)"Failed to deactivate transient profile: ", (Throwable)e);
        }
        try {
            log.debug((Object)"unregistering transient profile: transient-deployment-profile");
            this.ps.unregisterProfile(TRANSIENT_PROFILE_KEY);
        }
        catch (Exception e) {
            log.debug((Object)"Failed to unregister transient profile: ", (Throwable)e);
        }
    }

    protected Profile createTransientProfile() throws Exception {
        return new TransientDeploymentProfile(TRANSIENT_PROFILE_KEY);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TransientDeploymentProfile
    extends AbstractImmutableProfile
    implements MutableProfile {
        public TransientDeploymentProfile(ProfileKey key) {
            super(key, new URI[0]);
        }

        public void addDeployment(ProfileDeployment deployment) throws Exception {
            if (deployment == null) {
                throw new IllegalArgumentException("Null deployment.");
            }
            super.addDeployment(deployment.getName(), deployment);
        }

        public void enableModifiedDeploymentChecks(boolean flag) {
        }

        public Collection<ModificationInfo> getModifiedDeployments() throws Exception {
            return Collections.emptySet();
        }

        public boolean isMutable() {
            return false;
        }
    }
}

