/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.operations;

import java.util.Locale;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.server.controller.descriptions.ServerRootDescription;
import org.jboss.dmr.ModelNode;

public class ServerShutdownHandler
implements OperationStepHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "shutdown";
    private final ControlledProcessState processState;

    public ServerShutdownHandler(ControlledProcessState processState) {
        this.processState = processState;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        final boolean restart = operation.hasDefined("restart") ? operation.get("restart").asBoolean() : false;
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                ServerShutdownHandler.this.processState.setStopping();
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        System.exit(restart ? 10 : 0);
                    }
                });
                thread.setName("Management Triggered Shutdown");
                thread.start();
                context.completeStep();
            }
        }, OperationContext.Stage.RUNTIME);
        context.completeStep();
    }

    public ModelNode getModelDescription(Locale locale) {
        return ServerRootDescription.getShutdownOperationDescription(locale);
    }
}

