/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.annotation;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;

public class CompositeIndex {
    final Collection<Index> indexes;

    public CompositeIndex(Collection<Index> indexes) {
        this.indexes = indexes;
    }

    public CompositeIndex(CompositeIndex ... indexes) {
        this.indexes = new ArrayList<Index>();
        for (CompositeIndex index : indexes) {
            this.indexes.addAll(index.indexes);
        }
    }

    public List<AnnotationInstance> getAnnotations(DotName annotationName) {
        ArrayList allInstances = new ArrayList();
        for (Index index : this.indexes) {
            List list = index.getAnnotations(annotationName);
            if (list == null) continue;
            allInstances.addAll(list);
        }
        return Collections.unmodifiableList(allInstances);
    }

    public Set<ClassInfo> getKnownDirectSubclasses(DotName className) {
        HashSet allKnown = new HashSet();
        for (Index index : this.indexes) {
            List list = index.getKnownDirectSubclasses(className);
            if (list == null) continue;
            allKnown.addAll(list);
        }
        return Collections.unmodifiableSet(allKnown);
    }

    public Set<ClassInfo> getAllKnownSubclasses(DotName className) {
        HashSet<ClassInfo> allKnown = new HashSet<ClassInfo>();
        HashSet<DotName> processedClasses = new HashSet<DotName>();
        this.getAllKnownSubClasses(className, allKnown, processedClasses);
        return allKnown;
    }

    private void getAllKnownSubClasses(DotName className, Set<ClassInfo> allKnown, Set<DotName> processedClasses) {
        HashSet<DotName> subClassesToProcess = new HashSet<DotName>();
        subClassesToProcess.add(className);
        while (!subClassesToProcess.isEmpty()) {
            Iterator toProcess = subClassesToProcess.iterator();
            DotName name = (DotName)toProcess.next();
            toProcess.remove();
            processedClasses.add(name);
            this.getAllKnownSubClasses(name, allKnown, subClassesToProcess, processedClasses);
        }
    }

    private void getAllKnownSubClasses(DotName name, Set<ClassInfo> allKnown, Set<DotName> subClassesToProcess, Set<DotName> processedClasses) {
        for (Index index : this.indexes) {
            List list = index.getKnownDirectSubclasses(name);
            if (list == null) continue;
            for (ClassInfo clazz : list) {
                DotName className = clazz.name();
                if (processedClasses.contains(className)) continue;
                allKnown.add(clazz);
                subClassesToProcess.add(className);
            }
        }
    }

    public Set<ClassInfo> getKnownDirectImplementors(DotName className) {
        HashSet allKnown = new HashSet();
        for (Index index : this.indexes) {
            List list = index.getKnownDirectImplementors(className);
            if (list == null) continue;
            allKnown.addAll(list);
        }
        return Collections.unmodifiableSet(allKnown);
    }

    public Set<ClassInfo> getAllKnownImplementors(DotName interfaceName) {
        HashSet<ClassInfo> allKnown = new HashSet<ClassInfo>();
        HashSet<DotName> subInterfacesToProcess = new HashSet<DotName>();
        HashSet<DotName> processedClasses = new HashSet<DotName>();
        subInterfacesToProcess.add(interfaceName);
        while (!subInterfacesToProcess.isEmpty()) {
            Iterator toProcess = subInterfacesToProcess.iterator();
            DotName name = (DotName)toProcess.next();
            toProcess.remove();
            processedClasses.add(name);
            this.getKnownImplementors(name, allKnown, subInterfacesToProcess, processedClasses);
        }
        return allKnown;
    }

    private void getKnownImplementors(DotName name, Set<ClassInfo> allKnown, Set<DotName> subInterfacesToProcess, Set<DotName> processedClasses) {
        for (Index index : this.indexes) {
            List list = index.getKnownDirectImplementors(name);
            if (list == null) continue;
            for (ClassInfo clazz : list) {
                DotName className = clazz.name();
                if (processedClasses.contains(className)) continue;
                if (Modifier.isInterface(clazz.flags())) {
                    subInterfacesToProcess.add(className);
                    continue;
                }
                if (allKnown.contains(clazz)) continue;
                allKnown.add(clazz);
                processedClasses.add(className);
                this.getAllKnownSubClasses(className, allKnown, processedClasses);
            }
        }
    }

    public ClassInfo getClassByName(DotName className) {
        for (Index index : this.indexes) {
            ClassInfo info = index.getClassByName(className);
            if (info == null) continue;
            return info;
        }
        return null;
    }

    public Collection<ClassInfo> getKnownClasses() {
        ArrayList allKnown = new ArrayList();
        for (Index index : this.indexes) {
            Collection list = index.getKnownClasses();
            if (list == null) continue;
            allKnown.addAll(list);
        }
        return Collections.unmodifiableCollection(allKnown);
    }
}

