/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.mgmt.domain;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.remote.TransactionalModelControllerOperationHandler;
import org.jboss.as.protocol.mgmt.FlushableDataOutput;
import org.jboss.as.protocol.mgmt.ManagementChannel;
import org.jboss.as.protocol.mgmt.ManagementClientChannelStrategy;
import org.jboss.as.protocol.mgmt.ManagementOperationHandler;
import org.jboss.as.protocol.mgmt.ManagementRequest;
import org.jboss.as.protocol.mgmt.ManagementResponseHandler;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class HostControllerServerClient
implements Service<HostControllerServerClient> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"host", "controller", "client"});
    private final InjectedValue<ManagementChannel> hcChannel = new InjectedValue();
    private final InjectedValue<ModelController> controller = new InjectedValue();
    private final String serverName;
    private final String serverProcessName;
    private final ExecutorService executor = Executors.newCachedThreadPool();

    public HostControllerServerClient(String serverName, String serverProcessName) {
        this.serverName = serverName;
        this.serverProcessName = serverProcessName;
    }

    public void start(StartContext context) throws StartException {
        ((ManagementChannel)this.hcChannel.getValue()).setOperationHandler((ManagementOperationHandler)new TransactionalModelControllerOperationHandler(this.executor, (ModelController)this.controller.getValue()));
        try {
            new ServerRegisterRequest().executeForResult(this.executor, ManagementClientChannelStrategy.create((ManagementChannel)((ManagementChannel)this.hcChannel.getValue())));
        }
        catch (Exception e) {
            throw new StartException("Failed to send registration message to host controller", (Throwable)e);
        }
    }

    public void stop(StopContext context) {
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getServerProcessName() {
        return this.serverProcessName;
    }

    public HostControllerServerClient getValue() throws IllegalStateException {
        return this;
    }

    public Injector<ManagementChannel> getHcChannelInjector() {
        return this.hcChannel;
    }

    public Injector<ModelController> getServerControllerInjector() {
        return this.controller;
    }

    private class ServerRegisterRequest
    extends ManagementRequest<Void> {
        private ServerRegisterRequest() {
        }

        protected byte getRequestCode() {
            return 0;
        }

        protected void writeRequest(int protocolVersion, FlushableDataOutput output) throws IOException {
            output.write(1);
            output.writeUTF(HostControllerServerClient.this.serverProcessName);
        }

        protected ManagementResponseHandler<Void> getResponseHandler() {
            return ManagementResponseHandler.EMPTY_RESPONSE;
        }
    }
}

