/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.server.deployment.AbstractDeploymentUnitService;
import org.jboss.as.server.deployment.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

public class DeploymentStatusHandler
implements OperationStepHandler {
    public static final String ATTRIBUTE_NAME = "status";
    public static final OperationStepHandler INSTANCE = new DeploymentStatusHandler();
    private static final ModelNode NO_METRICS = new ModelNode().set("no metrics available");

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        final PathElement element = address.getLastElement();
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                ModelNode result = context.getResult();
                ServiceController controller = context.getServiceRegistry(false).getService(Services.deploymentUnitName(element.getValue()));
                if (controller != null) {
                    if (controller.getSubstate() == ServiceController.Substate.WONT_START && controller.getState() == ServiceController.State.DOWN) {
                        result.set(AbstractDeploymentUnitService.DeploymentStatus.STOPPED.toString());
                    } else {
                        result.set(((AbstractDeploymentUnitService)controller.getService()).getStatus().toString());
                    }
                } else {
                    result.set(NO_METRICS);
                }
                context.completeStep();
            }
        }, OperationContext.Stage.RUNTIME);
        context.completeStep();
    }
}

