/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server;

import java.io.IOException;
import java.net.URI;
import org.jboss.as.domain.http.server.ManagementHttpHandler;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.com.sun.net.httpserver.Headers;
import org.jboss.com.sun.net.httpserver.HttpExchange;
import org.jboss.com.sun.net.httpserver.HttpHandler;
import org.jboss.com.sun.net.httpserver.HttpServer;

public class RootHandler
implements ManagementHttpHandler {
    public static final String ROOT_CONTEXT = "/";
    private static final String CONSOLE_LOCATION = "/console/index.html";

    @Override
    public void start(HttpServer httpServer, SecurityRealm securityRealm) {
        httpServer.createContext(ROOT_CONTEXT, (HttpHandler)this);
    }

    @Override
    public void stop(HttpServer httpServer) {
        httpServer.removeContext(ROOT_CONTEXT);
    }

    public void handle(HttpExchange http) throws IOException {
        URI uri = http.getRequestURI();
        String requestMethod = http.getRequestMethod();
        if (!"GET".equals(requestMethod)) {
            http.sendResponseHeaders(405, -1L);
            return;
        }
        String path = uri.getPath();
        if (path.equals(ROOT_CONTEXT)) {
            Headers responseHeaders = http.getResponseHeaders();
            responseHeaders.add("Location", CONSOLE_LOCATION);
            http.sendResponseHeaders(301, 0L);
            http.close();
        } else {
            http.sendResponseHeaders(404, -1L);
        }
    }
}

