/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server;

import org.jboss.as.domain.http.server.RealmReadinessFilter;
import org.jboss.as.domain.http.server.ResourceHandler;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.security.DomainCallbackHandler;
import org.jboss.com.sun.net.httpserver.HttpContext;
import org.jboss.com.sun.net.httpserver.HttpHandler;
import org.jboss.com.sun.net.httpserver.HttpServer;
import org.jboss.modules.ModuleLoadException;

public class ConsoleHandler
extends ResourceHandler {
    private static final String NOCACHE_JS = ".nocache.js";
    private static final String INDEX_HTML = "index.html";
    private static final String APP_HTML = "App.html";
    private static final String CONSOLE_MODULE = "org.jboss.as.console";
    private static final String CONTEXT = "/console";
    private static final String DEFAULT_RESOURCE = "/index.html";

    public ConsoleHandler() throws ModuleLoadException {
        super(CONTEXT, DEFAULT_RESOURCE, ConsoleHandler.getClassLoader(CONSOLE_MODULE));
    }

    @Override
    protected boolean skipCache(String resource) {
        return resource.endsWith(NOCACHE_JS) || resource.endsWith(APP_HTML) || resource.endsWith(INDEX_HTML);
    }

    @Override
    public void start(HttpServer httpServer, SecurityRealm securityRealm) {
        HttpContext httpContext = httpServer.createContext(CONTEXT, (HttpHandler)this);
        if (securityRealm != null) {
            DomainCallbackHandler domainCBH = securityRealm.getCallbackHandler();
            httpContext.getFilters().add(new RealmReadinessFilter(domainCBH, "/error"));
        }
    }
}

