/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.test.mvc.tests;

import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import javax.portlet.ResourceRequest;
import org.jasig.portlet.test.mvc.tests.BasePortletTest;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller(value="resourceURLTest")
@RequestMapping(value={"VIEW", "EDIT", "HELP", "ABOUT"}, params={"currentTest=resourceURLTest"})
public class ResourceURLController
extends BasePortletTest {
    public String getTestName() {
        return "Resource URL Test";
    }

    @RequestMapping
    public String displayBasicTestView() {
        return "resourceUrlTest";
    }

    @ResourceMapping(value="basicJsonResourceUrl")
    public String handleBasicJsonResourceUrl(ModelMap model) {
        model.addAttribute("hello", (Object)"world");
        model.addAttribute("currentTime", (Object)new Date().toString());
        return "jsonView";
    }

    @RequestMapping(params={"testname=param"})
    public String displayParameterTestView(ModelMap model, @RequestParam(value="renderParameter", required=false, defaultValue="") String renderParam) {
        model.addAttribute("existingRenderParameterValue", (Object)renderParam);
        return "resourceParamTest";
    }

    @ResourceMapping(value="paramJsonResourceUrl")
    public String handleParamResourceUrl(ResourceRequest request, ModelMap model) {
        Map previousRenderParams = request.getPrivateRenderParameterMap();
        Map resourceParams = request.getPrivateParameterMap();
        String[] renderParams = (String[])previousRenderParams.get("renderParameter");
        if (renderParams == null) {
            model.addAttribute("renderParameter", (Object)"");
        } else {
            model.addAttribute("renderParameter", (Object)renderParams[0]);
        }
        model.addAttribute("resourceParameter", (Object)Arrays.toString((Object[])resourceParams.get("resourceParameter")));
        return "jsonView";
    }

    @ActionMapping
    public void noopAction() {
    }
}

