/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.test.header;

import java.io.IOException;
import javax.portlet.GenericPortlet;
import javax.portlet.PortalContext;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HeaderTestPortlet
extends GenericPortlet {
    private Log logger = LogFactory.getLog(this.getClass());

    protected void doHeaders(RenderRequest request, RenderResponse response) {
        String renderPart = (String)request.getAttribute("javax.portlet.render_part");
        String color = "red";
        if ("RENDER_HEADERS".equals(renderPart)) {
            color = "green";
        }
        try {
            response.getWriter().write("<style type=\"text/css\">#headerTestCustomText { color:" + color + "; }</style>");
            this.logger.info((Object)"Wrote header CSS");
        }
        catch (IOException e) {
            this.logger.error((Object)"caught IOException", (Throwable)e);
        }
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        PortalContext portalContext = request.getPortalContext();
        String headElementSupportProperty = portalContext.getProperty("javax.portlet.markup.head.element.support");
        boolean headElementSupport = headElementSupportProperty != null;
        String renderPart = (String)request.getAttribute("javax.portlet.render_part");
        boolean renderPartCorrect = "RENDER_MARKUP".equals(renderPart);
        StringBuilder viewOutput = new StringBuilder();
        viewOutput.append("<ul><li>Does this portal correctly advertise support for head output (javax.portlet.PortalContext#MARKUP_HEAD_ELEMENT_SUPPORT)? <span class=\"headerTestResult\">");
        viewOutput.append(headElementSupport);
        viewOutput.append("</li><li>Does this portal correctly set the value for for javax.portlet.PortletRequest#RENDER_PART when rendering the portlet body markup? <span class=\"headerTestResult\">");
        viewOutput.append(renderPartCorrect);
        viewOutput.append("</li><li>If the header was properly rendered, the following text should be GREEN: <span id=\"headerTestCustomText\" class=\"headerTestResult\">Hello World!</span></li></ul>");
        try {
            response.getWriter().write(viewOutput.toString());
            this.logger.info((Object)"Wrote Content");
        }
        catch (IOException e) {
            this.logger.error((Object)"caught IOException", (Throwable)e);
        }
    }
}

