/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.tomcat.v8;

import org.apache.catalina.LifecycleException;
import org.jasig.cas.client.tomcat.v8.AbstractAuthenticator;
import org.jasig.cas.client.validation.Saml11TicketValidator;
import org.jasig.cas.client.validation.TicketValidator;

public final class Saml11Authenticator
extends AbstractAuthenticator {
    public static final String AUTH_METHOD = "SAML11";
    private static final String NAME = Saml11Authenticator.class.getName();
    private Saml11TicketValidator ticketValidator;
    private int tolerance = -1;

    public void setTolerance(int ms) {
        this.tolerance = ms;
    }

    @Override
    protected void startInternal() throws LifecycleException {
        super.startInternal();
        this.ticketValidator = new Saml11TicketValidator(this.getCasServerUrlPrefix());
        if (this.tolerance > -1) {
            this.ticketValidator.setTolerance((long)this.tolerance);
        }
        if (this.getEncoding() != null) {
            this.ticketValidator.setEncoding(this.getEncoding());
        }
        this.ticketValidator.setRenew(this.isRenew());
    }

    @Override
    protected TicketValidator getTicketValidator() {
        return this.ticketValidator;
    }

    @Override
    protected String getAuthenticationMethod() {
        return AUTH_METHOD;
    }

    @Override
    protected String getArtifactParameterName() {
        return "SAMLart";
    }

    @Override
    protected String getServiceParameterName() {
        return "TARGET";
    }

    @Override
    protected String getName() {
        return NAME;
    }
}

