/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.backup;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.infinispan.server.core.BackupManager;

public class BackupManagerResources
implements BackupManager.Resources {
    final Map<BackupManager.Resources.Type, Set<String>> resources;

    public BackupManagerResources(Map<BackupManager.Resources.Type, Set<String>> resources) {
        this.resources = resources;
    }

    @Override
    public Set<BackupManager.Resources.Type> includeTypes() {
        return this.resources.keySet();
    }

    @Override
    public Set<String> getQualifiedResources(BackupManager.Resources.Type type) {
        Set<String> qualified = this.resources.get((Object)type);
        return qualified.isEmpty() ? null : qualified;
    }

    public static class Builder {
        final Map<BackupManager.Resources.Type, Set<String>> resources = new HashMap<BackupManager.Resources.Type, Set<String>>();

        public Builder includeAll() {
            return this.includeAll(BackupManager.Resources.Type.values());
        }

        public Builder includeAll(BackupManager.Resources.Type ... resources) {
            for (BackupManager.Resources.Type resource : resources) {
                this.addResources(resource, new String[0]);
            }
            return this;
        }

        public Builder ignore(BackupManager.Resources.Type ... resources) {
            for (BackupManager.Resources.Type resource : resources) {
                this.resources.remove((Object)resource);
            }
            return this;
        }

        public Builder addCaches(String ... caches) {
            return this.addResources(BackupManager.Resources.Type.CACHES, caches);
        }

        public Builder addCacheConfigurations(String ... configs) {
            return this.addResources(BackupManager.Resources.Type.TEMPLATES, configs);
        }

        public Builder addCounters(String ... counters) {
            return this.addResources(BackupManager.Resources.Type.COUNTERS, counters);
        }

        public Builder addProtoSchemas(String ... schemas) {
            return this.addResources(BackupManager.Resources.Type.PROTO_SCHEMAS, schemas);
        }

        public Builder addScripts(String ... scripts) {
            return this.addResources(BackupManager.Resources.Type.TASKS, scripts);
        }

        public Builder addResources(BackupManager.Resources.Type resource, String ... resources) {
            return this.addResources(resource, Arrays.asList(resources));
        }

        public Builder addResources(BackupManager.Resources.Type resource, Collection<String> resources) {
            this.resources.compute(resource, (k, v) -> {
                Set set = v == null ? new HashSet() : v;
                set.addAll(resources);
                return set;
            });
            return this;
        }

        public BackupManagerResources build() {
            return new BackupManagerResources(this.resources);
        }
    }
}

