/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.ppg.generator;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.infinispan.ppg.generator.Action;
import org.infinispan.ppg.generator.Element;
import org.infinispan.ppg.generator.Grammar;
import org.infinispan.ppg.generator.Machine;
import org.infinispan.ppg.generator.Reference;
import org.infinispan.ppg.generator.RuleDefinition;

class Branch {
    private final RuleDefinition rule;
    final List<Element> elements = new ArrayList<Element>();
    final String file;
    final int line;
    Action sentinel;

    Branch(RuleDefinition rule, String file, int line) {
        this.rule = rule;
        this.file = file;
        this.line = line;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.sentinel != null) {
            sb.append("{ ").append(this.sentinel).append(" }? ");
        }
        for (Element e : this.elements) {
            sb.append(e).append(" ");
        }
        return sb.toString();
    }

    public void addReferences(Set<Reference> references) {
        for (Element e : this.elements) {
            e.addReferences(references);
        }
    }

    public Machine.State addStates(Machine.State prev, Machine.State target, Machine machine, Grammar grammar, List<RuleDefinition> ruleStack) {
        if (this.sentinel != null) {
            prev = prev.addSentinel(this.sentinel.code(grammar), machine.addState(ruleStack));
        }
        for (int i = 0; i < this.elements.size() - 1; ++i) {
            Element e = this.elements.get(i);
            prev = e.addStates(prev, machine.addState(ruleStack), machine, grammar, ruleStack);
        }
        Element last = this.elements.get(this.elements.size() - 1);
        if (last instanceof Reference) {
            if (this.elements.stream().filter(Reference.class::isInstance).count() == 1L) {
                prev = last.addStates(prev, machine.addState(ruleStack), machine, grammar, ruleStack);
                return prev.addBacktrack(this.rule.sourceName + " = " + ((Reference)last).sourceName + ";", target);
            }
        }
        if (last instanceof Action) {
            String type = last.analyzeType(grammar);
            if ("throw".equals(type)) {
                last.addStates(prev, null, machine, grammar, ruleStack);
                return target;
            }
            if (!"void".equals(type) || this.rule.explicitType != null) {
                return prev.addBacktrack(this.rule.sourceName + " = " + ((Action)last).code(grammar) + ";", target);
            }
        }
        return last.addStates(prev, target, machine, grammar, ruleStack);
    }

    public String analyzeType(Grammar grammar) {
        Element last = this.elements.get(this.elements.size() - 1);
        if (last instanceof Reference) {
            if (this.elements.stream().filter(Reference.class::isInstance).count() == 1L) {
                return last.analyzeType(grammar);
            }
        }
        if (last instanceof Action) {
            return last.analyzeType(grammar);
        }
        return "void";
    }
}

