/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.offline;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.MagicKey;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.test.TestingUtil;
import org.infinispan.xsite.BaseSiteUnreachableTest;
import org.infinispan.xsite.OfflineStatus;
import org.infinispan.xsite.offline.DelegatingTransport;
import org.infinispan.xsite.status.BringSiteOnlineResponse;
import org.infinispan.xsite.status.DefaultTakeOfflineManager;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"xsite"}, testName="xsite.offline.ResetOfflineStatusTest")
public class ResetOfflineStatusTest
extends BaseSiteUnreachableTest {
    private static final int FAILURES = 8;
    private static final Object[] KEYS = new Object[80];

    public ResetOfflineStatusTest() {
        this.failures = 8;
        this.lonBackupFailurePolicy = BackupFailurePolicy.FAIL;
    }

    public void testPutWithFailures() {
        int i;
        this.populateKeys(this.cache("LON-1", 0));
        EmbeddedCacheManager manager = this.cache("LON-1", 0).getCacheManager();
        Transport transport = (Transport)GlobalComponentRegistry.componentOf((EmbeddedCacheManager)manager, Transport.class);
        DelegatingTransport delegatingTransport = new DelegatingTransport(transport);
        TestingUtil.replaceComponent((CacheContainer)manager, Transport.class, delegatingTransport, true);
        DefaultTakeOfflineManager tom = this.takeOfflineManager("LON-1", 0);
        OfflineStatus offlineStatus = tom.getOfflineStatus("NYC-2");
        delegatingTransport.fail = true;
        for (i = 0; i < 8; ++i) {
            try {
                this.cache("LON-1", 0).put(KEYS[i], (Object)("v" + i));
                AssertJUnit.fail((String)"This should have failed");
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (i = 0; i < 8; ++i) {
            this.cache("LON-1", 0).put(KEYS[i], (Object)("v" + i));
        }
        for (i = 0; i < 8; ++i) {
            AssertJUnit.assertEquals((Object)("v" + i), (Object)this.cache("LON-1", 0).get(KEYS[i]));
        }
        AssertJUnit.assertEquals((Object)BringSiteOnlineResponse.BROUGHT_ONLINE, (Object)tom.bringSiteOnline("NYC-2"));
        for (i = 0; i < 7; ++i) {
            try {
                this.cache("LON-1", 0).put(KEYS[i], (Object)("v" + i));
                AssertJUnit.fail((String)"This should have failed");
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        delegatingTransport.fail = false;
        AssertJUnit.assertEquals((int)7, (int)offlineStatus.getFailureCount());
        this.cache("LON-1", 0).put(KEYS[8], (Object)"vi");
        AssertJUnit.assertEquals((int)0, (int)offlineStatus.getFailureCount());
        for (i = 0; i < 80; ++i) {
            this.cache("LON-1", 0).put(KEYS[i], (Object)("v" + i));
        }
        for (i = 0; i < 80; ++i) {
            AssertJUnit.assertEquals((Object)("v" + i), (Object)this.cache("LON-1", 0).get(KEYS[i]));
        }
    }

    @Override
    protected ConfigurationBuilder getLonActiveConfig() {
        return ResetOfflineStatusTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false);
    }

    private void populateKeys(Cache primaryOwner) {
        for (int i = 0; i < KEYS.length; ++i) {
            ResetOfflineStatusTest.KEYS[i] = new MagicKey("k" + i, primaryOwner);
        }
    }
}

