/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.irac;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.commons.time.ControlledTimeService;
import org.infinispan.commons.time.TimeService;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.manager.CacheContainer;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.xsite.AbstractMultipleSitesTest;
import org.infinispan.xsite.irac.IracManager;
import org.infinispan.xsite.irac.ManualIracManager;
import org.testng.AssertJUnit;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="xsite.irac.IracMaxIdleTest")
public class IracMaxIdleTest
extends AbstractMultipleSitesTest {
    private static final long MAX_IDLE = 1000L;
    private final ControlledTimeService timeService = new ControlledTimeService();

    @Override
    protected int defaultNumberOfNodes() {
        return 1;
    }

    @Override
    protected ConfigurationBuilder defaultConfigurationForSite(int siteIndex) {
        ConfigurationBuilder builder = super.defaultConfigurationForSite(siteIndex);
        builder.expiration().reaperEnabled(false);
        builder.sites().addBackup().site(siteIndex == 0 ? this.siteName(1) : this.siteName(0)).strategy(BackupConfiguration.BackupStrategy.ASYNC);
        return builder;
    }

    @DataProvider(name="data")
    public Object[][] data() {
        return new Object[][]{{TestData.NON_TX}, {TestData.PESSIMISTIC}, {TestData.OPTIMISTIC}};
    }

    @Test(dataProvider="data")
    public void testMaxIdle(TestData testData) {
        String cacheName = this.createCaches(testData);
        List<ManualIracManager> iracManagers = this.caches(0, cacheName).stream().map(ManualIracManager::wrapCache).peek(m -> m.disable(ManualIracManager.DisableMode.DROP)).toList();
        String key = IracMaxIdleTest.createKeyOrValue(testData, "key");
        String value = IracMaxIdleTest.createKeyOrValue(testData, "value");
        this.cache(0, 0, cacheName).put((Object)key, (Object)value, -1L, TimeUnit.MILLISECONDS, 1000L, TimeUnit.MILLISECONDS);
        this.eventuallyAssertInAllSitesAndCaches(cacheName, c -> Objects.equals(value, c.get((Object)key)));
        iracManagers.forEach(ManualIracManager::enable);
        this.timeService.advance(1001L);
        AssertJUnit.assertNull((Object)this.cache(0, 0, cacheName).get((Object)key));
        AssertJUnit.assertTrue((boolean)iracManagers.stream().anyMatch(ManualIracManager::hasPendingKeys));
        iracManagers.forEach(ManualIracManager::sendKeys);
        IracMaxIdleTest.eventually(() -> iracManagers.stream().noneMatch(ManualIracManager::hasPendingKeys));
        IracMaxIdleTest.eventually(() -> iracManagers.stream().allMatch(ManualIracManager::isEmpty));
        this.assertNoKeyInDataContainer(1, cacheName, key);
        this.assertNoKeyInDataContainer(0, cacheName, key);
        this.assertNoDataLeak(cacheName);
    }

    @Test
    public void testConcurrentWriteWithExpiration() throws Throwable {
        String cacheName = "concurrent";
        for (int i = 0; i < this.defaultNumberOfSites(); ++i) {
            IracMaxIdleTest.defineInSite(this.site(i), "concurrent", this.defaultConfigurationForSite(i).build());
            this.site(i).waitForClusterToForm("concurrent");
        }
        List<SendExpirationAfterWriteIracManager> iracManagers = this.caches(0, "concurrent").stream().map(cache -> {
            IracManager iracManager = TestingUtil.extractComponent(cache, IracManager.class);
            if (iracManager instanceof SendExpirationAfterWriteIracManager) {
                return (SendExpirationAfterWriteIracManager)iracManager;
            }
            return TestingUtil.wrapComponent(cache, IracManager.class, SendExpirationAfterWriteIracManager::new);
        }).peek(m -> m.disable(ManualIracManager.DisableMode.DROP)).toList();
        String key = "c_key";
        String value = "c_value";
        String value2 = "c_value_2";
        this.cache(0, 0, "concurrent").put((Object)"c_key", (Object)"c_value", -1L, TimeUnit.MILLISECONDS, 1000L, TimeUnit.MILLISECONDS);
        this.eventuallyAssertInAllSitesAndCaches("concurrent", c -> Objects.equals("c_value", c.get((Object)"c_key")));
        iracManagers.forEach(ManualIracManager::enable);
        this.timeService.advance(1001L);
        AssertJUnit.assertNull((Object)this.cache(0, 0, "concurrent").get((Object)"c_key"));
        AssertJUnit.assertTrue((boolean)iracManagers.stream().anyMatch(ManualIracManager::hasPendingKeys));
        this.cache(0, 0, "concurrent").put((Object)"c_key", (Object)"c_value_2");
        IracMaxIdleTest.eventually(() -> iracManagers.stream().allMatch(ManualIracManager::isEmpty), 10L, TimeUnit.SECONDS);
        iracManagers.forEach(m -> m.disable(ManualIracManager.DisableMode.SEND));
        this.eventuallyAssertInAllSitesAndCaches("concurrent", c -> Objects.equals("c_value_2", c.get((Object)"c_key")));
        AssertJUnit.assertTrue((boolean)iracManagers.stream().allMatch(ManualIracManager::isEmpty));
    }

    private static String createKeyOrValue(TestData testData, String prefix) {
        return switch (testData.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> prefix + "_ntx_";
            case 1 -> prefix + "_pes_";
            case 2 -> prefix + "_opt_";
        };
    }

    private String createCaches(TestData testData) {
        LockingMode lockingMode;
        String cacheName;
        switch (testData.ordinal()) {
            case 0: {
                return null;
            }
            case 1: {
                cacheName = "pes_cache";
                lockingMode = LockingMode.PESSIMISTIC;
                break;
            }
            case 2: {
                cacheName = "opt_cache";
                lockingMode = LockingMode.OPTIMISTIC;
                break;
            }
            default: {
                throw new IllegalStateException(String.valueOf((Object)testData));
            }
        }
        for (int i = 0; i < this.defaultNumberOfSites(); ++i) {
            IracMaxIdleTest.defineInSite(this.site(i), cacheName, this.defaultConfigurationForSite(i).transaction().transactionMode(TransactionMode.TRANSACTIONAL).lockingMode(lockingMode).build());
            this.site(i).waitForClusterToForm(cacheName);
        }
        return cacheName;
    }

    private void assertNoKeyInDataContainer(int siteIndex, String cacheName, String key) {
        for (Cache c : this.caches(siteIndex, cacheName)) {
            AssertJUnit.assertNull((Object)this.internalDataContainer(c).peek((Object)key));
        }
    }

    private InternalDataContainer<String, String> internalDataContainer(Cache<String, String> c) {
        return TestingUtil.extractComponent(c, InternalDataContainer.class);
    }

    @Override
    protected void afterSitesCreated() {
        super.afterSitesCreated();
        for (int i = 0; i < this.defaultNumberOfSites(); ++i) {
            this.site(i).cacheManagers().forEach(cm -> TestingUtil.replaceComponent((CacheContainer)cm, TimeService.class, this.timeService, true));
        }
    }

    public static enum TestData {
        NON_TX,
        PESSIMISTIC,
        OPTIMISTIC;

    }

    @Scope(value=Scopes.NAMED_CACHE)
    public static class SendExpirationAfterWriteIracManager
    extends ManualIracManager {
        SendExpirationAfterWriteIracManager(IracManager actual) {
            super(actual);
        }

        @Override
        public void trackUpdatedKey(int segment, Object key, Object lockOwner) {
            if (this.enabled) {
                ManualIracManager.PendingKeyRequest existing = (ManualIracManager.PendingKeyRequest)this.pendingKeys.get(key);
                if (existing != null && existing.isExpiration()) {
                    this.actual.trackExpiredKey(existing.getSegment(), existing.getKey(), existing.getOwner());
                }
                this.pendingKeys.put(key, new ManualIracManager.PendingKeyRequest(key, lockOwner, segment, false));
            } else {
                super.trackUpdatedKey(segment, key, lockOwner);
            }
        }
    }
}

