/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import jakarta.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.impl.TransactionTable;
import org.testng.annotations.Test;

@Test(testName="tx.ReadOnlyTxCleanupTest", groups={"functional"})
@CleanupAfterMethod
public class ReadOnlyTxCleanupTest
extends SingleCacheManagerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder c = TestCacheManagerFactory.getDefaultCacheConfiguration(true);
        return TestCacheManagerFactory.createCacheManager(c);
    }

    public void testReadOnlyTx() throws SystemException, RollbackException, HeuristicRollbackException, HeuristicMixedException, NotSupportedException {
        Cache c1 = this.cacheManager.getCache();
        this.cacheManager.defineConfiguration("two", this.cacheManager.getDefaultCacheConfiguration());
        Cache c2 = this.cacheManager.getCache("two");
        c1.put((Object)"c1", (Object)"c1");
        c2.put((Object)"c2", (Object)"c2");
        TransactionManager tm1 = this.tm();
        tm1.begin();
        c1.get((Object)"c1");
        c2.get((Object)"c2");
        tm1.commit();
        TransactionTable tt1 = TestingUtil.extractComponent(c1, TransactionTable.class);
        TransactionTable tt2 = TestingUtil.extractComponent(c2, TransactionTable.class);
        assert (tt1.getLocalTxCount() == 0);
        assert (tt2.getLocalTxCount() == 0);
    }
}

