/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.partitionhandling;

import jakarta.transaction.TransactionManager;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.conflict.EntryMergePolicy;
import org.infinispan.conflict.MergePolicy;
import org.infinispan.distribution.MagicKey;
import org.infinispan.manager.CacheContainer;
import org.infinispan.partitionhandling.PartitionHandling;
import org.infinispan.partitionhandling.impl.PartitionHandlingManager;
import org.infinispan.remoting.inboundhandler.AbstractDelegatingHandler;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.inboundhandler.PerCacheInboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.Reply;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TransportFlags;
import org.infinispan.topology.CacheTopology;
import org.infinispan.topology.LocalTopologyManager;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.AbstractControlledLocalTopologyManager;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="partitionhandling.PessimisticTxPartitionHandlingReleaseLockTest")
public class PessimisticTxPartitionHandlingReleaseLockTest
extends MultipleCacheManagersTest {
    private static final Log log = LogFactory.getLog(PessimisticTxPartitionHandlingReleaseLockTest.class);

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = PessimisticTxPartitionHandlingReleaseLockTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        builder.transaction().lockingMode(LockingMode.PESSIMISTIC).useSynchronization(true);
        builder.clustering().partitionHandling().mergePolicy((EntryMergePolicy)MergePolicy.NONE).whenSplit(PartitionHandling.DENY_READ_WRITES);
        builder.clustering().remoteTimeout(4L, TimeUnit.MINUTES);
        this.createClusteredCaches(5, TestDataSCI.INSTANCE, builder, new TransportFlags().withFD(true).withMerge(true), new String[0]);
    }

    public void testLockReleased() throws Exception {
        AdvancedCache cache0 = this.cache(0).getAdvancedCache();
        TransactionManager tm = cache0.getTransactionManager();
        ControlledInboundHandler handler1 = TestingUtil.wrapInboundInvocationHandler(this.cache(1), ControlledInboundHandler::new);
        ControlledLocalTopologyManager localTopologyManager0 = TestingUtil.wrapGlobalComponent((CacheContainer)cache0.getCacheManager(), LocalTopologyManager.class, ControlledLocalTopologyManager::new, true);
        MagicKey key = new MagicKey((Cache<?, ?>)cache0, (Cache<?, ?>[])new Cache[]{this.cache(1)});
        Future<GlobalTransaction> f = this.fork(() -> {
            tm.begin();
            cache0.lock((Object[])new MagicKey[]{key});
            AssertJUnit.assertNull((Object)cache0.get((Object)key));
            GlobalTransaction gtx = TestingUtil.getTransactionTable(cache0).getGlobalTransaction(tm.getTransaction());
            cache0.put((Object)key, (Object)key.toString());
            tm.commit();
            return gtx;
        });
        AssertJUnit.assertTrue((boolean)handler1.receivedLatch.await(30L, TimeUnit.SECONDS));
        localTopologyManager0.blockStableTopologyUpdate();
        TestingUtil.getDiscardForCache(this.manager(1)).discardAll(true);
        GlobalTransaction gtx = f.get();
        Collection pendingTransactions = TestingUtil.extractComponent(cache0, PartitionHandlingManager.class).getPartialTransactions();
        AssertJUnit.assertEquals((int)1, (int)pendingTransactions.size());
        AssertJUnit.assertEquals((Object)gtx, pendingTransactions.iterator().next());
        LockManager lockManager0 = TestingUtil.extractLockManager(cache0);
        AssertJUnit.assertTrue((boolean)lockManager0.isLocked((Object)key));
        AssertJUnit.assertEquals((Object)gtx, (Object)lockManager0.getOwner((Object)key));
        localTopologyManager0.unblockStableTopologyUpdate();
        this.eventuallyEquals(0, () -> ((LockManager)lockManager0).getNumberOfLocksHeld());
    }

    private static class ControlledInboundHandler
    extends AbstractDelegatingHandler {
        private final CountDownLatch receivedLatch = new CountDownLatch(1);

        private ControlledInboundHandler(PerCacheInboundInvocationHandler delegate) {
            super(delegate);
        }

        public void handle(CacheRpcCommand command, Reply reply, DeliverOrder order) {
            if (command instanceof PrepareCommand) {
                log.debugf("Ignoring command %s", (Object)command);
                this.receivedLatch.countDown();
            } else {
                this.delegate.handle(command, reply, order);
            }
        }
    }

    public static class ControlledLocalTopologyManager
    extends AbstractControlledLocalTopologyManager {
        private volatile CompletableFuture<Void> block = CompletableFutures.completedNull();

        private ControlledLocalTopologyManager(LocalTopologyManager delegate) {
            super(delegate);
        }

        @Override
        protected CompletionStage<Void> beforeHandleTopologyUpdate(String cacheName, CacheTopology cacheTopology, int viewId) {
            return this.block;
        }

        private void blockStableTopologyUpdate() {
            this.block = new CompletableFuture();
        }

        private void unblockStableTopologyUpdate() {
            this.block.complete(null);
        }
    }
}

