/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories.impl;

import org.infinispan.commons.IllegalLifecycleStateException;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.factories.ComponentFactory;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.factories.impl.BasicComponentRegistryImpl;
import org.infinispan.factories.impl.ComponentAlias;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.manager.ModuleRepository;
import org.infinispan.manager.TestModuleRepository;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="factories.impl.BasicComponentRegistryImplTest")
public class BasicComponentRegistryImplTest {
    private ModuleRepository moduleRepository;
    private BasicComponentRegistryImpl globalRegistry;
    private BasicComponentRegistryImpl cacheRegistry;

    @BeforeMethod(alwaysRun=true)
    public void setup() {
        this.moduleRepository = TestModuleRepository.defaultModuleRepository();
        this.globalRegistry = new BasicComponentRegistryImpl(this.moduleRepository, true, null);
        this.cacheRegistry = new BasicComponentRegistryImpl(this.moduleRepository, false, (BasicComponentRegistry)this.globalRegistry);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        this.cacheRegistry.stop();
        this.globalRegistry.stop();
    }

    public void testRegisterNoFactory() {
        this.globalRegistry.registerComponent(A.class.getName(), (Object)new A(), false);
        Exceptions.expectException(RuntimeException.class, () -> this.globalRegistry.wireDependencies((Object)new B(), true));
        Exceptions.expectException(RuntimeException.class, () -> this.globalRegistry.registerComponent(B.class.getName(), (Object)new B(), false));
        this.globalRegistry.registerAlias("AA", A.class.getName(), A.class);
        B b1 = new B();
        this.globalRegistry.wireDependencies((Object)b1, true);
        AssertJUnit.assertNotNull((Object)b1.a);
        Exceptions.expectException(RuntimeException.class, () -> this.globalRegistry.registerComponent(B.class.getName(), (Object)new B(), false));
        this.globalRegistry.replaceComponent(B.class.getName(), (Object)b1, true);
        C c1 = new C();
        this.globalRegistry.wireDependencies((Object)c1, true);
        AssertJUnit.assertNotNull((Object)c1.a);
        AssertJUnit.assertNotNull((Object)c1.b);
        C c2 = new C();
        this.globalRegistry.registerComponent(C.class.getName(), (Object)c2, false);
        AssertJUnit.assertNotNull((Object)c2.a);
        AssertJUnit.assertNotNull((Object)c2.b);
    }

    public void testRegisterWrongScope() {
        Exceptions.expectException(RuntimeException.class, () -> this.globalRegistry.registerComponent(D.class.getName(), (Object)new D3(), false));
        this.cacheRegistry.registerComponent(D.class.getName(), (Object)new D3(), false);
        Exceptions.expectException(RuntimeException.class, () -> this.cacheRegistry.registerComponent(H.class.getName(), (Object)new H(), false));
        this.globalRegistry.registerComponent(H.class.getName(), (Object)new H(), false);
    }

    @DataProvider(name="cycleClasses")
    public Object[][] cycleClasses() {
        return new Object[][]{{D.class}, {E.class}, {F.class}};
    }

    @Test(dataProvider="cycleClasses")
    public void testDependencyCycle(Class<?> entryPoint) {
        this.cacheRegistry.registerComponent(DEFFactory.class.getName(), (Object)new DEFFactory(new D1()), false);
        Exceptions.expectException(RuntimeException.class, () -> this.cacheRegistry.getComponent(entryPoint));
    }

    public void testDependencyCycleNoStart() {
        this.cacheRegistry.registerComponent(DEFFactory.class.getName(), (Object)new DEFFactory(new D1()), false);
        G g = new G();
        Exceptions.expectException(RuntimeException.class, () -> this.cacheRegistry.registerComponent(G.class.getName(), (Object)g, false));
    }

    @Test(dataProvider="cycleClasses")
    public void testDependencyCycleLazy(Class<?> entryPoint) {
        this.cacheRegistry.registerComponent(DEFFactory.class.getName(), (Object)new DEFFactory(new D2()), false);
        ComponentRef component = this.cacheRegistry.getComponent(entryPoint);
        AssertJUnit.assertNotNull((Object)component);
        Object instance = component.wired();
        AssertJUnit.assertNotNull((Object)instance);
    }

    public void testDependencyCycleLazyNoStart() {
        this.registerGlobals();
        this.cacheRegistry.registerComponent(DEFFactory.class.getName(), (Object)new DEFFactory(new D2()), false);
        G g = new G();
        this.cacheRegistry.registerComponent(G.class.getName(), (Object)g, false);
        AssertJUnit.assertNotNull((Object)g);
        AssertJUnit.assertNotNull((Object)g.c);
        AssertJUnit.assertNotNull((Object)g.c.a);
        AssertJUnit.assertNotNull((Object)g.c.b);
        AssertJUnit.assertNotNull((Object)g.f.e);
        AssertJUnit.assertNotNull((Object)g.f.e.d);
        AssertJUnit.assertNotNull((Object)g.f);
    }

    public void testFactoryRegistersComponent() {
        this.globalRegistry.registerComponent(HFactory.class.getName(), (Object)new HFactory((BasicComponentRegistry)this.globalRegistry), false);
        ComponentRef href = this.globalRegistry.getComponent(H.class.getName(), H.class);
        AssertJUnit.assertNotNull((Object)href);
        H h = (H)href.wired();
        AssertJUnit.assertNotNull((Object)h);
        ComponentRef iref = this.globalRegistry.getComponent(I.class);
        Exceptions.expectException(IllegalLifecycleStateException.class, () -> ((ComponentRef)iref).wired());
    }

    private void registerGlobals() {
        this.globalRegistry.registerComponent(A.class.getName(), (Object)new A(), false);
        this.globalRegistry.registerAlias("AA", A.class.getName(), A.class);
        this.globalRegistry.registerComponent(B.class.getName(), (Object)new B(), false);
        this.globalRegistry.registerComponent(C.class.getName(), (Object)new C(), false);
    }

    @Scope(value=Scopes.GLOBAL)
    static class A {
        A() {
        }
    }

    @Scope(value=Scopes.GLOBAL)
    static class B {
        @ComponentName(value="AA")
        @Inject
        A a;

        B() {
        }
    }

    @Scope(value=Scopes.GLOBAL)
    static class C {
        A a;
        B b;

        C() {
        }

        @Inject
        void inject(@ComponentName(value="AA") A a, B b) {
            this.a = a;
            this.b = b;
        }
    }

    @Scope(value=Scopes.NAMED_CACHE)
    static interface D {
    }

    @Scope(value=Scopes.NAMED_CACHE)
    static class D3
    implements D {
        D3() {
        }
    }

    @Scope(value=Scopes.GLOBAL)
    static class H {
        H() {
        }
    }

    @Scope(value=Scopes.NAMED_CACHE)
    static class E {
        @ComponentName(value="DD")
        @Inject
        D d;

        E() {
        }
    }

    @Scope(value=Scopes.NAMED_CACHE)
    static class F {
        @Inject
        E e;

        F() {
        }
    }

    @DefaultFactoryFor(classes={D.class, E.class, F.class}, names={"DD"})
    @Scope(value=Scopes.NAMED_CACHE)
    static class DEFFactory
    implements ComponentFactory {
        private final D d;

        DEFFactory(D d) {
            this.d = d;
        }

        public Object construct(String componentName) {
            if (D.class.getName().equals(componentName)) {
                return this.d;
            }
            if ("DD".equals(componentName)) {
                return ComponentAlias.of(D.class);
            }
            if (E.class.getName().equals(componentName)) {
                return new E();
            }
            if (F.class.getName().equals(componentName)) {
                return new F();
            }
            throw new UnsupportedOperationException();
        }
    }

    @Scope(value=Scopes.NAMED_CACHE)
    static class D1
    implements D {
        @Inject
        F f;

        D1() {
        }
    }

    @Scope(value=Scopes.NAMED_CACHE)
    static class G {
        @Inject
        C c;
        @Inject
        F f;

        G() {
        }
    }

    @Scope(value=Scopes.NAMED_CACHE)
    static class D2
    implements D {
        @Inject
        ComponentRef<F> f;

        D2() {
        }
    }

    @DefaultFactoryFor(classes={H.class})
    @Scope(value=Scopes.GLOBAL)
    public static class HFactory
    implements ComponentFactory {
        final BasicComponentRegistry registry;

        HFactory(BasicComponentRegistry registry) {
            this.registry = registry;
        }

        public Object construct(String componentName) {
            if (H.class.getName().equals(componentName)) {
                Exceptions.expectException(RuntimeException.class, () -> this.registry.registerComponent(I.class.getName(), (Object)new I(), false));
                H h = new H();
                Exceptions.expectException(RuntimeException.class, () -> this.registry.registerComponent(H.class.getName(), (Object)h, false));
                this.registry.registerComponent("HH", (Object)h, false);
                return h;
            }
            throw new UnsupportedOperationException();
        }
    }

    @Scope(value=Scopes.GLOBAL)
    static class I {
        @Inject
        H h;

        I() {
        }
    }
}

