/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.expiry;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.time.ControlledTimeService;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="expiry.ExpiryTest")
public class ExpiryTest
extends AbstractInfinispanTest {
    public static final int EXPIRATION_TIMEOUT = 3000;
    public static final int IDLE_TIMEOUT = 3000;
    CacheContainer cm;
    protected ControlledTimeService timeService;

    @BeforeMethod
    public void setUp() {
        this.cm = TestCacheManagerFactory.createCacheManager(true);
        this.timeService = new ControlledTimeService();
        TestingUtil.replaceComponent(this.cm, TimeService.class, this.timeService, true);
    }

    @AfterMethod
    public void tearDown() {
        TestingUtil.killCacheManagers(this.cm);
        this.cm = null;
    }

    public void testLifespanExpiryInPut() throws InterruptedException {
        Cache<String, String> cache = this.getCache();
        long lifespan = 3000L;
        cache.put((Object)"k", (Object)"v", lifespan, TimeUnit.MILLISECONDS);
        DataContainer dc = cache.getAdvancedCache().getDataContainer();
        InternalCacheEntry se = dc.get((Object)"k");
        assert (se.getKey().equals("k"));
        assert (se.getValue().equals("v"));
        assert (se.getLifespan() == lifespan);
        assert (se.getMaxIdle() == -1L);
        assert (!se.isExpired(this.timeService.wallClockTime()));
        assert (((String)cache.get((Object)"k")).equals("v"));
        this.timeService.advance(lifespan + 100L);
        assert (se.isExpired(this.timeService.wallClockTime()));
        assert (cache.get((Object)"k") == null);
    }

    protected Cache<String, String> getCache() {
        return this.cm.getCache();
    }

    public void testIdleExpiryInPut() throws InterruptedException {
        Cache<String, String> cache = this.getCache();
        long idleTime = 3000L;
        cache.put((Object)"k", (Object)"v", -1L, TimeUnit.MILLISECONDS, idleTime, TimeUnit.MILLISECONDS);
        DataContainer dc = cache.getAdvancedCache().getDataContainer();
        InternalCacheEntry se = dc.get((Object)"k");
        assert (se.getKey().equals("k"));
        assert (se.getValue().equals("v"));
        assert (se.getLifespan() == -1L);
        assert (se.getMaxIdle() == idleTime);
        assert (!se.isExpired(this.timeService.wallClockTime()));
        assert (((String)cache.get((Object)"k")).equals("v"));
        this.timeService.advance(idleTime + 100L);
        AssertJUnit.assertTrue((boolean)se.isExpired(this.timeService.wallClockTime()));
        AssertJUnit.assertNull((Object)cache.get((Object)"k"));
    }

    public void testLifespanExpiryInPutAll() throws InterruptedException {
        Cache<String, String> cache = this.getCache();
        long lifespan = 3000L;
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("k1", "v");
        m.put("k2", "v");
        cache.putAll(m, 3000L, TimeUnit.MILLISECONDS);
        String v1 = (String)cache.get((Object)"k1");
        String v2 = (String)cache.get((Object)"k2");
        AssertJUnit.assertEquals((String)"v", (String)v1);
        AssertJUnit.assertEquals((String)"v", (String)v2);
        this.timeService.advance(3100L);
        AssertJUnit.assertNull((Object)cache.get((Object)"k1"));
        AssertJUnit.assertNull((Object)cache.get((Object)"k2"));
    }

    public void testIdleExpiryInPutAll() throws InterruptedException {
        Cache<String, String> cache = this.getCache();
        long idleTime = 3000L;
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("k1", "v");
        m.put("k2", "v");
        cache.putAll(m, -1L, TimeUnit.MILLISECONDS, 3000L, TimeUnit.MILLISECONDS);
        AssertJUnit.assertEquals((String)"v", (String)((String)cache.get((Object)"k1")));
        AssertJUnit.assertEquals((String)"v", (String)((String)cache.get((Object)"k2")));
        this.timeService.advance(3100L);
        AssertJUnit.assertNull((Object)cache.get((Object)"k1"));
        AssertJUnit.assertNull((Object)cache.get((Object)"k2"));
    }

    public void testLifespanExpiryInPutIfAbsent() throws InterruptedException {
        Cache<String, String> cache = this.getCache();
        long lifespan = 3000L;
        assert (cache.putIfAbsent((Object)"k", (Object)"v", 3000L, TimeUnit.MILLISECONDS) == null);
        long partial = 300L;
        this.timeService.advance(3000L - partial);
        AssertJUnit.assertEquals((String)"v", (String)((String)cache.get((Object)"k")));
        this.timeService.advance(3000L);
        AssertJUnit.assertNull((Object)cache.get((Object)"k"));
        cache.put((Object)"k", (Object)"v");
        assert (cache.putIfAbsent((Object)"k", (Object)"v", 3000L, TimeUnit.MILLISECONDS) != null);
    }

    public void testIdleExpiryInPutIfAbsent() throws InterruptedException {
        Cache<String, String> cache = this.getCache();
        long idleTime = 3000L;
        AssertJUnit.assertNull((Object)cache.putIfAbsent((Object)"k", (Object)"v", -1L, TimeUnit.MILLISECONDS, idleTime, TimeUnit.MILLISECONDS));
        AssertJUnit.assertEquals((String)"v", (String)((String)cache.get((Object)"k")));
        this.timeService.advance(idleTime + 100L);
        AssertJUnit.assertNull((Object)cache.get((Object)"k"));
        cache.put((Object)"k", (Object)"v");
        AssertJUnit.assertNotNull((Object)cache.putIfAbsent((Object)"k", (Object)"v", -1L, TimeUnit.MILLISECONDS, idleTime, TimeUnit.MILLISECONDS));
    }

    public void testLifespanExpiryInReplace() throws InterruptedException {
        Cache<String, String> cache = this.getCache();
        long lifespan = 3000L;
        AssertJUnit.assertNull((Object)cache.get((Object)"k"));
        AssertJUnit.assertNull((Object)cache.replace((Object)"k", (Object)"v", 3000L, TimeUnit.MILLISECONDS));
        AssertJUnit.assertNull((Object)cache.get((Object)"k"));
        cache.put((Object)"k", (Object)"v-old");
        AssertJUnit.assertEquals((String)"v-old", (String)((String)cache.get((Object)"k")));
        AssertJUnit.assertNotNull((Object)cache.replace((Object)"k", (Object)"v", 3000L, TimeUnit.MILLISECONDS));
        AssertJUnit.assertEquals((String)"v", (String)((String)cache.get((Object)"k")));
        this.timeService.advance(3100L);
        AssertJUnit.assertNull((Object)cache.get((Object)"k"));
        cache.put((Object)"k", (Object)"v");
        AssertJUnit.assertTrue((boolean)cache.replace((Object)"k", (Object)"v", (Object)"v2", 3000L, TimeUnit.MILLISECONDS));
        this.timeService.advance(3100L);
        assert (cache.get((Object)"k") == null);
    }

    public void testIdleExpiryInReplace() throws InterruptedException {
        Cache<String, String> cache = this.getCache();
        long idleTime = 3000L;
        AssertJUnit.assertNull((Object)cache.get((Object)"k"));
        AssertJUnit.assertNull((Object)cache.replace((Object)"k", (Object)"v", -1L, TimeUnit.MILLISECONDS, idleTime, TimeUnit.MILLISECONDS));
        AssertJUnit.assertNull((Object)cache.get((Object)"k"));
        cache.put((Object)"k", (Object)"v-old");
        AssertJUnit.assertEquals((String)"v-old", (String)((String)cache.get((Object)"k")));
        AssertJUnit.assertNotNull((Object)cache.replace((Object)"k", (Object)"v", -1L, TimeUnit.MILLISECONDS, idleTime, TimeUnit.MILLISECONDS));
        AssertJUnit.assertEquals((String)"v", (String)((String)cache.get((Object)"k")));
        this.timeService.advance(idleTime + 100L);
        AssertJUnit.assertNull((Object)cache.get((Object)"k"));
        cache.put((Object)"k", (Object)"v");
        AssertJUnit.assertTrue((boolean)cache.replace((Object)"k", (Object)"v", (Object)"v2", -1L, TimeUnit.MILLISECONDS, idleTime, TimeUnit.MILLISECONDS));
        this.timeService.advance(idleTime + 100L);
        AssertJUnit.assertNull((Object)cache.get((Object)"k"));
    }

    @Test
    public void testEntrySetAfterExpiryInPut(Method m) throws Exception {
        this.doTestEntrySetAfterExpiryInPut(m, this.cm);
    }

    public void testEntrySetAfterExpiryInTransaction(Method m) throws Exception {
        CacheContainer cc = this.createTransactionalCacheContainer();
        try {
            this.doEntrySetAfterExpiryInTransaction(m, cc);
        }
        finally {
            cc.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEntrySetAfterExpiryWithStore(Method m) throws Exception {
        String location = CommonsTestingUtil.tmpDirectory(ExpiryTest.class);
        CacheContainer cc = this.createCacheContainerWithStore(location);
        try {
            this.doTestEntrySetAfterExpiryInPut(m, cc);
        }
        finally {
            cc.stop();
            Util.recursiveFileRemove((String)location);
        }
    }

    private CacheContainer createTransactionalCacheContainer() {
        EmbeddedCacheManager cc = TestCacheManagerFactory.createCacheManager(TestCacheManagerFactory.getDefaultCacheConfiguration(true));
        TestingUtil.replaceComponent((CacheContainer)cc, TimeService.class, this.timeService, true);
        return cc;
    }

    private CacheContainer createCacheContainerWithStore(String location) {
        GlobalConfigurationBuilder globalBuilder = new GlobalConfigurationBuilder().nonClusteredDefault();
        globalBuilder.globalState().persistentLocation(location);
        EmbeddedCacheManager cc = TestCacheManagerFactory.createCacheManager(globalBuilder, new ConfigurationBuilder());
        TestingUtil.replaceComponent((CacheContainer)cc, TimeService.class, this.timeService, true);
        return cc;
    }

    private void doTestEntrySetAfterExpiryInPut(Method m, CacheContainer cc) throws Exception {
        Cache cache = cc.getCache();
        HashMap<Integer, String> dataIn = new HashMap<Integer, String>();
        dataIn.put(1, TestingUtil.v(m, 1));
        dataIn.put(2, TestingUtil.v(m, 2));
        long lifespan = 3000L;
        cache.putAll(dataIn, 3000L, TimeUnit.MILLISECONDS);
        this.timeService.advance(3100L);
        AssertJUnit.assertEquals((int)0, (int)cache.entrySet().size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doEntrySetAfterExpiryInTransaction(Method m, CacheContainer cc) throws Exception {
        Cache cache = cc.getCache();
        HashMap<Integer, String> dataIn = new HashMap<Integer, String>();
        dataIn.put(1, TestingUtil.v(m, 1));
        dataIn.put(2, TestingUtil.v(m, 2));
        long lifespan = 3000L;
        cache.putAll(dataIn, 3000L, TimeUnit.MILLISECONDS);
        cache.getAdvancedCache().getTransactionManager().begin();
        try {
            HashMap<Integer, String> txDataIn = new HashMap<Integer, String>();
            txDataIn.put(3, TestingUtil.v(m, 3));
            HashMap<Integer, String> allEntriesIn = new HashMap<Integer, String>(dataIn);
            allEntriesIn.putAll(txDataIn);
            cache.putAll(txDataIn);
            this.timeService.advance(3100L);
        }
        finally {
            cache.getAdvancedCache().getTransactionManager().commit();
        }
        AssertJUnit.assertEquals((int)1, (int)cache.entrySet().size());
    }

    public void testKeySetAfterExpiryInPut(Method m) throws Exception {
        Cache cache = this.cm.getCache();
        HashMap<Integer, String> dataIn = new HashMap<Integer, String>();
        dataIn.put(1, TestingUtil.v(m, 1));
        dataIn.put(2, TestingUtil.v(m, 2));
        long lifespan = 3000L;
        cache.putAll(dataIn, 3000L, TimeUnit.MILLISECONDS);
        this.timeService.advance(3100L);
        AssertJUnit.assertEquals((int)0, (int)cache.keySet().size());
    }

    public void testKeySetAfterExpiryInTransaction(Method m) throws Exception {
        CacheContainer cc = this.createTransactionalCacheContainer();
        try {
            this.doKeySetAfterExpiryInTransaction(m, cc);
        }
        finally {
            cc.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doKeySetAfterExpiryInTransaction(Method m, CacheContainer cc) throws Exception {
        Cache cache = cc.getCache();
        HashMap<Integer, String> dataIn = new HashMap<Integer, String>();
        dataIn.put(1, TestingUtil.v(m, 1));
        dataIn.put(2, TestingUtil.v(m, 2));
        long lifespan = 3000L;
        cache.putAll(dataIn, 3000L, TimeUnit.MILLISECONDS);
        cache.getAdvancedCache().getTransactionManager().begin();
        try {
            HashMap<Integer, String> txDataIn = new HashMap<Integer, String>();
            txDataIn.put(3, TestingUtil.v(m, 3));
            HashMap<Integer, String> allEntriesIn = new HashMap<Integer, String>(dataIn);
            allEntriesIn.putAll(txDataIn);
            cache.putAll(txDataIn);
            this.timeService.advance(3100L);
        }
        finally {
            cache.getAdvancedCache().getTransactionManager().commit();
        }
        AssertJUnit.assertEquals((int)1, (int)cache.keySet().size());
    }

    public void testValuesAfterExpiryInPut(Method m) throws Exception {
        Cache cache = this.cm.getCache();
        HashMap<Integer, String> dataIn = new HashMap<Integer, String>();
        dataIn.put(1, TestingUtil.v(m, 1));
        dataIn.put(2, TestingUtil.v(m, 2));
        long lifespan = 3000L;
        cache.putAll(dataIn, 3000L, TimeUnit.MILLISECONDS);
        this.timeService.advance(3100L);
        AssertJUnit.assertEquals((int)0, (int)cache.values().size());
    }

    public void testValuesAfterExpiryInTransaction(Method m) throws Exception {
        CacheContainer cc = this.createTransactionalCacheContainer();
        try {
            this.doValuesAfterExpiryInTransaction(m, cc);
        }
        finally {
            cc.stop();
        }
    }

    public void testTransientEntrypUpdates() {
        Cache cache = this.cm.getCache();
        cache.put((Object)1, (Object)"boo", -1L, TimeUnit.SECONDS, 10L, TimeUnit.SECONDS);
        cache.put((Object)1, (Object)"boo2");
        cache.put((Object)1, (Object)"boo3");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doValuesAfterExpiryInTransaction(Method m, CacheContainer cc) throws Exception {
        Cache cache = cc.getCache();
        HashMap<Integer, String> dataIn = new HashMap<Integer, String>();
        dataIn.put(1, TestingUtil.v(m, 1));
        dataIn.put(2, TestingUtil.v(m, 2));
        long lifespan = 3000L;
        cache.putAll(dataIn, 3000L, TimeUnit.MILLISECONDS);
        cache.getAdvancedCache().getTransactionManager().begin();
        try {
            HashMap<Integer, String> txDataIn = new HashMap<Integer, String>();
            txDataIn.put(3, TestingUtil.v(m, 3));
            ArrayList allValuesIn = new ArrayList(dataIn.values());
            allValuesIn.addAll(txDataIn.values());
            cache.putAll(txDataIn);
            this.timeService.advance(3100L);
        }
        finally {
            cache.getAdvancedCache().getTransactionManager().commit();
        }
        AssertJUnit.assertEquals((int)1, (int)cache.values().size());
    }
}

