/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.topologyaware;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import org.infinispan.distribution.TestTopologyAwareAddress;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.distribution.ch.impl.DefaultConsistentHash;
import org.infinispan.distribution.ch.impl.HashFunctionPartitioner;
import org.infinispan.distribution.ch.impl.TopologyAwareConsistentHashFactory;
import org.infinispan.distribution.topologyaware.TopologyAwareOwnershipStatistics;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.TopologyAwareAddress;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="distribution.topologyaware.TopologyAwareConsistentHashFactoryTest")
public class TopologyAwareConsistentHashFactoryTest
extends AbstractInfinispanTest {
    private static final Log log = LogFactory.getLog(TopologyAwareConsistentHashFactoryTest.class);
    private static final int ADDRESS_COUNT = 25;
    public int numSegments = 100;
    private TestTopologyAwareAddress[] testAddresses;
    private List<Address> chMembers;
    private Map<Address, Float> capacityFactors;
    private ConsistentHashFactory<DefaultConsistentHash> chf;
    private KeyPartitioner keyPartitioner;
    protected DefaultConsistentHash ch;

    @BeforeMethod
    public void setUp() {
        this.chf = this.createConsistentHashFactory();
        this.chMembers = new ArrayList<Address>(25);
        this.capacityFactors = null;
        this.testAddresses = new TestTopologyAwareAddress[25];
        for (int i = 0; i < 25; ++i) {
            this.testAddresses[i] = new TestTopologyAwareAddress(i * 100);
            this.testAddresses[i].setName(Character.toString((char)(65 + i)));
        }
        this.keyPartitioner = new HashFunctionPartitioner(this.numSegments);
    }

    protected ConsistentHashFactory<DefaultConsistentHash> createConsistentHashFactory() {
        return new TopologyAwareConsistentHashFactory();
    }

    public void testNumberOfOwners() {
        this.addNode(this.testAddresses[0], "m0", null, null);
        this.updateConsistentHash(1);
        IntStream.range(0, this.numSegments).forEach(i -> this.assertOwners(i, 1));
        this.updateConsistentHash(2);
        IntStream.range(0, this.numSegments).forEach(i -> this.assertOwners(i, 1));
        this.addNode(this.testAddresses[1], "m1", null, null);
        this.updateConsistentHash(1);
        int numSegments = this.ch.getNumSegments();
        IntStream.range(0, numSegments).forEach(i -> this.assertOwners(i, 1));
        this.updateConsistentHash(2);
        IntStream.range(0, numSegments).forEach(i -> this.assertOwners(i, 2));
        this.updateConsistentHash(3);
        IntStream.range(0, numSegments).forEach(i -> this.assertOwners(i, 2));
        this.addNode(this.testAddresses[2], "m0", null, null);
        this.updateConsistentHash(1);
        IntStream.range(0, numSegments).forEach(i -> this.assertOwners(i, 1));
        this.updateConsistentHash(2);
        IntStream.range(0, numSegments).forEach(i -> this.assertOwners(i, 2));
        this.updateConsistentHash(3);
        IntStream.range(0, numSegments).forEach(i -> this.assertOwners(i, 3));
        this.updateConsistentHash(4);
        IntStream.range(0, numSegments).forEach(i -> this.assertOwners(i, 3));
    }

    private void assertOwners(int segment, int expected) {
        Assert.assertEquals((int)this.ch.locateOwnersForSegment(segment).size(), (int)expected);
    }

    public void testDifferentMachines() {
        this.addNode(this.testAddresses[0], "m0", null, null);
        this.addNode(this.testAddresses[1], "m1", null, null);
        this.addNode(this.testAddresses[2], "m0", null, null);
        this.addNode(this.testAddresses[3], "m1", null, null);
        this.assertAllLocationsWithRebalance(1);
        this.assertAllLocationsWithRebalance(2);
        this.assertAllLocationsWithRebalance(3);
    }

    public void testNumOwnerBiggerThanAvailableNodes() {
        this.addNode(this.testAddresses[0], "m0", null, null);
        this.addNode(this.testAddresses[1], "m0", null, null);
        this.addNode(this.testAddresses[2], "m0", null, null);
        this.assertAllLocationsWithRebalance(2);
        this.assertAllLocationsWithRebalance(3);
        this.assertAllLocationsWithRebalance(4);
        this.assertAllLocationsWithRebalance(99);
    }

    public void testDifferentMachines2() {
        this.addNode(this.testAddresses[0], "m0", null, null);
        this.addNode(this.testAddresses[1], "m0", null, null);
        this.addNode(this.testAddresses[2], "m1", null, null);
        this.addNode(this.testAddresses[3], "m1", null, null);
        this.addNode(this.testAddresses[4], "m2", null, null);
        this.addNode(this.testAddresses[5], "m2", null, null);
        this.assertAllLocationsWithRebalance(1);
        this.assertAllLocationsWithRebalance(2);
        this.assertAllLocationsWithRebalance(3);
        this.assertAllLocationsWithRebalance(4);
    }

    public void testDifferentMachines3() {
        this.addNode(this.testAddresses[0], "m0", "r1", "s1");
        this.addNode(this.testAddresses[1], "m1", "r1", "s1");
        this.addNode(this.testAddresses[2], "m2", "r1", "s1");
        this.assertAllLocationsWithRebalance(1);
        this.assertAllLocationsWithRebalance(2);
        this.assertAllLocationsWithRebalance(3);
        this.assertAllLocationsWithRebalance(4);
    }

    public void testDifferentRacksAndMachines() {
        this.addNode(this.testAddresses[0], "m0", "r0", null);
        this.addNode(this.testAddresses[1], "m1", "r0", null);
        this.addNode(this.testAddresses[2], "m2", "r1", null);
        this.addNode(this.testAddresses[3], "m3", "r2", null);
        this.addNode(this.testAddresses[4], "m2", "r1", null);
        this.addNode(this.testAddresses[5], "m2", "r2", null);
        this.assertAllLocationsWithRebalance(1);
        this.assertAllLocationsWithRebalance(2);
        this.assertAllLocationsWithRebalance(3);
        this.assertAllLocationsWithRebalance(4);
    }

    public void testAllSameMachine() {
        this.addNode(this.testAddresses[0], "m0", null, null);
        this.addNode(this.testAddresses[1], "m0", null, null);
        this.addNode(this.testAddresses[2], "m0", null, null);
        this.addNode(this.testAddresses[3], "m0", null, null);
        this.addNode(this.testAddresses[4], "m0", null, null);
        this.addNode(this.testAddresses[5], "m0", null, null);
        this.assertAllLocationsWithRebalance(1);
        this.assertAllLocationsWithRebalance(2);
        this.assertAllLocationsWithRebalance(3);
        this.assertAllLocationsWithRebalance(4);
    }

    public void testDifferentSites() {
        this.addNode(this.testAddresses[0], "m0", null, "s0");
        this.addNode(this.testAddresses[1], "m1", null, "s0");
        this.addNode(this.testAddresses[2], "m2", null, "s1");
        this.addNode(this.testAddresses[3], "m3", null, "s1");
        this.assertAllLocationsWithRebalance(1);
        this.assertAllLocationsWithRebalance(2);
        this.assertAllLocationsWithRebalance(3);
        this.assertAllLocationsWithRebalance(4);
    }

    public void testSitesMachines2() {
        this.addNode(this.testAddresses[0], "m0", null, "s0");
        this.addNode(this.testAddresses[1], "m1", null, "s1");
        this.addNode(this.testAddresses[2], "m2", null, "s0");
        this.addNode(this.testAddresses[3], "m3", null, "s2");
        this.addNode(this.testAddresses[4], "m4", null, "s1");
        this.addNode(this.testAddresses[5], "m5", null, "s1");
        this.assertAllLocationsWithRebalance(1);
        this.assertAllLocationsWithRebalance(2);
        this.assertAllLocationsWithRebalance(3);
        this.assertAllLocationsWithRebalance(4);
    }

    public void testSitesMachinesSameMachineName() {
        this.addNode(this.testAddresses[0], "m0", null, "r0");
        this.addNode(this.testAddresses[1], "m0", null, "r1");
        this.addNode(this.testAddresses[2], "m0", null, "r0");
        this.addNode(this.testAddresses[3], "m0", null, "r2");
        this.addNode(this.testAddresses[4], "m0", null, "r1");
        this.addNode(this.testAddresses[5], "m0", null, "r1");
        this.assertAllLocationsWithRebalance(1);
        this.assertAllLocationsWithRebalance(2);
        this.assertAllLocationsWithRebalance(3);
        this.assertAllLocationsWithRebalance(4);
    }

    public void testDifferentRacks() {
        this.addNode(this.testAddresses[0], "m0", "r0", null);
        this.addNode(this.testAddresses[1], "m1", "r0", null);
        this.addNode(this.testAddresses[2], "m2", "r1", null);
        this.addNode(this.testAddresses[3], "m3", "r1", null);
        this.assertAllLocationsWithRebalance(1);
        this.assertAllLocationsWithRebalance(2);
        this.assertAllLocationsWithRebalance(3);
        this.assertAllLocationsWithRebalance(4);
    }

    public void testRacksMachines2() {
        this.addNode(this.testAddresses[0], "m0", "r0", null);
        this.addNode(this.testAddresses[1], "m1", "r1", null);
        this.addNode(this.testAddresses[2], "m2", "r0", null);
        this.addNode(this.testAddresses[3], "m3", "r2", null);
        this.addNode(this.testAddresses[4], "m4", "r1", null);
        this.addNode(this.testAddresses[5], "m5", "r1", null);
        this.assertAllLocationsWithRebalance(1);
        this.assertAllLocationsWithRebalance(2);
        this.assertAllLocationsWithRebalance(3);
        this.assertAllLocationsWithRebalance(4);
    }

    public void testRacksMachinesSameMachineName() {
        this.addNode(this.testAddresses[0], "m0", "r0", null);
        this.addNode(this.testAddresses[1], "m0", "r1", null);
        this.addNode(this.testAddresses[2], "m0", "r0", null);
        this.addNode(this.testAddresses[3], "m0", "r2", null);
        this.addNode(this.testAddresses[4], "m0", "r1", null);
        this.addNode(this.testAddresses[5], "m0", "r1", null);
        this.assertAllLocationsWithRebalance(1);
        this.assertAllLocationsWithRebalance(2);
        this.assertAllLocationsWithRebalance(3);
        this.assertAllLocationsWithRebalance(4);
    }

    public void testComplexScenario() {
        this.addNode(this.testAddresses[0], "m2", "r0", "s1");
        this.addNode(this.testAddresses[1], "m1", "r0", "s0");
        this.addNode(this.testAddresses[2], "m1", "r0", "s1");
        this.addNode(this.testAddresses[3], "m1", "r1", "s0");
        this.addNode(this.testAddresses[4], "m0", "r0", "s1");
        this.addNode(this.testAddresses[5], "m0", "r1", "s1");
        this.addNode(this.testAddresses[6], "m0", "r1", "s0");
        this.addNode(this.testAddresses[7], "m0", "r0", "s1");
        this.addNode(this.testAddresses[8], "m0", "r0", "s0");
        this.addNode(this.testAddresses[9], "m0", "r0", "s0");
        this.assertAllLocationsWithRebalance(1);
        this.assertAllLocationsWithRebalance(2);
        this.assertAllLocationsWithRebalance(3);
        this.assertAllLocationsWithRebalance(4);
    }

    public void testComplexScenario2() {
        this.addNode(this.testAddresses[0], "m0", "r0", "s0");
        this.addNode(this.testAddresses[1], "m1", "r0", "s0");
        this.addNode(this.testAddresses[2], "m2", "r0", "s0");
        this.addNode(this.testAddresses[3], "m3", "r1", "s0");
        this.addNode(this.testAddresses[4], "m4", "r1", "s0");
        this.addNode(this.testAddresses[5], "m5", "r1", "s0");
        this.addNode(this.testAddresses[6], "m6", "r2", "s0");
        this.addNode(this.testAddresses[7], "m7", "r2", "s0");
        this.addNode(this.testAddresses[8], "m8", "r2", "s0");
        this.assertAllLocationsWithRebalance(1);
        this.assertAllLocationsWithRebalance(2);
    }

    public void testLoadFactors() {
        try {
            this.capacityFactors = new HashMap<Address, Float>();
            this.capacityFactors.put(this.testAddresses[0], Float.valueOf(2.0f));
            this.capacityFactors.put(this.testAddresses[1], Float.valueOf(0.0f));
            this.capacityFactors.put(this.testAddresses[2], Float.valueOf(1.0f));
            this.capacityFactors.put(this.testAddresses[3], Float.valueOf(2.0f));
            this.capacityFactors.put(this.testAddresses[4], Float.valueOf(0.0f));
            this.capacityFactors.put(this.testAddresses[5], Float.valueOf(1.0f));
            this.capacityFactors.put(this.testAddresses[6], Float.valueOf(2.0f));
            this.capacityFactors.put(this.testAddresses[7], Float.valueOf(0.0f));
            this.capacityFactors.put(this.testAddresses[8], Float.valueOf(1.0f));
            this.addNode(this.testAddresses[0], "m0", "r0", "s0");
            this.addNode(this.testAddresses[1], "m1", "r0", "s0");
            this.addNode(this.testAddresses[2], "m2", "r0", "s0");
            this.addNode(this.testAddresses[3], "m3", "r1", "s0");
            this.addNode(this.testAddresses[4], "m4", "r1", "s0");
            this.addNode(this.testAddresses[5], "m5", "r1", "s0");
            this.addNode(this.testAddresses[6], "m6", "r2", "s0");
            this.addNode(this.testAddresses[7], "m7", "r2", "s0");
            this.addNode(this.testAddresses[8], "m8", "r2", "s0");
            this.assertAllLocationsWithRebalance(1);
            this.assertAllLocationsWithRebalance(2);
            this.assertAllLocationsWithRebalance(3);
        }
        finally {
            this.capacityFactors = null;
        }
    }

    private void assertAllLocationsWithRebalance(int numOwners) {
        this.ch = (DefaultConsistentHash)this.chf.create(numOwners, this.numSegments, this.chMembers, this.capacityFactors);
        List<Address> membersWithLoad = this.computeNodesWithLoad(this.chMembers);
        this.assertAllLocations(membersWithLoad, numOwners);
        this.assertDistribution(membersWithLoad, numOwners);
        this.ch = (DefaultConsistentHash)this.chf.create(numOwners, this.numSegments, this.chMembers.subList(0, 1), this.capacityFactors);
        this.assertAllLocations(this.chMembers.subList(0, 1), numOwners);
        for (int i = 2; i <= this.chMembers.size(); ++i) {
            List<Address> currentMembers = this.chMembers.subList(0, i);
            log.debugf("Created CH with numOwners %d, members %s", numOwners, currentMembers);
            this.ch = (DefaultConsistentHash)this.chf.updateMembers((ConsistentHash)this.ch, currentMembers, this.capacityFactors);
            this.ch = (DefaultConsistentHash)this.chf.rebalance((ConsistentHash)this.ch);
            membersWithLoad = this.computeNodesWithLoad(currentMembers);
            this.assertAllLocations(membersWithLoad, numOwners);
        }
    }

    private List<Address> computeNodesWithLoad(List<Address> nodes) {
        ArrayList<Address> membersWithLoad = new ArrayList<Address>(nodes.size());
        for (Address a : nodes) {
            if (this.capacityFactors != null && !((double)this.capacityFactors.get(a).floatValue() > 0.0)) continue;
            membersWithLoad.add(a);
        }
        return membersWithLoad;
    }

    protected void assertDistribution(List<Address> currentMembers, int numOwners) {
        this.assertDistribution(currentMembers, numOwners, this.numSegments);
    }

    protected void assertDistribution(List<Address> currentMembers, int numOwners, int numSegments) {
        TopologyAwareOwnershipStatistics stats = new TopologyAwareOwnershipStatistics(this.ch);
        log.tracef("Ownership stats: %s", (Object)stats);
        for (Address node : currentMembers) {
            float expectedPrimarySegments = stats.computeExpectedPrimarySegments(node);
            float expectedOwnedSegments = stats.computeExpectedOwnedSegments(node);
            int owned = stats.getOwned(node);
            int primaryOwned = stats.getPrimaryOwned(node);
            Assert.assertTrue((expectedPrimarySegments - 1.0f <= (float)primaryOwned ? 1 : 0) != 0, (String)("Too few primary segments for node " + String.valueOf(node)));
            Assert.assertTrue(((float)primaryOwned <= expectedPrimarySegments + 1.0f ? 1 : 0) != 0, (String)("Too many primary segments for node " + String.valueOf(node)));
            Assert.assertTrue((Math.floor((double)expectedOwnedSegments * 0.7) <= (double)owned ? 1 : 0) != 0, (String)("Too few segments for node " + String.valueOf(node)));
            Assert.assertTrue(((double)owned <= Math.ceil((double)expectedOwnedSegments * 1.25) ? 1 : 0) != 0, (String)("Too many segments for node " + String.valueOf(node)));
        }
    }

    private int countMachines(List<Address> addresses) {
        HashSet<CallSite> machines = new HashSet<CallSite>(addresses.size());
        for (Address a : addresses) {
            TopologyAwareAddress taa = (TopologyAwareAddress)a;
            machines.add((CallSite)((Object)(taa.getMachineId() + taa.getRackId() + taa.getSiteId())));
        }
        return machines.size();
    }

    private int countRacks(List<Address> addresses) {
        HashSet<CallSite> racks = new HashSet<CallSite>(addresses.size());
        for (Address a : addresses) {
            TopologyAwareAddress taa = (TopologyAwareAddress)a;
            racks.add((CallSite)((Object)(taa.getRackId() + taa.getSiteId())));
        }
        return racks.size();
    }

    private int countSites(List<Address> addresses) {
        HashSet<String> sites = new HashSet<String>(addresses.size());
        for (Address a : addresses) {
            TopologyAwareAddress taa = (TopologyAwareAddress)a;
            sites.add(taa.getSiteId());
        }
        return sites.size();
    }

    private void assertAllLocations(List<Address> currentMembers, int numOwners) {
        this.assertAllLocations(currentMembers, numOwners, this.numSegments);
    }

    private void assertAllLocations(List<Address> currentMembers, int numOwners, int numSegments) {
        int expectedOwners = Math.min(numOwners, currentMembers.size());
        int expectedMachines = Math.min(expectedOwners, this.countMachines(currentMembers));
        int expectedRacks = Math.min(expectedOwners, this.countRacks(currentMembers));
        int expectedSites = Math.min(expectedOwners, this.countSites(currentMembers));
        for (int segment = 0; segment < numSegments; ++segment) {
            this.assertSegmentLocation(segment, expectedOwners, expectedMachines, expectedRacks, expectedSites);
        }
    }

    public void testConsistencyWhenNodeLeaves() {
        this.addNode(this.testAddresses[0], "m2", "r0", "s1");
        this.addNode(this.testAddresses[1], "m1", "r0", "s0");
        this.addNode(this.testAddresses[2], "m1", "r0", "s1");
        this.addNode(this.testAddresses[3], "m1", "r1", "s0");
        this.addNode(this.testAddresses[4], "m0", "r0", "s1");
        this.addNode(this.testAddresses[5], "m0", "r1", "s1");
        this.addNode(this.testAddresses[6], "m0", "r1", "s0");
        this.addNode(this.testAddresses[7], "m0", "r0", "s3");
        this.addNode(this.testAddresses[8], "m0", "r0", "s2");
        this.addNode(this.testAddresses[9], "m0", "r0", "s0");
        int numOwners = 3;
        this.updateConsistentHash(numOwners);
        this.assertAllLocations(this.chMembers, numOwners);
        this.assertDistribution(this.chMembers, numOwners);
        for (Address addr : this.chMembers) {
            log.debugf("Removing node %s", (Object)addr);
            ArrayList<Address> addressCopy = new ArrayList<Address>(this.chMembers);
            addressCopy.remove(addr);
            DefaultConsistentHash newCH = (DefaultConsistentHash)this.chf.updateMembers((ConsistentHash)this.ch, addressCopy, null);
            newCH = (DefaultConsistentHash)this.chf.rebalance((ConsistentHash)newCH);
            AtomicInteger movedSegmentsCount = new AtomicInteger(0);
            for (int segment = 0; segment < this.numSegments; ++segment) {
                this.checkConsistency(segment, numOwners, addr, newCH, movedSegmentsCount);
            }
            assert ((double)movedSegmentsCount.get() <= (double)(this.numSegments * numOwners) * 0.1) : String.format("Too many moved segments after leave: %d. CH after leave is: %s\nPrevious: %s", movedSegmentsCount.get(), newCH, this.ch);
        }
    }

    private void checkConsistency(int segment, int replCount, Address removedAddress, DefaultConsistentHash newCH, AtomicInteger movedSegmentsCount) {
        ArrayList removedOwners = new ArrayList(this.ch.locateOwnersForSegment(segment));
        List currentOwners = newCH.locateOwnersForSegment(segment);
        removedOwners.remove(removedAddress);
        removedOwners.removeAll(currentOwners);
        Assert.assertEquals((int)replCount, (int)currentOwners.size(), (String)currentOwners.toString());
        if (!currentOwners.containsAll(removedOwners)) {
            movedSegmentsCount.addAndGet(removedOwners.size());
        }
    }

    private void assertSegmentLocation(int segment, int expectedOwners, int expectedMachines, int expectedRacks, int expectedSites) {
        List received = this.ch.locateOwnersForSegment(segment);
        Assert.assertEquals((int)received.size(), (int)expectedOwners);
        HashSet receivedUnique = new HashSet(received);
        Assert.assertEquals((int)receivedUnique.size(), (int)expectedOwners);
        HashSet<CallSite> receivedMachines = new HashSet<CallSite>();
        for (Object a : received) {
            TopologyAwareAddress taa = (TopologyAwareAddress)a;
            receivedMachines.add((CallSite)((Object)(taa.getMachineId() + "|" + taa.getRackId() + "|" + taa.getSiteId())));
        }
        Assert.assertEquals((int)receivedMachines.size(), (int)expectedMachines);
        HashSet<CallSite> receivedRacks = new HashSet<CallSite>();
        for (Address a : received) {
            TopologyAwareAddress taa = (TopologyAwareAddress)a;
            receivedRacks.add((CallSite)((Object)(taa.getRackId() + "|" + taa.getSiteId())));
        }
        Assert.assertEquals((int)receivedRacks.size(), (int)expectedRacks);
        HashSet<String> receivedSites = new HashSet<String>();
        for (Address a : received) {
            receivedSites.add(((TopologyAwareAddress)a).getSiteId());
        }
        Assert.assertEquals((int)receivedSites.size(), (int)expectedSites);
    }

    private void addNode(TestTopologyAwareAddress address, String machineId, String rackId, String siteId) {
        address.setSiteId(siteId);
        address.setRackId(rackId);
        address.setMachineId(machineId);
        this.chMembers.add(address);
    }

    protected void updateConsistentHash(int numOwners) {
        this.updateConsistentHash(numOwners, this.numSegments);
    }

    private void updateConsistentHash(int numOwners, int numSegments) {
        this.ch = (DefaultConsistentHash)this.chf.create(numOwners, numSegments, this.chMembers, this.capacityFactors);
        log.debugf("Created CH with numOwners %d, members %s", numOwners, this.chMembers);
    }

    @Test(timeOut=10000L)
    public void testSmallNumberOfSegments() {
        int i;
        for (i = 0; i < 3; ++i) {
            this.addNode(this.testAddresses[i], "m0", "r0", "s0");
        }
        this.updateConsistentHash(2, 1);
        this.assertAllLocations(this.chMembers, 2, 1);
        this.assertDistribution(this.chMembers, 2, 1);
        for (i = 3; i < 25; ++i) {
            this.addNode(this.testAddresses[i], "m0", "r0", "s0");
        }
        this.updateConsistentHash(2, 256);
        this.assertAllLocations(this.chMembers, 2, 1);
        this.assertDistribution(this.chMembers, 2, 1);
    }
}

