/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.irac;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.TestOperation;
import org.infinispan.xsite.AbstractMultipleSitesTest;
import org.infinispan.xsite.irac.ManualIracManager;
import org.infinispan.xsite.spi.SiteEntry;
import org.infinispan.xsite.spi.XSiteEntryMergePolicy;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="xsite.irac.IracCustomConflictTest")
public class IracCustomConflictTest
extends AbstractMultipleSitesTest {
    private static final int N_SITES = 2;
    private static final int CLUSTER_SIZE = 3;
    private final List<ManualIracManager> iracManagerList;
    private final ConfigMode site1Config;
    private final ConfigMode site2Config;

    IracCustomConflictTest(ConfigMode site1Config, ConfigMode site2Config) {
        this.site1Config = site1Config;
        this.site2Config = site2Config;
        this.iracManagerList = new ArrayList<ManualIracManager>(6);
    }

    @Factory
    public static Object[] defaultFactory() {
        ConfigMode[] values = ConfigMode.values();
        Object[] tests = new Object[values.length * values.length];
        int i = 0;
        for (ConfigMode s1 : values) {
            for (ConfigMode s2 : values) {
                tests[i++] = new IracCustomConflictTest(s1, s2);
            }
        }
        return tests;
    }

    public void testPutIfAbsent(Method method) {
        this.doTest(method, TestOperation.PUT_IF_ABSENT);
    }

    public void testPut(Method method) {
        this.doTest(method, TestOperation.PUT);
    }

    public void testReplace(Method method) {
        this.doTest(method, TestOperation.REPLACE);
    }

    public void testConditionalReplace(Method method) {
        this.doTest(method, TestOperation.REPLACE_CONDITIONAL);
    }

    public void testRemove(Method method) {
        this.doTest(method, TestOperation.REMOVE);
    }

    public void testConditionalRemove(Method method) {
        this.doTest(method, TestOperation.REMOVE_CONDITIONAL);
    }

    @Override
    protected String[] parameterNames() {
        return new String[]{null, null};
    }

    @Override
    protected Object[] parameterValues() {
        return new Object[]{this.site1Config, this.site2Config};
    }

    @Override
    protected int defaultNumberOfSites() {
        return 2;
    }

    @Override
    protected int defaultNumberOfNodes() {
        return 3;
    }

    @Override
    protected ConfigurationBuilder defaultConfigurationForSite(int siteIndex) {
        ConfigMode configMode = siteIndex == 0 ? this.site1Config : this.site2Config;
        ConfigurationBuilder builder = IracCustomConflictTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC);
        switch (configMode.ordinal()) {
            case 1: {
                builder.transaction().transactionMode(TransactionMode.TRANSACTIONAL).lockingMode(LockingMode.PESSIMISTIC);
                break;
            }
            case 2: {
                builder.transaction().transactionMode(TransactionMode.TRANSACTIONAL).lockingMode(LockingMode.OPTIMISTIC);
                break;
            }
        }
        builder.sites().mergePolicy((XSiteEntryMergePolicy)new CustomEntryMergePolicy());
        for (int i = 0; i < 2; ++i) {
            if (i == siteIndex) continue;
            builder.sites().addBackup().site(this.siteName(i)).strategy(BackupConfiguration.BackupStrategy.ASYNC);
        }
        return builder;
    }

    @Override
    protected GlobalConfigurationBuilder defaultGlobalConfigurationForSite(int siteIndex) {
        GlobalConfigurationBuilder builder = GlobalConfigurationBuilder.defaultClusteredBuilder();
        builder.serialization().addContextInitializer((SerializationContextInitializer)TestDataSCI.INSTANCE);
        return builder;
    }

    @Override
    @AfterMethod(alwaysRun=true)
    protected void clearContent() throws Throwable {
        this.iracManagerList.forEach(iracManager -> iracManager.disable(ManualIracManager.DisableMode.DROP));
        super.clearContent();
    }

    @Override
    protected void afterSitesCreated() {
        for (int i = 0; i < 2; ++i) {
            for (Cache cache : this.caches(this.siteName(i))) {
                this.iracManagerList.add(ManualIracManager.wrapCache(cache));
            }
        }
    }

    private void doTest(Method method, TestOperation testConfig) {
        int i;
        MySortedSet initialValue;
        String key = TestingUtil.k(method, 0);
        if (testConfig != TestOperation.PUT_IF_ABSENT) {
            initialValue = new MySortedSet(new String[]{"a"});
            this.cache(this.siteName(0), 0).put((Object)key, (Object)initialValue);
            this.eventuallyAssertInAllSitesAndCaches(cache -> Objects.equals(initialValue, cache.get((Object)key)));
        } else {
            initialValue = null;
        }
        this.iracManagerList.forEach(ManualIracManager::enable);
        MySortedSet[] finalValues = new MySortedSet[2];
        for (i = 0; i < 2; ++i) {
            MySortedSet newValue;
            MySortedSet mySortedSet = newValue = initialValue == null ? new MySortedSet(new String[]{"a", "site_" + i}) : initialValue.add("site_" + i);
            if (i == 0) {
                finalValues[i] = testConfig.execute(this.cache(this.siteName(i), 0), key, initialValue, newValue);
                continue;
            }
            this.cache(this.siteName(i), 0).put((Object)key, (Object)newValue);
            finalValues[i] = newValue;
        }
        for (i = 0; i < 2; ++i) {
            MySortedSet fValue = finalValues[i];
            this.assertInSite(this.siteName(i), cache -> AssertJUnit.assertEquals((Object)fValue, (Object)cache.get((Object)key)));
        }
        this.iracManagerList.forEach(manualIracManager -> manualIracManager.disable(ManualIracManager.DisableMode.SEND));
        MySortedSet finalValue = testConfig == TestOperation.REMOVE || testConfig == TestOperation.REMOVE_CONDITIONAL ? new MySortedSet(new String[]{"a", "site_1"}) : new MySortedSet(new String[]{"a", "site_0", "site_1"});
        this.eventuallyAssertInAllSitesAndCaches(cache -> Objects.equals(finalValue, cache.get((Object)key)));
        this.assertNoDataLeak(null);
    }

    private static enum ConfigMode {
        NO_TX,
        P_TX,
        O_TX;

    }

    public static class CustomEntryMergePolicy
    implements XSiteEntryMergePolicy<String, MySortedSet> {
        public CompletionStage<SiteEntry<MySortedSet>> merge(String key, SiteEntry<MySortedSet> localEntry, SiteEntry<MySortedSet> remoteEntry) {
            MySortedSet remote;
            MySortedSet local = (MySortedSet)localEntry.getValue();
            if (local == (remote = (MySortedSet)remoteEntry.getValue())) {
                return CompletableFuture.completedFuture(this.compare(localEntry, remoteEntry) < 0 ? localEntry : remoteEntry);
            }
            if (local == null) {
                return CompletableFuture.completedFuture(remoteEntry);
            }
            if (remote == null) {
                return CompletableFuture.completedFuture(localEntry);
            }
            MySortedSet result = local.addAll(remote);
            String site = this.compare(localEntry, remoteEntry) < 0 ? localEntry.getSiteName() : remoteEntry.getSiteName();
            return CompletableFuture.completedFuture(new SiteEntry(site, (Object)result, null));
        }

        private int compare(SiteEntry<MySortedSet> local, SiteEntry<MySortedSet> remote) {
            return local.getSiteName().compareTo(remote.getSiteName());
        }
    }

    public static class MySortedSet {
        private final String[] data;

        @ProtoFactory
        public MySortedSet(String[] data) {
            this.data = Objects.requireNonNull(data);
        }

        public boolean contains(String element) {
            return Arrays.binarySearch(this.data, element) >= 0;
        }

        public MySortedSet add(String element) {
            if (this.contains(element)) {
                return this;
            }
            Object[] newData = Arrays.copyOf(this.data, this.data.length + 1);
            newData[this.data.length] = element;
            Arrays.sort(newData);
            return new MySortedSet((String[])newData);
        }

        public MySortedSet addAll(MySortedSet other) {
            LinkedList<String> newElements = new LinkedList<String>();
            for (String e : other.data) {
                if (this.contains(e)) continue;
                newElements.add(e);
            }
            if (newElements.isEmpty()) {
                return this;
            }
            Object[] newData = Arrays.copyOf(this.data, this.data.length + newElements.size());
            int i = this.data.length;
            for (String e : newElements) {
                newData[i++] = e;
            }
            Arrays.sort(newData);
            return new MySortedSet((String[])newData);
        }

        @ProtoField(number=1)
        public String[] getData() {
            return this.data;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MySortedSet that = (MySortedSet)o;
            return Arrays.equals(this.data, that.data);
        }

        public int hashCode() {
            return Arrays.hashCode(this.data);
        }
    }
}

