/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.impl.TransactionTable;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.RemoteTxNotCreatedOnGetTest")
public class RemoteTxNotCreatedOnGetTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder dcc = RemoteTxNotCreatedOnGetTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        dcc.clustering().l1().disable().hash().numOwners(1);
        this.createCluster(TestDataSCI.INSTANCE, dcc, 2);
        this.waitForClusterToForm();
    }

    public void testRemoteTxCreation() throws Throwable {
        Object key = this.getKeyForCache(1);
        this.cache(1).put(key, (Object)"v");
        Assert.assertEquals((Object)"v", (Object)this.cache(0).get(key));
        Assert.assertEquals((Object)"v", (Object)this.cache(1).get(key));
        Thread.sleep(1000L);
        TransactionTable tt1 = TestingUtil.getTransactionTable(this.cache(1));
        Assert.assertEquals((int)tt1.getRemoteTransactions().size(), (int)0);
        this.tm(0).begin();
        log.trace((Object)"Before going remotely");
        this.cache(0).get(key);
        Assert.assertEquals((int)tt1.getRemoteTransactions().size(), (int)0);
        this.tm(0).commit();
    }
}

