/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import org.infinispan.Cache;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.distribution.MagicKey;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;
import org.infinispan.transaction.tm.EmbeddedTransaction;
import org.infinispan.transaction.tm.EmbeddedTransactionManager;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="statetransfer.TxDuringStateTransferTest")
@CleanupAfterMethod
public class TxDuringStateTransferTest
extends MultipleCacheManagersTest {
    private static final String INITIAL_VALUE = "v1";
    private static final String FINAL_VALUE = "v2";

    public void testPut() throws Exception {
        this.performTest(Operation.PUT);
    }

    public void testRemove() throws Exception {
        this.performTest(Operation.REMOVE);
    }

    public void testReplace() throws Exception {
        this.performTest(Operation.REPLACE);
    }

    public void testConditionalPut() throws Exception {
        this.performTest(Operation.CONDITIONAL_PUT);
    }

    public void testConditionalRemove() throws Exception {
        this.performTest(Operation.CONDITIONAL_REMOVE);
    }

    public void testConditionalReplace() throws Exception {
        this.performTest(Operation.CONDITIONAL_REPLACE);
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = TxDuringStateTransferTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        builder.transaction().transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup()).useSynchronization(false).recovery().disable();
        builder.clustering().stateTransfer().fetchInMemoryState(true).hash().numOwners(3);
        this.createClusteredCaches(4, TestDataSCI.INSTANCE, builder);
    }

    private void performTest(Operation operation) throws Exception {
        this.assertClusterSize("Wrong number of caches.", 4);
        MagicKey key = new MagicKey(this.cache(0), this.cache(1), this.cache(2));
        operation.init(this.cache(0), key);
        EmbeddedTransactionManager transactionManager = (EmbeddedTransactionManager)this.tm(0);
        transactionManager.begin();
        operation.perform(this.cache(0), key);
        EmbeddedTransaction transaction = transactionManager.getTransaction();
        transaction.runPrepare();
        AssertJUnit.assertEquals((String)"Wrong transaction status before killing backup owner.", (int)2, (int)transaction.getStatus());
        this.killMember(1);
        AssertJUnit.assertEquals((String)"Wrong transaction status after killing backup owner.", (int)2, (int)transaction.getStatus());
        transaction.runCommit(false);
        for (Cache cache : this.caches()) {
            operation.check(cache, key, String.valueOf(this.address(cache)));
        }
    }

    private static enum Operation {
        PUT,
        REMOVE,
        REPLACE,
        CONDITIONAL_PUT,
        CONDITIONAL_REMOVE,
        CONDITIONAL_REPLACE;


        public final void init(Cache<Object, Object> cache, Object key) {
            if (this != CONDITIONAL_PUT) {
                cache.put(key, (Object)TxDuringStateTransferTest.INITIAL_VALUE);
            }
        }

        public final void perform(Cache<Object, Object> cache, Object key) {
            switch (this.ordinal()) {
                case 0: {
                    cache.put(key, (Object)TxDuringStateTransferTest.FINAL_VALUE);
                    break;
                }
                case 1: {
                    cache.remove(key);
                    break;
                }
                case 2: {
                    cache.replace(key, (Object)TxDuringStateTransferTest.FINAL_VALUE);
                    break;
                }
                case 3: {
                    cache.putIfAbsent(key, (Object)TxDuringStateTransferTest.FINAL_VALUE);
                    break;
                }
                case 4: {
                    cache.remove(key, (Object)TxDuringStateTransferTest.INITIAL_VALUE);
                    break;
                }
                case 5: {
                    cache.replace(key, (Object)TxDuringStateTransferTest.INITIAL_VALUE, (Object)TxDuringStateTransferTest.FINAL_VALUE);
                }
            }
        }

        public final void check(Cache<Object, Object> cache, Object key, String cacheAddress) {
            DataContainer dataContainer = cache.getAdvancedCache().getDataContainer();
            if (this == REMOVE || this == CONDITIONAL_REMOVE) {
                AssertJUnit.assertFalse((String)("Key was not removed in '" + cacheAddress + "'!"), (boolean)dataContainer.containsKey(key));
            } else {
                InternalCacheEntry entry = dataContainer.get(key);
                AssertJUnit.assertNotNull((String)("Cache '" + cacheAddress + "' does not contains entry!"), (Object)entry);
                AssertJUnit.assertEquals((String)("Cache '" + cacheAddress + "' has wrong value!"), (Object)TxDuringStateTransferTest.FINAL_VALUE, (Object)entry.getValue());
            }
        }
    }
}

