/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence;

import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.distribution.Ownership;
import org.infinispan.persistence.ClusteredConditionalCommandTest;
import org.infinispan.test.fwk.InCacheMode;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.ClusteredTxConditionalCommandPassivationTest")
@InCacheMode(value={CacheMode.DIST_SYNC})
public class ClusteredTxConditionalCommandPassivationTest
extends ClusteredConditionalCommandTest {
    public ClusteredTxConditionalCommandPassivationTest() {
        super(true, true);
    }

    @Override
    protected <K, V> void assertLoadAfterOperation(ClusteredConditionalCommandTest.CacheHelper<K, V> cacheHelper, ClusteredConditionalCommandTest.ConditionalOperation operation, Ownership ownership, boolean skipLoad) {
        switch (ownership) {
            case PRIMARY: {
                this.assertLoad(cacheHelper, skipLoad ? 0 : 1, 0, 0);
                break;
            }
            case BACKUP: {
                this.assertLoad(cacheHelper, 0, skipLoad ? 0 : 1, 0);
                break;
            }
            case NON_OWNER: {
                if (skipLoad) {
                    this.assertLoad(cacheHelper, 0, 0, 0);
                    break;
                }
                long primaryLoads = cacheHelper.loads(Ownership.PRIMARY);
                AssertJUnit.assertTrue((String)("primary owner load: " + primaryLoads), (primaryLoads <= 1L ? 1 : 0) != 0);
                long backupLoads = cacheHelper.loads(Ownership.BACKUP);
                AssertJUnit.assertTrue((String)("backup owner load: " + backupLoads), (backupLoads <= 1L ? 1 : 0) != 0);
                AssertJUnit.assertTrue((String)("loads: primary=" + primaryLoads + ", backup=" + backupLoads), (primaryLoads + backupLoads >= 1L ? 1 : 0) != 0);
                AssertJUnit.assertEquals((String)"non owner load", (long)0L, (long)cacheHelper.loads(Ownership.NON_OWNER));
            }
        }
    }
}

