/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.partitionhandling;

import java.util.HashSet;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.distribution.MagicKey;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.partitionhandling.BasePartitionHandlingTest;
import org.infinispan.partitionhandling.impl.PartitionHandlingManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="partitionhandling.ThreeNodesReplicatedSplitAndMergeTest")
public class ThreeNodesReplicatedSplitAndMergeTest
extends BasePartitionHandlingTest {
    public ThreeNodesReplicatedSplitAndMergeTest() {
        this.numMembersInCluster = 3;
        this.cacheMode = CacheMode.REPL_SYNC;
    }

    public void testSplitAndMerge0() throws Exception {
        this.testSplitAndMerge(new BasePartitionHandlingTest.PartitionDescriptor(0, 1), new BasePartitionHandlingTest.PartitionDescriptor(2));
    }

    public void testSplitAndMerge1() throws Exception {
        this.testSplitAndMerge(new BasePartitionHandlingTest.PartitionDescriptor(0, 2), new BasePartitionHandlingTest.PartitionDescriptor(1));
    }

    public void testSplitAndMerge2() throws Exception {
        this.testSplitAndMerge(new BasePartitionHandlingTest.PartitionDescriptor(1, 2), new BasePartitionHandlingTest.PartitionDescriptor(0));
    }

    private void testSplitAndMerge(BasePartitionHandlingTest.PartitionDescriptor p0, BasePartitionHandlingTest.PartitionDescriptor p1) throws Exception {
        MagicKey k0 = new MagicKey(this.cache(p0.node(0)), this.cache(p0.node(1)));
        this.cache(0).put((Object)k0, (Object)"v0");
        MagicKey k1 = new MagicKey(this.cache(p0.node(1)), this.cache(p1.node(0)));
        this.cache(1).put((Object)k1, (Object)"v1");
        MagicKey k2 = new MagicKey(this.cache(p1.node(0)), this.cache(p0.node(0)));
        this.cache(2).put((Object)k2, (Object)"v2");
        HashSet<Address> allMembers = new HashSet<Address>(this.advancedCache(0).getRpcManager().getMembers());
        this.assertStableTopologyMembers(allMembers, this.partitionHandlingManager(0));
        this.assertStableTopologyMembers(allMembers, this.partitionHandlingManager(1));
        this.assertStableTopologyMembers(allMembers, this.partitionHandlingManager(2));
        for (int i = 0; i < this.numMembersInCluster; ++i) {
            AssertJUnit.assertEquals((Object)AvailabilityMode.AVAILABLE, (Object)this.partitionHandlingManager(i).getAvailabilityMode());
        }
        this.splitCluster(p0.getNodes(), p1.getNodes());
        TestingUtil.waitForNoRebalance(this.cache(p0.node(0)), this.cache(p0.node(1)));
        this.partition(0).assertAvailabilityMode(AvailabilityMode.AVAILABLE);
        this.partition(1).assertAvailabilityMode(AvailabilityMode.DEGRADED_MODE);
        this.assertStableTopologyMembers(allMembers, this.partitionHandlingManager(p1.node(0)));
        this.partition(0).assertKeyAvailableForRead(k0, "v0");
        this.partition(0).assertKeyAvailableForRead(k1, "v1");
        this.partition(0).assertKeyAvailableForRead(k2, "v2");
        this.partition(1).assertKeysNotAvailableForRead(k0, k1, k2);
        AssertJUnit.assertTrue((boolean)this.dataContainer(p0.node(0)).containsKey((Object)k0));
        AssertJUnit.assertTrue((boolean)this.dataContainer(p0.node(0)).containsKey((Object)k1));
        AssertJUnit.assertTrue((boolean)this.dataContainer(p0.node(0)).containsKey((Object)k2));
        AssertJUnit.assertTrue((boolean)this.dataContainer(p0.node(1)).containsKey((Object)k0));
        AssertJUnit.assertTrue((boolean)this.dataContainer(p0.node(1)).containsKey((Object)k1));
        AssertJUnit.assertTrue((boolean)this.dataContainer(p0.node(1)).containsKey((Object)k2));
        AssertJUnit.assertTrue((boolean)this.dataContainer(p1.node(0)).containsKey((Object)k0));
        AssertJUnit.assertTrue((boolean)this.dataContainer(p1.node(0)).containsKey((Object)k1));
        AssertJUnit.assertTrue((boolean)this.dataContainer(p1.node(0)).containsKey((Object)k2));
        this.partition(0).assertKeyAvailableForWrite(k0, "v00");
        this.partition(0).assertKeyAvailableForWrite(k1, "v11");
        this.partition(0).assertKeyAvailableForWrite(k2, "v22");
        this.partition(1).assertKeyNotAvailableForWrite(k0);
        this.partition(1).assertKeyNotAvailableForWrite(k1);
        this.partition(1).assertKeyNotAvailableForWrite(k2);
        this.partition(0).merge(this.partition(1));
        this.expectStableTopologyMembers(allMembers, this.partitionHandlingManager(0));
        this.expectStableTopologyMembers(allMembers, this.partitionHandlingManager(1));
        this.expectStableTopologyMembers(allMembers, this.partitionHandlingManager(2));
        this.partition(0).assertAvailabilityMode(AvailabilityMode.AVAILABLE);
        this.assertExpectedValue("v00", k0);
        this.assertExpectedValue("v11", k1);
        this.assertExpectedValue("v22", k2);
        AssertJUnit.assertTrue((boolean)this.dataContainer(p0.node(0)).containsKey((Object)k0));
        AssertJUnit.assertTrue((boolean)this.dataContainer(p0.node(0)).containsKey((Object)k1));
        AssertJUnit.assertTrue((boolean)this.dataContainer(p0.node(0)).containsKey((Object)k2));
        AssertJUnit.assertTrue((boolean)this.dataContainer(p0.node(1)).containsKey((Object)k0));
        AssertJUnit.assertTrue((boolean)this.dataContainer(p0.node(1)).containsKey((Object)k1));
        AssertJUnit.assertTrue((boolean)this.dataContainer(p0.node(1)).containsKey((Object)k2));
        AssertJUnit.assertTrue((boolean)this.dataContainer(p1.node(0)).containsKey((Object)k0));
        AssertJUnit.assertTrue((boolean)this.dataContainer(p1.node(0)).containsKey((Object)k1));
        AssertJUnit.assertTrue((boolean)this.dataContainer(p1.node(0)).containsKey((Object)k2));
        this.cache(0).put((Object)k0, (Object)"v000");
        this.cache(1).put((Object)k1, (Object)"v111");
        this.cache(2).put((Object)k2, (Object)"v222");
        this.assertExpectedValue("v000", k0);
        this.assertExpectedValue("v111", k1);
        this.assertExpectedValue("v222", k2);
        AssertJUnit.assertNull((Object)this.cache(0).get((Object)"nonExistentKey"));
    }

    private void assertStableTopologyMembers(HashSet<Address> allMembers, PartitionHandlingManager phm) {
        AssertJUnit.assertEquals(allMembers, new HashSet(phm.getLastStableTopology().getMembers()));
    }

    private void expectStableTopologyMembers(HashSet<Address> expected, PartitionHandlingManager phm) {
        this.eventuallyEquals(expected, () -> new HashSet(phm.getLastStableTopology().getMembers()));
    }
}

