/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.exts;

import org.infinispan.commons.IllegalLifecycleStateException;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.core.GlobalMarshaller;
import org.infinispan.remoting.RemoteException;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="marshall.RemoteExceptionExternalizerTest")
public class RemoteExceptionExternalizerTest
extends SingleCacheManagerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        return TestCacheManagerFactory.createCacheManager();
    }

    public void testKnownThrowable() throws Exception {
        GlobalMarshaller marshaller = TestingUtil.extractGlobalMarshaller(this.cacheManager);
        Throwable cause = new IllegalStateException(IllegalStateException.class.getSimpleName());
        cause.addSuppressed(new IllegalArgumentException(IllegalArgumentException.class.getSimpleName()));
        cause.addSuppressed(new IllegalStateException(IllegalStateException.class.getSimpleName()));
        cause.addSuppressed(new IllegalLifecycleStateException(IllegalLifecycleStateException.class.getSimpleName()));
        RemoteException remoteException = new RemoteException(RemoteException.class.getSimpleName(), cause);
        byte[] bytes = marshaller.objectToByteBuffer((Object)remoteException);
        remoteException = (RemoteException)((Object)marshaller.objectFromByteBuffer(bytes));
        cause = remoteException.getCause();
        AssertJUnit.assertEquals((String)cause.getMessage(), (String)IllegalStateException.class.getSimpleName());
        AssertJUnit.assertEquals((String)cause.getSuppressed()[0].getMessage(), (String)IllegalArgumentException.class.getSimpleName());
        AssertJUnit.assertEquals((String)cause.getSuppressed()[1].getMessage(), (String)IllegalStateException.class.getSimpleName());
        AssertJUnit.assertEquals((String)cause.getSuppressed()[2].getMessage(), (String)IllegalLifecycleStateException.class.getSimpleName());
    }

    public void testGenericThrowable() throws Exception {
        GlobalMarshaller marshaller = TestingUtil.extractGlobalMarshaller(this.cacheManager);
        IllegalStateException exception = new IllegalStateException(IllegalStateException.class.getSimpleName());
        exception.addSuppressed(new IllegalArgumentException(IllegalArgumentException.class.getSimpleName()));
        exception.addSuppressed(new IllegalStateException(IllegalStateException.class.getSimpleName()));
        byte[] bytes = marshaller.objectToByteBuffer((Object)exception);
        exception = (IllegalStateException)marshaller.objectFromByteBuffer(bytes);
        AssertJUnit.assertEquals((String)exception.getMessage(), (String)IllegalStateException.class.getSimpleName());
        AssertJUnit.assertEquals((String)exception.getSuppressed()[0].getMessage(), (String)IllegalArgumentException.class.getSimpleName());
        AssertJUnit.assertEquals((String)exception.getSuppressed()[1].getMessage(), (String)IllegalStateException.class.getSimpleName());
    }
}

